/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.database.jooq.listener;

import java.util.function.BiConsumer;
import lombok.Generated;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.Query;
import pro.fessional.mirana.time.StopWatch;
import pro.fessional.wings.silencer.watch.Watches;

public class SlowSqlListener
implements ExecuteListener {
    private String token = "SlowSqlListener";
    private long thresholdMillis = -1L;
    private BiConsumer<Long, String> costAndSqlConsumer = (c, s) -> Watches.log.warn("SLOW-SQL cost={}ms, sql={}", c, s);

    public void start(ExecuteContext ctx) {
        if (this.thresholdMillis < 0L) {
            return;
        }
        Object name = "JooqSlowSql:";
        Query query = ctx.query();
        if (query != null) {
            name = (String)name + query.getClass().getSimpleName();
        }
        StopWatch.Watch watch = Watches.acquire((String)name);
        ctx.data((Object)ContextKey.EXECUTING_STOP_WATCH, (Object)watch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(ExecuteContext ctx) {
        StopWatch.Watch watch = (StopWatch.Watch)ctx.data((Object)ContextKey.EXECUTING_STOP_WATCH);
        if (watch == null) {
            return;
        }
        watch.close();
        long cost = watch.getElapseMs();
        boolean slow = cost >= this.thresholdMillis;
        try {
            if (slow) {
                this.costAndSqlConsumer.accept(cost, ctx.sql());
            }
            Watches.release((boolean)true, (String)(slow ? this.token : null));
        }
        catch (Throwable throwable) {
            Watches.release((boolean)true, (String)(slow ? this.token : null));
            throw throwable;
        }
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public long getThresholdMillis() {
        return this.thresholdMillis;
    }

    @Generated
    public BiConsumer<Long, String> getCostAndSqlConsumer() {
        return this.costAndSqlConsumer;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public void setThresholdMillis(long thresholdMillis) {
        this.thresholdMillis = thresholdMillis;
    }

    @Generated
    public void setCostAndSqlConsumer(BiConsumer<Long, String> costAndSqlConsumer) {
        this.costAndSqlConsumer = costAndSqlConsumer;
    }

    public static enum ContextKey {
        EXECUTING_STOP_WATCH;

    }
}

