/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.spring.bean;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.VisitListener;
import org.jooq.VisitListenerProvider;
import org.jooq.conf.Settings;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.jooq.impl.DefaultVisitListenerProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pro.fessional.wings.faceless.database.WingsTableCudHandler;
import pro.fessional.wings.faceless.database.jooq.helper.JournalDiffHelper;
import pro.fessional.wings.faceless.database.jooq.listener.JournalDeleteListener;
import pro.fessional.wings.faceless.database.jooq.listener.TableCudListener;
import pro.fessional.wings.faceless.spring.prop.FacelessJooqCudProp;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
@ConditionalOnClass(value={Settings.class})
public class FacelessJooqCudConfiguration {
    private static final Log log = LogFactory.getLog(FacelessJooqCudConfiguration.class);

    @Bean
    @ConditionalWingsEnabled(abs="wings.faceless.jooq.conf.journal-delete", value=false)
    public ExecuteListenerProvider jooqJournalDeleteListener() {
        log.info((Object)"FacelessJooq spring-bean jooqJournalDeleteListener");
        return new DefaultExecuteListenerProvider((ExecuteListener)new JournalDeleteListener());
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalWingsEnabled
    public static class JournalDiffWired {
        @Autowired
        public void auto(@NotNull FacelessJooqCudProp prop) {
            log.info((Object)"FacelessJooq spring-auto initJournalDiffHelper");
            JournalDiffHelper.putDefaultIgnore(prop.getDiff());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalWingsEnabled(abs="wings.faceless.jooq.conf.listen-cud")
    public static class CudListenerBean {
        @Bean
        public VisitListenerProvider jooqTableCudListener(FacelessJooqCudProp prop, List<WingsTableCudHandler> handlers) {
            TableCudListener listener = new TableCudListener();
            String names = handlers.stream().map(it -> it.getClass().getName()).collect(Collectors.joining(","));
            log.info((Object)("FacelessJooq spring-bean jooqTableCudListener with handler=" + names));
            for (WingsTableCudHandler handler : handlers) {
                handler.register(listener);
            }
            listener.setHandlers(handlers);
            listener.setCreate(prop.isCreate());
            listener.setUpdate(prop.isUpdate());
            listener.setDelete(prop.isDelete());
            listener.setTableField(prop.getTable());
            return new DefaultVisitListenerProvider((VisitListener)listener);
        }
    }
}

