/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.database.jooq;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.BatchBindStep;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertOnDuplicateSetMoreStep;
import org.jooq.InsertOnDuplicateSetStep;
import org.jooq.InsertReturningStep;
import org.jooq.Loader;
import org.jooq.LoaderOptionsStep;
import org.jooq.OrderField;
import org.jooq.Query;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.RecordMapper;
import org.jooq.Result;
import org.jooq.SelectConditionStep;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.UpdatableRecord;
import org.jooq.impl.DAOImpl;
import org.jooq.impl.TableImpl;
import pro.fessional.mirana.best.AssertCrud;
import pro.fessional.mirana.cast.TypedCastUtil;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.pain.IORuntimeException;
import pro.fessional.wings.faceless.database.helper.DatabaseChecker;
import pro.fessional.wings.faceless.database.jooq.WingsAliasTable;
import pro.fessional.wings.faceless.database.jooq.WingsJooqEnv;
import pro.fessional.wings.faceless.database.jooq.WingsJooqUtil;
import pro.fessional.wings.faceless.database.jooq.helper.JournalDiffHelper;
import pro.fessional.wings.faceless.database.jooq.support.SelectOrder;
import pro.fessional.wings.faceless.database.jooq.support.SelectWhereOrder;
import pro.fessional.wings.faceless.service.journal.JournalDiff;

public abstract class WingsJooqDaoAliasImpl<T extends Table<R> & WingsAliasTable<T>, R extends UpdatableRecord<R>, P, K>
extends DAOImpl<R, P, K> {
    protected final T table;
    protected final Field<?>[] pkeys;
    protected volatile int tableExist = -1;
    protected volatile Supplier<DSLContext> dslSup = null;
    private final BiPredicate<Object, Object> caseIgnore = (o1, o2) -> {
        if (o1 instanceof String) {
            String s1 = (String)o1;
            if (o2 instanceof String) {
                String s2 = (String)o2;
                return s1.equalsIgnoreCase(s2);
            }
        }
        return o1.equals(o2);
    };
    private final BiFunction<DSLContext, Collection<R>, int[]> batchInsertExec = (dsl, rs) -> dsl.batchInsert(rs).execute();
    private final BiFunction<DSLContext, Collection<R>, int[]> batchStoreExec = (dsl, rs) -> dsl.batchStore(rs).execute();
    private final BiFunction<DSLContext, Collection<R>, int[]> batchUpdateExec = (dsl, rs) -> dsl.batchUpdate(rs).execute();

    protected WingsJooqDaoAliasImpl(T table, Class<P> type) {
        this(table, type, null);
    }

    protected WingsJooqDaoAliasImpl(T table, Class<P> type, Configuration conf) {
        super(table, type, conf);
        this.table = table;
        this.pkeys = WingsJooqUtil.primaryKeys(table);
    }

    @NotNull
    public DSLContext ctx() {
        if (this.dslSup == null) {
            return super.ctx();
        }
        DSLContext dsl = this.dslSup.get();
        return dsl != null ? dsl : super.ctx();
    }

    public void setDslContext(@Nullable Supplier<DSLContext> sup) {
        this.dslSup = sup;
    }

    public void setTableExist(int type) {
        this.tableExist = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notTableExist() {
        if (this.tableExist < 0) {
            WingsJooqDaoAliasImpl wingsJooqDaoAliasImpl = this;
            synchronized (wingsJooqDaoAliasImpl) {
                if (this.tableExist < 0) {
                    try {
                        this.ctx().connection(conn -> {
                            this.tableExist = DatabaseChecker.existTable((Connection)conn, (String)this.table.getName()) ? 1 : 0;
                        });
                    }
                    catch (Exception e) {
                        ++this.tableExist;
                    }
                }
            }
        }
        return this.tableExist <= 0;
    }

    @NotNull
    public T newTable(String name) {
        return (T)((TableImpl)this.table).rename(name);
    }

    @NotNull
    public T newTable(String prefix, String postfix) {
        return this.newTable(prefix + this.table.getName() + postfix);
    }

    @NotNull
    public T getAlias(String alias) {
        return (T)this.table.as(alias);
    }

    @NotNull
    public T getTable() {
        return this.table;
    }

    @NotNull
    public T getAlias() {
        return (T)((Table)((WingsAliasTable)this.table).getAliasTable());
    }

    @NotNull
    public R newRecord(Object obj) {
        return (R)((UpdatableRecord)this.ctx().newRecord(this.table, obj));
    }

    @NotNull
    public List<R> newRecord(Collection<P> pos) {
        DSLContext ctx = this.ctx();
        return pos.stream().map(it -> (UpdatableRecord)ctx.newRecord(this.table, it)).collect(Collectors.toList());
    }

    @NotNull
    public Loader<R> batchLoad(Collection<R> records, boolean ignoreOrReplace) {
        this.checkBatchMysql();
        DSLContext dsl = this.ctx();
        LoaderOptionsStep ldi = dsl.loadInto(this.table);
        ldi = ignoreOrReplace ? ldi.onDuplicateKeyIgnore() : ldi.onDuplicateKeyUpdate();
        try {
            return ldi.loadRecords(records).fields(this.table.fields()).execute();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    private void checkBatchMysql() {
        if (WingsJooqEnv.daoBatchMysql) {
            throw new IllegalStateException("Use #batchInsert(Collection<R>, int, boolean) instead. `insert ignore` and `replace into` are more efficient mysql statements than `from dual where exists` and `on duplicate key update`");
        }
    }

    public int insertInto(P pojo, boolean ignoreOrReplace) {
        return this.insertInto(pojo, ignoreOrReplace, null);
    }

    @NotNull
    public JournalDiff diffInsert(P pojo) {
        return this.diffInsert(pojo, false);
    }

    @NotNull
    public JournalDiff diffInsert(P pojo, boolean ignoreOrReplace) {
        JournalDiff diff = new JournalDiff();
        diff.setTable(this.table.getName());
        diff.setTyped(true);
        this.insertInto(pojo, ignoreOrReplace, diff);
        return diff;
    }

    private int insertInto(P pojo, boolean ignoreOrReplace, JournalDiff diff) {
        DSLContext dsl = this.ctx();
        UpdatableRecord record = (UpdatableRecord)dsl.newRecord(this.table, pojo);
        Field[] fields = this.table.fields();
        Object[] values = record.intoArray();
        int rc = ignoreOrReplace ? dsl.insertInto(this.table).columns(fields).values(values).onDuplicateKeyIgnore().execute() : dsl.insertInto(this.table).columns(fields).values(values).onDuplicateKeyUpdate().set((Record)record).execute();
        if (diff != null) {
            Condition cond = null;
            for (Field<?> pk : this.pkeys) {
                Object v = record.get(pk);
                Condition c = pk.eq(v);
                cond = cond == null ? c : cond.and(c);
            }
            Result rs2 = dsl.selectFrom(this.table).where(cond).fetch();
            AssertCrud.selectEq((int)rs2.size(), (int)1);
            JournalDiffHelper.helpInsert(diff, (Result<? extends Record>)rs2);
        }
        return rc;
    }

    public int @NotNull [] insertInto(Collection<P> pos, boolean ignoreOrReplace) {
        return this.batchInsert(this.newRecord(pos), 0, ignoreOrReplace);
    }

    public int mergeInto(P pojo, Function<T, Field<?>[]> fun) {
        return this.mergeInto(this.table, pojo, fun.apply(this.table));
    }

    public int mergeInto(T table, P pojo, Field<?> ... updateFields) {
        LinkedHashMap map = new LinkedHashMap();
        DSLContext dsl = this.ctx();
        UpdatableRecord record = (UpdatableRecord)dsl.newRecord(table, pojo);
        for (Field<?> field : updateFields) {
            Object t = record.get(field);
            map.put(field, t);
        }
        return dsl.insertInto(table).columns(table.fields()).values(record.intoArray()).onDuplicateKeyUpdate().set(map).execute();
    }

    public int @NotNull [] batchMerge(Collection<R> records, int size, Function<T, Field<?>[]> fun) {
        return this.batchMerge(this.table, records, size, fun.apply(this.table));
    }

    public int @NotNull [] batchMerge(T table, Collection<R> records, int size, Field<?> ... updateFields) {
        if (records == null || records.isEmpty()) {
            return Null.Ints;
        }
        BiFunction<DSLContext, Collection<R>, int[]> batchMergeExec = (dsl, rs) -> {
            LinkedHashMap<Field, Object> map = new LinkedHashMap<Field, Object>();
            for (Field field : updateFields) {
                map.put(field, null);
            }
            Field[] fields = table.fields();
            int fldLen = fields.length;
            int updLen = updateFields.length;
            BatchBindStep batch = dsl.batch((Query)dsl.insertInto(table).columns(fields).values(new Object[fldLen]).onDuplicateKeyUpdate().set(map));
            for (UpdatableRecord r : rs) {
                int i;
                Object[] vals = new Object[fldLen + updLen];
                for (i = 0; i < fldLen; ++i) {
                    vals[i] = r.get(i);
                }
                for (i = 0; i < updLen; ++i) {
                    vals[i + fldLen] = r.get(updateFields[i]);
                }
                batch = batch.bind(vals);
            }
            return batch.execute();
        };
        return this.batchExecute(records, size, batchMergeExec);
    }

    public int @NotNull [] batchMerge(T table, Field<?>[] keys, Collection<R> records, int size, Field<?> ... updateFields) {
        return this.batchMerge(table, keys, this.caseIgnore, records, size, updateFields);
    }

    public int @NotNull [] batchMerge(T table, Field<?>[] keys, BiPredicate<Object, Object> equals, Collection<R> records, int size, Field<?> ... updateFields) {
        if (records == null || records.isEmpty()) {
            return Null.Ints;
        }
        DSLContext dsl = this.ctx();
        int[] result = new int[records.size()];
        int off = 0;
        ArrayList<UpdatableRecord> upd = new ArrayList<UpdatableRecord>(size);
        ArrayList<UpdatableRecord> ins = new ArrayList<UpdatableRecord>(size);
        for (List<R> rcds : this.partition(records, size)) {
            int[] r;
            upd.clear();
            ins.clear();
            Condition where = null;
            for (UpdatableRecord rcd : rcds) {
                Condition cand = null;
                for (Field<?> key : keys) {
                    Object o = rcd.get(key);
                    cand = cand == null ? key.eq(o) : cand.and(key.eq(o));
                }
                if (where == null) {
                    where = cand;
                    continue;
                }
                where = where.or(cand);
            }
            Result res = dsl.select(keys).from(table).where(where).fetch();
            ArrayList tmp = new ArrayList(res);
            for (UpdatableRecord rcd : rcds) {
                boolean has = false;
                Iterator it = tmp.iterator();
                while (it.hasNext()) {
                    Record d = (Record)it.next();
                    int eq = 0;
                    for (int i = 0; i < keys.length; ++i) {
                        if (!equals.test(rcd.get(keys[i]), d.get(i))) continue;
                        ++eq;
                    }
                    if (eq != keys.length) continue;
                    it.remove();
                    has = true;
                    break;
                }
                if (has) {
                    upd.add(rcd);
                    continue;
                }
                ins.add(rcd);
            }
            if (!ins.isEmpty()) {
                r = this.batchInsert(ins, size);
                System.arraycopy(r, 0, result, off, r.length);
                off += r.length;
            }
            if (upd.isEmpty()) continue;
            r = this.batchUpdate(table, keys, upd, size, updateFields);
            System.arraycopy(r, 0, result, off, r.length);
            off += r.length;
        }
        return result;
    }

    public int @NotNull [] batchInsert(Collection<R> records, int size, boolean ignoreOrReplace) {
        if (records == null || records.isEmpty()) {
            return Null.Ints;
        }
        BiFunction<DSLContext, Collection<R>, int[]> batchIgnoreExec = (dsl, rs) -> {
            Field[] fields = this.table.fields();
            if (ignoreOrReplace) {
                InsertReturningStep step = dsl.insertInto(this.table).columns(fields).values(new Object[fields.length]).onDuplicateKeyIgnore();
                BatchBindStep batch = dsl.batch((Query)step);
                for (UpdatableRecord r : rs) {
                    batch.bind(r.intoArray());
                }
                return batch.execute();
            }
            InsertOnDuplicateSetStep step = dsl.insertInto(this.table).columns(fields).values(new Object[fields.length]).onDuplicateKeyUpdate();
            InsertOnDuplicateSetMoreStep set = null;
            for (Field fld : fields) {
                set = step.set(fld, null);
            }
            BatchBindStep batch = dsl.batch(set);
            for (UpdatableRecord r : rs) {
                Object[] ay = r.intoArray();
                int len = ay.length;
                Object[] vl = new Object[len * 2];
                System.arraycopy(ay, 0, vl, 0, len);
                System.arraycopy(ay, 0, vl, len, len);
                batch.bind(vl);
            }
            return batch.execute();
        };
        return this.batchExecute(records, size, batchIgnoreExec);
    }

    public int @NotNull [] batchInsert(Collection<R> records, int size) {
        return this.batchExecute(records, size, this.batchInsertExec);
    }

    public int @NotNull [] batchStore(Collection<R> records, int size) {
        return this.batchExecute(records, size, this.batchStoreExec);
    }

    public int @NotNull [] batchUpdate(T table, Field<?>[] whereFields, Collection<R> records, int size, Field<?> ... updateFields) {
        if (records == null || records.isEmpty()) {
            return Null.Ints;
        }
        BiFunction<DSLContext, Collection<R>, int[]> batchMergeExec = (dsl, rs) -> {
            LinkedHashMap<Field, Object> map = new LinkedHashMap<Field, Object>();
            for (Field uf : updateFields) {
                map.put(uf, null);
            }
            Condition where = null;
            for (Field wf : whereFields) {
                where = where == null ? wf.eq(null) : where.and(wf.eq(null));
            }
            BatchBindStep batch = dsl.batch((Query)dsl.update(table).set(map).where(where));
            for (UpdatableRecord r : rs) {
                Object[] vals = new Object[whereFields.length + updateFields.length];
                int off = 0;
                for (Field uf : updateFields) {
                    vals[off++] = r.get(uf);
                }
                for (Field uf : whereFields) {
                    vals[off++] = r.get(uf);
                }
                batch = batch.bind(vals);
            }
            return batch.execute();
        };
        return this.batchExecute(records, size, batchMergeExec);
    }

    public int @NotNull [] batchUpdate(Collection<R> records, int size) {
        return this.batchExecute(records, size, this.batchUpdateExec);
    }

    public int @NotNull [] batchExecute(Collection<R> records, int size, BiFunction<DSLContext, Collection<R>, int[]> exec) {
        if (records == null || records.isEmpty()) {
            return Null.Ints;
        }
        DSLContext dsl = this.ctx();
        if (size <= 0 || records.size() <= size) {
            return exec.apply(dsl, records);
        }
        int[] rst = new int[records.size()];
        int off = 0;
        ArrayList<R> rds = records instanceof List ? (ArrayList<R>)records : new ArrayList<R>(records);
        for (List<R> pt : this.partition(rds, size)) {
            int[] rt = exec.apply(dsl, pt);
            System.arraycopy(rt, 0, rst, off, rt.length);
            off += rt.length;
        }
        return rst;
    }

    private List<List<R>> partition(Collection<R> records, int size) {
        ArrayList<R> rds = records instanceof List ? (ArrayList<R>)records : new ArrayList<R>(records);
        return Lists.partition(rds, (int)size);
    }

    @NotNull
    public List<P> fetch(Function<T, Condition> fun) {
        Condition cond = fun.apply(this.table);
        return this.fetch(this.table, cond);
    }

    @NotNull
    public List<P> fetch(int limit, Function<T, Condition> fun) {
        return this.fetch(0, limit, fun);
    }

    @NotNull
    public List<P> fetch(int offset, int limit, Function<T, Condition> fun) {
        Condition cond = fun.apply(this.table);
        return this.fetch(this.table, offset, limit, cond, new QueryPart[0]);
    }

    @NotNull
    public List<P> fetch(BiConsumer<T, SelectWhereOrder> fun) {
        SelectWhereOrder soc = new SelectWhereOrder();
        fun.accept(this.table, soc);
        return this.fetch(this.table, soc.where(), soc.queries());
    }

    @NotNull
    public <E> List<E> fetch(Class<E> claz, BiConsumer<T, SelectWhereOrder> fun) {
        SelectWhereOrder soc = new SelectWhereOrder();
        fun.accept(this.table, soc);
        return this.fetch(claz, this.table, soc.where(), soc.queries());
    }

    @NotNull
    public <E> List<E> fetch(RecordMapper<? super Record, E> mapper, BiConsumer<T, SelectWhereOrder> fun) {
        SelectWhereOrder soc = new SelectWhereOrder();
        fun.accept(this.table, soc);
        return this.fetch(mapper, this.table, soc.where(), soc.queries());
    }

    @NotNull
    public List<P> fetch(T table, Condition cond) {
        return this.fetch(table, -1, -1, cond, Collections.emptyList(), Collections.emptyList());
    }

    @NotNull
    public List<P> fetch(T table, Condition cond, QueryPart ... selectsOrders) {
        return this.fetch(table, -1, -1, cond, selectsOrders);
    }

    @NotNull
    public List<P> fetch(T table, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        return this.fetch(table, -1, -1, cond, selectsOrders);
    }

    @NotNull
    public List<P> fetch(T table, int limit, QueryPart ... selectsOrders) {
        return this.fetch(table, 0, limit, (Condition)null, selectsOrders);
    }

    @NotNull
    public List<P> fetch(T table, int limit, Collection<? extends QueryPart> selectsOrders) {
        return this.fetch(table, 0, limit, null, selectsOrders);
    }

    @NotNull
    public List<P> fetch(T table, int offset, int limit, QueryPart ... selectsOrders) {
        return this.fetch(table, offset, limit, (Condition)null, selectsOrders);
    }

    @NotNull
    public List<P> fetch(T table, int offset, int limit, Collection<? extends QueryPart> selectsOrders) {
        return this.fetch(table, offset, limit, null, selectsOrders);
    }

    @NotNull
    public List<P> fetch(T table, int limit, Condition cond, QueryPart ... selectsOrders) {
        return this.fetch(table, 0, limit, cond, selectsOrders);
    }

    @NotNull
    public List<P> fetch(T table, int limit, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        return this.fetch(table, 0, limit, cond, selectsOrders);
    }

    @NotNull
    public List<P> fetch(T table, int offset, int limit, Condition cond, QueryPart ... selectsOrders) {
        return this.fetch(this.getType(), offset, limit, table, cond, selectsOrders);
    }

    @NotNull
    public List<P> fetch(T table, int offset, int limit, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        return this.fetch(this.getType(), offset, limit, table, cond, selectsOrders);
    }

    @NotNull
    public List<P> fetch(T table, int offset, int limit, Condition cond, Collection<? extends SelectFieldOrAsterisk> selects, Collection<? extends OrderField<?>> orderBy) {
        return this.fetch(this.getType(), offset, limit, table, cond, selects, orderBy);
    }

    @NotNull
    public <E> List<E> fetch(Class<E> claz, T table, QueryPart ... selectsOrders) {
        return this.fetch(claz, table, (Condition)null, selectsOrders);
    }

    @NotNull
    public <E> List<E> fetch(Class<E> claz, T table, Collection<? extends QueryPart> selectsOrders) {
        return this.fetch(claz, table, null, selectsOrders);
    }

    @NotNull
    public <E> List<E> fetch(Class<E> claz, T table, Condition cond, QueryPart ... selectsOrders) {
        return this.fetch(claz, -1, -1, table, cond, selectsOrders);
    }

    @NotNull
    public <E> List<E> fetch(Class<E> claz, T table, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        return this.fetch(claz, -1, -1, table, cond, selectsOrders);
    }

    @NotNull
    public <E> List<E> fetch(Class<E> claz, int limit, T table, QueryPart ... selectsOrders) {
        return this.fetch(claz, 0, limit, table, (Condition)null, selectsOrders);
    }

    @NotNull
    public <E> List<E> fetch(Class<E> claz, int limit, T table, Collection<? extends QueryPart> selectsOrders) {
        return this.fetch(claz, 0, limit, table, null, selectsOrders);
    }

    @NotNull
    public <E> List<E> fetch(Class<E> claz, int offset, int limit, T table, QueryPart ... selectsOrders) {
        return this.fetch(claz, offset, limit, table, (Condition)null, selectsOrders);
    }

    @NotNull
    public <E> List<E> fetch(Class<E> claz, int offset, int limit, T table, Collection<? extends QueryPart> selectsOrders) {
        return this.fetch(claz, offset, limit, table, null, selectsOrders);
    }

    @NotNull
    public <E> List<E> fetch(Class<E> claz, int limit, T table, Condition cond, QueryPart ... selectsOrders) {
        return this.fetch(claz, 0, limit, table, cond, selectsOrders);
    }

    @NotNull
    public <E> List<E> fetch(Class<E> claz, int limit, T table, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        return this.fetch(claz, 0, limit, table, cond, selectsOrders);
    }

    @NotNull
    public <E> List<E> fetch(Class<E> claz, int offset, int limit, T table, Condition cond, QueryPart ... selectsOrders) {
        SelectOrder.Parts parts = new SelectOrder.Parts(selectsOrders);
        return this.fetch(claz, offset, limit, table, cond, parts.selects, parts.orders);
    }

    @NotNull
    public <E> List<E> fetch(Class<E> claz, int offset, int limit, T table, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        SelectOrder.Parts parts = new SelectOrder.Parts(selectsOrders);
        return this.fetch(claz, offset, limit, table, cond, parts.selects, parts.orders);
    }

    @NotNull
    public <E> List<E> fetch(Class<E> claz, int offset, int limit, T table, Condition cond, Collection<? extends SelectFieldOrAsterisk> selects, Collection<? extends OrderField<?>> orderBy) {
        SelectConditionStep<R> where = this.selectWhere(table, cond, selects);
        if (offset < 0 || limit < 0) {
            if (orderBy == null || orderBy.isEmpty()) {
                return where.fetch().into(claz);
            }
            return where.orderBy(orderBy).fetch().into(claz);
        }
        if (orderBy == null || orderBy.isEmpty()) {
            return where.limit((Number)offset, (Number)limit).fetch().into(claz);
        }
        return where.orderBy(orderBy).limit((Number)offset, (Number)limit).fetch().into(claz);
    }

    @NotNull
    public <E> List<E> fetch(RecordMapper<? super Record, E> mapper, T table, QueryPart ... selectsOrders) {
        return this.fetch(mapper, table, (Condition)null, selectsOrders);
    }

    @NotNull
    public <E> List<E> fetch(RecordMapper<? super Record, E> mapper, T table, Collection<? extends QueryPart> selectsOrders) {
        return this.fetch(mapper, table, null, selectsOrders);
    }

    @NotNull
    public <E> List<E> fetch(RecordMapper<? super Record, E> mapper, T table, Condition cond, QueryPart ... selectsOrders) {
        return this.fetch(mapper, -1, -1, table, cond, selectsOrders);
    }

    @NotNull
    public <E> List<E> fetch(RecordMapper<? super Record, E> mapper, T table, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        return this.fetch(mapper, -1, -1, table, cond, selectsOrders);
    }

    @NotNull
    public <E> List<E> fetch(RecordMapper<? super Record, E> mapper, int limit, T table, QueryPart ... selectsOrders) {
        return this.fetch(mapper, 0, limit, table, (Condition)null, selectsOrders);
    }

    @NotNull
    public <E> List<E> fetch(RecordMapper<? super Record, E> mapper, int limit, T table, Collection<? extends QueryPart> selectsOrders) {
        return this.fetch(mapper, 0, limit, table, null, selectsOrders);
    }

    @NotNull
    public <E> List<E> fetch(RecordMapper<? super Record, E> mapper, int offset, int limit, T table, QueryPart ... selectsOrders) {
        return this.fetch(mapper, offset, limit, table, (Condition)null, selectsOrders);
    }

    @NotNull
    public <E> List<E> fetch(RecordMapper<? super Record, E> mapper, int offset, int limit, T table, Collection<? extends QueryPart> selectsOrders) {
        return this.fetch(mapper, offset, limit, table, null, selectsOrders);
    }

    @NotNull
    public <E> List<E> fetch(RecordMapper<? super Record, E> mapper, int limit, T table, Condition cond, QueryPart ... selectsOrders) {
        return this.fetch(mapper, 0, limit, table, cond, selectsOrders);
    }

    @NotNull
    public <E> List<E> fetch(RecordMapper<? super Record, E> mapper, int limit, T table, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        return this.fetch(mapper, 0, limit, table, cond, selectsOrders);
    }

    @NotNull
    public <E> List<E> fetch(RecordMapper<? super Record, E> mapper, int offset, int limit, T table, Condition cond, QueryPart ... selectsOrders) {
        return this.fetch(mapper, offset, limit, table, cond, List.of(selectsOrders));
    }

    @NotNull
    public <E> List<E> fetch(RecordMapper<? super Record, E> mapper, int offset, int limit, T table, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        SelectOrder.Parts parts = new SelectOrder.Parts(selectsOrders);
        return this.fetch(mapper, offset, limit, table, cond, parts.selects, parts.orders);
    }

    @NotNull
    public <E> List<E> fetch(RecordMapper<? super Record, E> mapper, int offset, int limit, T table, Condition cond, Collection<? extends SelectFieldOrAsterisk> selects, Collection<? extends OrderField<?>> orderBy) {
        SelectConditionStep<R> where = this.selectWhere(table, cond, selects);
        if (offset < 0 || limit < 0) {
            if (orderBy == null || orderBy.isEmpty()) {
                return where.fetch().map(mapper);
            }
            return where.orderBy(orderBy).fetch().map(mapper);
        }
        if (orderBy == null || orderBy.isEmpty()) {
            return where.limit((Number)offset, (Number)limit).fetch().map(mapper);
        }
        return where.orderBy(orderBy).limit((Number)offset, (Number)limit).fetch().map(mapper);
    }

    @Nullable
    public P fetchOne(Function<T, Condition> fun) {
        Condition cond = fun.apply(this.table);
        return this.fetchOne(this.table, cond, new QueryPart[0]);
    }

    @Nullable
    public P fetchLimitOne(Function<T, Condition> fun) {
        Condition cond = fun.apply(this.table);
        return this.fetchLimitOne(this.table, cond, new QueryPart[0]);
    }

    @NotNull
    public Optional<P> fetchOptional(Function<T, Condition> fun) {
        return Optional.ofNullable(this.fetchOne(fun));
    }

    @NotNull
    public Optional<P> fetchLimitOptional(Function<T, Condition> fun) {
        return Optional.ofNullable(this.fetchLimitOne(fun));
    }

    @Nullable
    public P fetchOne(BiConsumer<T, SelectWhereOrder> fun) {
        SelectWhereOrder soc = new SelectWhereOrder();
        fun.accept(this.table, soc);
        return this.fetchOne(this.table, soc.where(), soc.queries());
    }

    @Nullable
    public P fetchLimitOne(BiConsumer<T, SelectWhereOrder> fun) {
        SelectWhereOrder soc = new SelectWhereOrder();
        fun.accept(this.table, soc);
        return this.fetchLimitOne(this.table, soc.where(), soc.queries());
    }

    @NotNull
    public Optional<P> fetchOptional(BiConsumer<T, SelectWhereOrder> fun) {
        return Optional.ofNullable(this.fetchOne(fun));
    }

    @NotNull
    public Optional<P> fetchLimitOptional(BiConsumer<T, SelectWhereOrder> fun) {
        return Optional.ofNullable(this.fetchLimitOne(fun));
    }

    @Nullable
    public <E> E fetchOne(Class<E> claz, BiConsumer<T, SelectWhereOrder> fun) {
        SelectWhereOrder soc = new SelectWhereOrder();
        fun.accept(this.table, soc);
        return this.fetchOne(claz, this.table, soc.where(), soc.queries());
    }

    @Nullable
    public <E> E fetchLimitOne(Class<E> claz, BiConsumer<T, SelectWhereOrder> fun) {
        SelectWhereOrder soc = new SelectWhereOrder();
        fun.accept(this.table, soc);
        return this.fetchLimitOne(claz, this.table, soc.where(), soc.queries());
    }

    @NotNull
    public <E> Optional<E> fetchOptional(Class<E> claz, BiConsumer<T, SelectWhereOrder> fun) {
        return Optional.ofNullable(this.fetchOne(claz, fun));
    }

    @NotNull
    public <E> Optional<E> fetchLimitOptional(Class<E> claz, BiConsumer<T, SelectWhereOrder> fun) {
        return Optional.ofNullable(this.fetchLimitOne(claz, fun));
    }

    @Nullable
    public <E> E fetchOne(RecordMapper<? super Record, E> mapper, BiConsumer<T, SelectWhereOrder> fun) {
        SelectWhereOrder soc = new SelectWhereOrder();
        fun.accept(this.table, soc);
        return this.fetchOne(mapper, this.table, soc.where(), soc.queries());
    }

    @Nullable
    public <E> E fetchLimitOne(RecordMapper<? super Record, E> mapper, BiConsumer<T, SelectWhereOrder> fun) {
        SelectWhereOrder soc = new SelectWhereOrder();
        fun.accept(this.table, soc);
        return this.fetchLimitOne(mapper, this.table, soc.where(), soc.queries());
    }

    @NotNull
    public <E> Optional<E> fetchOptional(RecordMapper<? super Record, E> mapper, BiConsumer<T, SelectWhereOrder> fun) {
        return Optional.ofNullable(this.fetchOne(mapper, fun));
    }

    @NotNull
    public <E> Optional<E> fetchLimitOptional(RecordMapper<? super Record, E> mapper, BiConsumer<T, SelectWhereOrder> fun) {
        return Optional.ofNullable(this.fetchLimitOne(mapper, fun));
    }

    @Nullable
    public P fetchOne(T table, QueryPart ... selectsOrders) {
        return this.fetchOne(table, (Condition)null, selectsOrders);
    }

    @Nullable
    public P fetchOne(T table, Collection<? extends QueryPart> selectsOrders) {
        return this.fetchOne(table, null, selectsOrders);
    }

    @Nullable
    public P fetchLimitOne(T table, QueryPart ... selectsOrders) {
        return this.fetchLimitOne(table, (Condition)null, selectsOrders);
    }

    @Nullable
    public P fetchLimitOne(T table, Collection<? extends QueryPart> selectsOrders) {
        return this.fetchLimitOne(table, null, selectsOrders);
    }

    @NotNull
    public Optional<P> fetchOptional(T table, QueryPart ... selectsOrders) {
        return Optional.ofNullable(this.fetchOne(table, (Condition)null, selectsOrders));
    }

    @NotNull
    public Optional<P> fetchOptional(T table, Collection<? extends QueryPart> selectsOrders) {
        return Optional.ofNullable(this.fetchOne(table, null, selectsOrders));
    }

    @NotNull
    public Optional<P> fetchLimitOptional(T table, QueryPart ... selectsOrders) {
        return Optional.ofNullable(this.fetchLimitOne(table, (Condition)null, selectsOrders));
    }

    @NotNull
    public Optional<P> fetchLimitOptional(T table, Collection<? extends QueryPart> selectsOrders) {
        return Optional.ofNullable(this.fetchLimitOne(table, null, selectsOrders));
    }

    public P fetchOne(T table, Condition cond, QueryPart ... selectsOrders) {
        SelectOrder.Parts parts = new SelectOrder.Parts(selectsOrders);
        return this.fetchOne(table, cond, parts.selects, parts.orders, false);
    }

    public P fetchOne(T table, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        SelectOrder.Parts parts = new SelectOrder.Parts(selectsOrders);
        return this.fetchOne(table, cond, parts.selects, parts.orders, false);
    }

    @Nullable
    public P fetchLimitOne(T table, Condition cond, QueryPart ... selectsOrders) {
        SelectOrder.Parts parts = new SelectOrder.Parts(selectsOrders);
        return this.fetchOne(table, cond, parts.selects, parts.orders, true);
    }

    @Nullable
    public P fetchLimitOne(T table, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        SelectOrder.Parts parts = new SelectOrder.Parts(selectsOrders);
        return this.fetchOne(table, cond, parts.selects, parts.orders, true);
    }

    @NotNull
    public Optional<P> fetchOptional(T table, Condition cond, QueryPart ... selectsOrders) {
        return Optional.ofNullable(this.fetchOne(table, cond, selectsOrders));
    }

    @NotNull
    public Optional<P> fetchOptional(T table, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        return Optional.ofNullable(this.fetchOne(table, cond, selectsOrders));
    }

    @NotNull
    public Optional<P> fetchLimitOptional(T table, Condition cond, QueryPart ... selectsOrders) {
        return Optional.ofNullable(this.fetchLimitOne(table, cond, selectsOrders));
    }

    @NotNull
    public Optional<P> fetchLimitOptional(T table, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        return Optional.ofNullable(this.fetchLimitOne(table, cond, selectsOrders));
    }

    @Nullable
    public P fetchOne(T table, Condition cond, Collection<? extends SelectFieldOrAsterisk> selects, Collection<? extends OrderField<?>> orderBy, boolean limit) {
        return (P)this.fetchOne(this.getType(), table, cond, selects, orderBy, limit);
    }

    @Nullable
    public <E> E fetchOne(Class<E> claz, T table, QueryPart ... selectsOrders) {
        return this.fetchOne(claz, table, (Condition)null, selectsOrders);
    }

    @Nullable
    public <E> E fetchOne(Class<E> claz, T table, Collection<? extends QueryPart> selectsOrders) {
        return this.fetchOne(claz, table, null, selectsOrders);
    }

    @Nullable
    public <E> E fetchLimitOne(Class<E> claz, T table, QueryPart ... selectsOrders) {
        return this.fetchLimitOne(claz, table, (Condition)null, selectsOrders);
    }

    @Nullable
    public <E> E fetchLimitOne(Class<E> claz, T table, Collection<? extends QueryPart> selectsOrders) {
        return this.fetchLimitOne(claz, table, null, selectsOrders);
    }

    @NotNull
    public <E> Optional<E> fetchOptional(Class<E> claz, T table, QueryPart ... selectsOrders) {
        return Optional.ofNullable(this.fetchOne(claz, table, (Condition)null, selectsOrders));
    }

    @NotNull
    public <E> Optional<E> fetchOptional(Class<E> claz, T table, Collection<? extends QueryPart> selectsOrders) {
        return Optional.ofNullable(this.fetchOne(claz, table, null, selectsOrders));
    }

    @NotNull
    public <E> Optional<E> fetchLimitOptional(Class<E> claz, T table, QueryPart ... selectsOrders) {
        return Optional.ofNullable(this.fetchLimitOne(claz, table, (Condition)null, selectsOrders));
    }

    @NotNull
    public <E> Optional<E> fetchLimitOptional(Class<E> claz, T table, Collection<? extends QueryPart> selectsOrders) {
        return Optional.ofNullable(this.fetchLimitOne(claz, table, null, selectsOrders));
    }

    public <E> E fetchOne(Class<E> claz, T table, Condition cond, QueryPart ... selectsOrders) {
        SelectOrder.Parts parts = new SelectOrder.Parts(selectsOrders);
        return this.fetchOne(claz, table, cond, parts.selects, parts.orders, false);
    }

    public <E> E fetchOne(Class<E> claz, T table, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        SelectOrder.Parts parts = new SelectOrder.Parts(selectsOrders);
        return this.fetchOne(claz, table, cond, parts.selects, parts.orders, false);
    }

    @Nullable
    public <E> E fetchLimitOne(Class<E> claz, T table, Condition cond, QueryPart ... selectsOrders) {
        SelectOrder.Parts parts = new SelectOrder.Parts(selectsOrders);
        return this.fetchOne(claz, table, cond, parts.selects, parts.orders, true);
    }

    @Nullable
    public <E> E fetchLimitOne(Class<E> claz, T table, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        SelectOrder.Parts parts = new SelectOrder.Parts(selectsOrders);
        return this.fetchOne(claz, table, cond, parts.selects, parts.orders, true);
    }

    @NotNull
    public <E> Optional<E> fetchOptional(Class<E> claz, T table, Condition cond, QueryPart ... selectsOrders) {
        return Optional.ofNullable(this.fetchOne(claz, table, cond, selectsOrders));
    }

    @NotNull
    public <E> Optional<E> fetchOptional(Class<E> claz, T table, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        return Optional.ofNullable(this.fetchOne(claz, table, cond, selectsOrders));
    }

    @NotNull
    public <E> Optional<E> fetchLimitOptional(Class<E> claz, T table, Condition cond, QueryPart ... selectsOrders) {
        return Optional.ofNullable(this.fetchLimitOne(claz, table, cond, selectsOrders));
    }

    @NotNull
    public <E> Optional<E> fetchLimitOptional(Class<E> claz, T table, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        return Optional.ofNullable(this.fetchLimitOne(claz, table, cond, selectsOrders));
    }

    @Nullable
    public <E> E fetchOne(Class<E> claz, T table, Condition cond, Collection<? extends SelectFieldOrAsterisk> selects, Collection<? extends OrderField<?>> orderBy, boolean limit) {
        SelectConditionStep<R> where = this.selectWhere(table, cond, selects);
        if (limit) {
            if (orderBy == null || orderBy.isEmpty()) {
                return (E)where.fetchOneInto(claz);
            }
            return (E)where.orderBy(orderBy).fetchOneInto(claz);
        }
        if (orderBy == null || orderBy.isEmpty()) {
            return (E)where.limit((Number)1).fetchOneInto(claz);
        }
        return (E)where.orderBy(orderBy).limit((Number)1).fetchOneInto(claz);
    }

    @Nullable
    public <E> E fetchOne(RecordMapper<? super Record, E> mapper, T table, QueryPart ... selectsOrders) {
        return this.fetchOne(mapper, table, (Condition)null, selectsOrders);
    }

    @Nullable
    public <E> E fetchOne(RecordMapper<? super Record, E> mapper, T table, Collection<? extends QueryPart> selectsOrders) {
        return this.fetchOne(mapper, table, null, selectsOrders);
    }

    @Nullable
    public <E> E fetchLimitOne(RecordMapper<? super Record, E> mapper, T table, QueryPart ... selectsOrders) {
        return this.fetchLimitOne(mapper, table, (Condition)null, selectsOrders);
    }

    @Nullable
    public <E> E fetchLimitOne(RecordMapper<? super Record, E> mapper, T table, Collection<? extends QueryPart> selectsOrders) {
        return this.fetchLimitOne(mapper, table, null, selectsOrders);
    }

    @NotNull
    public <E> Optional<E> fetchOptional(RecordMapper<? super Record, E> mapper, T table, QueryPart ... selectsOrders) {
        return Optional.ofNullable(this.fetchOne(mapper, table, (Condition)null, selectsOrders));
    }

    @NotNull
    public <E> Optional<E> fetchOptional(RecordMapper<? super Record, E> mapper, T table, Collection<? extends QueryPart> selectsOrders) {
        return Optional.ofNullable(this.fetchOne(mapper, table, null, selectsOrders));
    }

    @NotNull
    public <E> Optional<E> fetchLimitOptional(RecordMapper<? super Record, E> mapper, T table, QueryPart ... selectsOrders) {
        return Optional.ofNullable(this.fetchLimitOne(mapper, table, (Condition)null, selectsOrders));
    }

    @NotNull
    public <E> Optional<E> fetchLimitOptional(RecordMapper<? super Record, E> mapper, T table, Collection<? extends QueryPart> selectsOrders) {
        return Optional.ofNullable(this.fetchLimitOne(mapper, table, null, selectsOrders));
    }

    public <E> E fetchOne(RecordMapper<? super Record, E> mapper, T table, Condition cond, QueryPart ... selectsOrders) {
        SelectOrder.Parts parts = new SelectOrder.Parts(selectsOrders);
        return this.fetchOne(mapper, table, cond, parts.selects, parts.orders, false);
    }

    public <E> E fetchOne(RecordMapper<? super Record, E> mapper, T table, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        SelectOrder.Parts parts = new SelectOrder.Parts(selectsOrders);
        return this.fetchOne(mapper, table, cond, parts.selects, parts.orders, false);
    }

    @Nullable
    public <E> E fetchLimitOne(RecordMapper<? super Record, E> mapper, T table, Condition cond, QueryPart ... selectsOrders) {
        SelectOrder.Parts parts = new SelectOrder.Parts(selectsOrders);
        return this.fetchOne(mapper, table, cond, parts.selects, parts.orders, true);
    }

    @Nullable
    public <E> E fetchLimitOne(RecordMapper<? super Record, E> mapper, T table, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        SelectOrder.Parts parts = new SelectOrder.Parts(selectsOrders);
        return this.fetchOne(mapper, table, cond, parts.selects, parts.orders, true);
    }

    @NotNull
    public <E> Optional<E> fetchOptional(RecordMapper<? super Record, E> mapper, T table, Condition cond, QueryPart ... selectsOrders) {
        return Optional.ofNullable(this.fetchOne(mapper, table, cond, selectsOrders));
    }

    @NotNull
    public <E> Optional<E> fetchOptional(RecordMapper<? super Record, E> mapper, T table, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        return Optional.ofNullable(this.fetchOne(mapper, table, cond, selectsOrders));
    }

    @NotNull
    public <E> Optional<E> fetchLimitOptional(RecordMapper<? super Record, E> mapper, T table, Condition cond, QueryPart ... selectsOrders) {
        return Optional.ofNullable(this.fetchLimitOne(mapper, table, cond, selectsOrders));
    }

    @NotNull
    public <E> Optional<E> fetchLimitOptional(RecordMapper<? super Record, E> mapper, T table, Condition cond, Collection<? extends QueryPart> selectsOrders) {
        return Optional.ofNullable(this.fetchLimitOne(mapper, table, cond, selectsOrders));
    }

    @Nullable
    public <E> E fetchOne(RecordMapper<? super Record, E> mapper, T table, Condition cond, Collection<? extends SelectFieldOrAsterisk> selects, Collection<? extends OrderField<?>> orderBy, boolean limit) {
        SelectConditionStep<R> where = this.selectWhere(table, cond, selects);
        if (limit) {
            if (orderBy == null || orderBy.isEmpty()) {
                return (E)where.fetchOne(mapper);
            }
            return (E)where.orderBy(orderBy).fetchOne(mapper);
        }
        if (orderBy == null || orderBy.isEmpty()) {
            return (E)where.limit((Number)1).fetchOne(mapper);
        }
        return (E)where.orderBy(orderBy).limit((Number)1).fetchOne(mapper);
    }

    public int delete(Function<T, Condition> fun) {
        return this.delete(this.table, fun.apply(this.table));
    }

    public int delete(T table, Condition cond) {
        return this.ctx().delete(table).where(cond).execute();
    }

    @NotNull
    public JournalDiff diffDelete(T table, Condition cond) {
        JournalDiff diff = new JournalDiff();
        diff.setTable(table.getName());
        diff.setTyped(true);
        DSLContext dsl = this.ctx();
        Result rs1 = dsl.selectFrom(table).where(cond).fetch();
        int size = rs1.size();
        if (size == 0) {
            return diff;
        }
        int rc = dsl.delete(table).where(cond).execute();
        AssertCrud.affectEq((int)rc, (int)size, (String)"delete mismatched records. cond={}", (Object[])new Object[]{cond});
        JournalDiffHelper.helpDelete(diff, (Result<? extends Record>)rs1);
        return diff;
    }

    @NotNull
    public JournalDiff diffUpdate(T table, Map<Field<?>, ?> setter, Condition cond) {
        JournalDiff diff = new JournalDiff();
        diff.setTable(table.getName());
        diff.setTyped(true);
        DSLContext dsl = this.ctx();
        Field[] fields = (Field[])setter.keySet().toArray(Field[]::new);
        SelectConditionStep select = dsl.select((SelectFieldOrAsterisk[])fields).from(table).where(cond);
        Result rs1 = select.fetch();
        int size = rs1.size();
        if (size == 0) {
            return diff;
        }
        int rc = dsl.update(table).set(setter).where(cond).execute();
        AssertCrud.affectEq((int)rc, (int)size, (String)"update mismatched records. cond={}", (Object[])new Object[]{cond});
        Result rs2 = select.fetch();
        JournalDiffHelper.helpUpdate(diff, (Result<? extends Record>)rs1, (Result<? extends Record>)rs2);
        return diff;
    }

    public int update(T table, Map<?, ?> setter, Condition cond) {
        return this.update(table, (P)setter, cond, false);
    }

    public int update(T table, Map<?, ?> setter, Condition cond, boolean skipNull) {
        if (skipNull) {
            setter.entrySet().removeIf(it -> it.getValue() == null);
        }
        if (setter.isEmpty()) {
            return 0;
        }
        return this.ctx().update(table).set(setter).where(cond).execute();
    }

    public int update(T table, P pojo, Condition cond) {
        return this.update(table, pojo, cond, false);
    }

    public int update(T table, P pojo, Condition cond, boolean skipNull) {
        DSLContext dsl = this.ctx();
        UpdatableRecord record = (UpdatableRecord)dsl.newRecord(table, pojo);
        LinkedHashMap<Field, Object> setter = new LinkedHashMap<Field, Object>();
        int size = record.size();
        for (int i = 0; i < size; ++i) {
            if (record.get(i) == null) continue;
            setter.put(record.field(i), record.get(i));
        }
        return this.update(table, (P)setter, cond, skipNull);
    }

    public int update(P pojo, boolean skipNull) {
        DSLContext dsl = this.ctx();
        UpdatableRecord record = (UpdatableRecord)dsl.newRecord(this.table, pojo);
        this.skipPkAndNull(record, skipNull);
        return record.update();
    }

    public int @NotNull [] update(Collection<P> pojos, boolean skipNull) {
        ArrayList<UpdatableRecord> records = new ArrayList<UpdatableRecord>(pojos.size());
        DSLContext dsl = this.ctx();
        for (P pojo : pojos) {
            UpdatableRecord record = (UpdatableRecord)dsl.newRecord(this.table, pojo);
            this.skipPkAndNull(record, skipNull);
            records.add(record);
        }
        return dsl.batchUpdate(records).execute();
    }

    public long count(Function<T, Condition> fun) {
        return this.count(this.table, fun.apply(this.table));
    }

    public long count(T table, Condition cond) {
        Long cnt = (Long)this.ctx().selectCount().from(table).where(cond).fetchOne(0, Long.class);
        return cnt == null ? 0L : cnt;
    }

    public void skipPkAndNull(R record, boolean skipNull) {
        WingsJooqUtil.skipFields(record, this.pkeys);
        if (skipNull) {
            WingsJooqUtil.skipNullVals(record);
        }
    }

    private SelectConditionStep<R> selectWhere(T table, Condition cond, Collection<? extends SelectFieldOrAsterisk> selects) {
        if (selects == null || selects.isEmpty()) {
            return this.ctx().selectFrom(table).where(cond);
        }
        SelectSelectStep select = (SelectSelectStep)TypedCastUtil.castObject((Object)this.ctx().select(selects));
        return select.from(table).where(cond);
    }
}

