/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.database.jooq;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Operator;
import org.jooq.Param;
import org.jooq.QueryPart;
import org.jooq.RowCountQuery;
import org.jooq.Table;
import org.jooq.TableRecord;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.TableImpl;
import pro.fessional.mirana.cast.BoxedCastUtil;
import pro.fessional.mirana.data.Z;
import pro.fessional.wings.faceless.convention.EmptyValue;

public class WingsJooqUtil
extends DSL {
    private static final Field<?>[] EMPTY_FIELDS = new Field[0];
    private static final Param<?>[] emptyParams = new Param[0];

    @NotNull
    public static Field<?>[] primaryKeys(Table<?> table) {
        UniqueKey key = table.getPrimaryKey();
        return key == null ? EMPTY_FIELDS : key.getFieldsArray();
    }

    public static void skipFields(TableRecord<?> record, Field<?> ... fields) {
        for (Field<?> field : fields) {
            record.changed(field, false);
        }
    }

    public static void skipNullVals(TableRecord<?> record) {
        int size = record.size();
        for (int i = 0; i < size; ++i) {
            if (record.get(i) != null) continue;
            record.changed(i, false);
        }
    }

    public static Field<String> concatWs(String separator, Object ... vals) {
        StringBuilder sb = new StringBuilder("CONCAT_WS({0}");
        int len = vals.length;
        Object[] objs = new Object[len + 1];
        objs[0] = separator;
        for (int i = 0; i < len; ++i) {
            sb.append(',').append('{').append(i + 1).append('}');
        }
        sb.append(')');
        System.arraycopy(vals, 0, objs, 1, len);
        Field fld = DSL.field((String)sb.toString(), (Object[])objs);
        return fld;
    }

    public static RowCountQuery replaceInto(TableRecord<?> record) {
        Table table = record.getTable();
        Field[] fields = table.fields();
        return WingsJooqUtil.replaceInto(table, fields);
    }

    public static RowCountQuery replaceInto(Table<?> table, Field<?> ... fields) {
        if (fields == null || fields.length == 0) {
            fields = table.fields();
        }
        QueryPart[] qps = new QueryPart[fields.length * 2 + 1];
        qps[0] = table;
        System.arraycopy(fields, 0, qps, 1, fields.length);
        StringBuilder sql = new StringBuilder();
        sql.append("replace into {0} (");
        int pos = WingsJooqUtil.buildHolder(sql, 0, fields.length);
        sql.append(") values (");
        WingsJooqUtil.buildHolder(sql, pos, fields.length);
        sql.append(')');
        return WingsJooqUtil.query((String)sql.toString(), (QueryPart[])qps);
    }

    public static Condition condAsEmpty(@NotNull Field<LocalDateTime> datetime) {
        return datetime.lt((Object)EmptyValue.DATE_TIME_AS_MAX);
    }

    public static Condition condNonEmpty(@NotNull Field<LocalDateTime> datetime) {
        return datetime.gt((Object)EmptyValue.DATE_TIME_AS_MAX);
    }

    public static Condition condMatch(String against, Field<?> ... fields) {
        int len = fields.length;
        Field[] vals = new Field[len + 1];
        System.arraycopy(fields, 0, vals, 0, len);
        vals[len] = DSL.val((String)against);
        StringBuilder sb = new StringBuilder("MATCH(");
        for (int i = 0; i < len; ++i) {
            sb.append('{').append(i).append('}').append(',');
        }
        sb.setLength(sb.length() - 1);
        sb.append(") AGAINST({").append(len).append("})");
        return DSL.condition((String)sb.toString(), (QueryPart[])vals);
    }

    @NotNull
    public static <Z> Condition condEqSkip(Field<Z> filed, Collection<Z> value) {
        return WingsJooqUtil.condEqSkip(filed, value, Objects::nonNull);
    }

    @NotNull
    public static <Z> Condition condEqSkip(Field<Z> filed, Collection<Z> value, Predicate<Z> filter) {
        if (value == null || value.isEmpty()) {
            return WingsJooqUtil.noCondition();
        }
        for (Z v : value) {
            if (!filter.test(v)) continue;
            return filed.eq(v);
        }
        return WingsJooqUtil.noCondition();
    }

    @NotNull
    public static <Z> Condition condInSkip(Field<Z> filed, Collection<Z> value) {
        return WingsJooqUtil.condInSkip(filed, value, Objects::nonNull);
    }

    @NotNull
    public static <Z> Condition condInSkip(Field<Z> filed, Collection<Z> value, Predicate<Z> filter) {
        return value == null || value.isEmpty() ? WingsJooqUtil.noCondition() : filed.in((Collection)value.stream().filter(filter).collect(Collectors.toList()));
    }

    @NotNull
    public static <Z> Condition condRange(Field<Z> field, Z lowerInclusive, Z upperInclusive) {
        if (lowerInclusive == null) {
            if (upperInclusive == null) {
                return WingsJooqUtil.noCondition();
            }
            return field.le(upperInclusive);
        }
        if (upperInclusive == null) {
            return field.ge(lowerInclusive);
        }
        return field.between(lowerInclusive, upperInclusive);
    }

    @NotNull
    public static Condition condChain(TableRecord<?> record) {
        return WingsJooqUtil.condChain(Operator.AND, record, true);
    }

    @NotNull
    public static Condition condChain(TableRecord<?> record, boolean ignoreNull) {
        return WingsJooqUtil.condChain(Operator.AND, record, ignoreNull);
    }

    @NotNull
    public static Condition condChain(Operator andOr, TableRecord<?> record) {
        return WingsJooqUtil.condChain(andOr, record, true);
    }

    @NotNull
    public static Condition condChain(Operator andOr, TableRecord<?> record, boolean ignoreNull) {
        List<Condition> conds = WingsJooqUtil.condField(record, ignoreNull, new Field[0]);
        return conds.isEmpty() ? WingsJooqUtil.noCondition() : WingsJooqUtil.condition((Operator)andOr, conds);
    }

    @NotNull
    public static Condition condChain(Map<String, Object> fieldValue) {
        return WingsJooqUtil.condChain(Operator.AND, fieldValue, true, null);
    }

    @NotNull
    public static Condition condChain(Map<String, Object> fieldValue, boolean ignoreNull) {
        return WingsJooqUtil.condChain(Operator.AND, fieldValue, ignoreNull, null);
    }

    @NotNull
    public static Condition condChain(Map<String, Object> fieldValue, boolean ignoreNull, TableImpl<?> alias) {
        return WingsJooqUtil.condChain(Operator.AND, fieldValue, ignoreNull, null);
    }

    @NotNull
    public static Condition condChain(Operator andOr, Map<String, Object> fieldValue, boolean ignoreNull) {
        return WingsJooqUtil.condChain(andOr, fieldValue, ignoreNull, null);
    }

    @NotNull
    public static Condition condChain(Operator andOr, Map<String, Object> fieldValue, boolean ignoreNull, TableImpl<?> alias) {
        LinkedHashMap<Field, Object> fvs = new LinkedHashMap<Field, Object>(fieldValue.size());
        if (alias == null) {
            for (Map.Entry<String, Object> en : fieldValue.entrySet()) {
                Field field = WingsJooqUtil.field((String)en.getKey());
                fvs.put(field, en.getValue());
            }
        } else {
            Field[] fields = alias.fields();
            block1: for (Map.Entry<String, Object> entry : fieldValue.entrySet()) {
                for (Field f : fields) {
                    if (!entry.getKey().equalsIgnoreCase(f.getName())) continue;
                    fvs.put(f, entry.getValue());
                    continue block1;
                }
            }
        }
        if (fvs.isEmpty()) {
            return WingsJooqUtil.noCondition();
        }
        ArrayList<Condition> cds = new ArrayList<Condition>(fvs.size());
        for (Map.Entry<String, Object> entry : fvs.entrySet()) {
            Object v = entry.getValue();
            Field f = (Field)entry.getKey();
            Condition c = WingsJooqUtil.condField(f, ignoreNull, v);
            if (c == null) continue;
            cds.add(c);
        }
        return WingsJooqUtil.condition((Operator)andOr, cds);
    }

    @Nullable
    public static Condition condField(Field<?> field, boolean ignoreNull, Object value) {
        List<Object> vs;
        if (value == null) {
            return ignoreNull ? null : field.isNull();
        }
        if (value instanceof Collection) {
            vs = new ArrayList<Object>((Collection)value);
        } else if (value.getClass().isArray()) {
            vs = value instanceof boolean[] ? BoxedCastUtil.list((boolean[])((boolean[])value)) : (value instanceof byte[] ? BoxedCastUtil.list((byte[])((byte[])value)) : (value instanceof char[] ? BoxedCastUtil.list((char[])((char[])value)) : (value instanceof int[] ? BoxedCastUtil.list((int[])((int[])value)) : (value instanceof long[] ? BoxedCastUtil.list((long[])((long[])value)) : (value instanceof float[] ? BoxedCastUtil.list((float[])((float[])value)) : (value instanceof double[] ? BoxedCastUtil.list((double[])((double[])value)) : Arrays.asList((Object[])value)))))));
        } else {
            Field<?> f = field;
            return f.eq(f.getDataType().convert(value));
        }
        if (vs.isEmpty()) {
            return null;
        }
        vs.removeIf(Objects::isNull);
        return field.in((Collection)field.getDataType().convert(vs));
    }

    public static List<Condition> condField(TableRecord<?> record, Field<?> ... includes) {
        return WingsJooqUtil.condField(record, true, includes);
    }

    @NotNull
    public static List<Condition> condField(TableRecord<?> record, boolean ignoreNull, Field<?> ... includes) {
        Field[] fields = record.fields();
        if (includes != null && includes.length > 0) {
            Field[] temp = new Field[fields.length];
            block0: for (Field<?> fld : includes) {
                for (int i = 0; i < fields.length; ++i) {
                    if (!fields[i].equals(fld)) continue;
                    temp[i] = fields[i];
                    continue block0;
                }
            }
            fields = temp;
        }
        ArrayList<Condition> conds = new ArrayList<Condition>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            Condition cond;
            Field field = fields[i];
            if (field == null || (cond = WingsJooqUtil.condField(field, ignoreNull, record.getValue(i))) == null) continue;
            conds.add(cond);
        }
        return conds;
    }

    @NotNull
    public static CondBuilder condBuilder() {
        return new CondBuilder();
    }

    @NotNull
    public static CondBuilder condBuilder(Condition cond) {
        return new CondBuilder().and(cond);
    }

    public static Param<?>[] bindValue(TableRecord<?> record) {
        return WingsJooqUtil.bindValue(record, true);
    }

    public static Param<?>[] bindValue(TableRecord<?> record, boolean ignoreNull) {
        Field[] fields = record.fields();
        ArrayList<Param> result = new ArrayList<Param>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            Object value = record.getValue(i);
            if (value == null && ignoreNull) continue;
            result.add(WingsJooqUtil.val((Object)value));
        }
        return result.isEmpty() ? emptyParams : result.toArray(emptyParams);
    }

    public static Param<?>[] bindNamed(TableRecord<?> record) {
        return WingsJooqUtil.bindNamed(record, true);
    }

    public static Param<?>[] bindNamed(TableRecord<?> record, boolean ignoreNull) {
        Field[] fields = record.fields();
        ArrayList<Param> result = new ArrayList<Param>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            Object value = record.getValue(i);
            if (value == null && ignoreNull) continue;
            result.add(WingsJooqUtil.param((String)field.getName(), (Object)value));
        }
        return result.isEmpty() ? emptyParams : result.toArray(emptyParams);
    }

    public static Param<?>[] bindNamed(Map<String, Object> bindings) {
        return WingsJooqUtil.bindNamed(bindings, true);
    }

    public static Param<?>[] bindNamed(Map<String, Object> bindings, boolean ignoreNull) {
        ArrayList<Param> result = new ArrayList<Param>(bindings.size());
        for (Map.Entry<String, Object> entry : bindings.entrySet()) {
            Object value = entry.getValue();
            if (value == null && ignoreNull) continue;
            result.add(WingsJooqUtil.param((String)entry.getKey(), (Object)value));
        }
        return result.isEmpty() ? emptyParams : result.toArray(emptyParams);
    }

    private static int buildHolder(StringBuilder sql, int pos, int len) {
        if (len == 0) {
            return pos;
        }
        for (int i = 0; i < len; ++i) {
            sql.append('{');
            sql.append(++pos);
            sql.append("},");
        }
        sql.deleteCharAt(sql.length() - 1);
        return pos;
    }

    public static class CondBuilder {
        private static final String BGN = "(";
        private final ArrayList<Object> calcStack = new ArrayList(16);

        @Contract(value="->this")
        public CondBuilder and() {
            return this.cond(Operator.AND, null, true);
        }

        @Contract(value="_->this")
        public CondBuilder and(Condition cond) {
            return this.cond(Operator.AND, cond, cond != null);
        }

        @Contract(value="_,_->this")
        public CondBuilder andNotNull(Condition cond, Object ... value) {
            boolean vd = cond != null && Z.notNull((Object[])value) != null;
            return this.cond(Operator.AND, cond, vd);
        }

        @Contract(value="_,_->this")
        public CondBuilder andNotEmpty(Condition cond, Collection<?> value) {
            boolean vd = cond != null && value != null && !value.isEmpty();
            return this.cond(Operator.AND, cond, vd);
        }

        @Contract(value="_,_->this")
        public CondBuilder and(Condition cond, boolean valid) {
            return this.cond(Operator.AND, cond, valid);
        }

        @Contract(value="->this")
        public CondBuilder or() {
            return this.cond(Operator.OR, null, true);
        }

        @Contract(value="_->this")
        public CondBuilder or(Condition cond) {
            return this.cond(Operator.OR, cond, cond != null);
        }

        @Contract(value="_,_->this")
        public CondBuilder orNotNull(Condition cond, Object ... value) {
            boolean vd = cond != null && Z.notNull((Object[])value) != null;
            return this.cond(Operator.OR, cond, vd);
        }

        @Contract(value="_,_->this")
        public CondBuilder orNotEmpty(Condition cond, Collection<?> value) {
            boolean vd = cond != null && value != null && !value.isEmpty();
            return this.cond(Operator.OR, cond, vd);
        }

        @Contract(value="_,_->this")
        public CondBuilder or(Condition cond, boolean valid) {
            return this.cond(Operator.OR, cond, valid);
        }

        @Contract(value="->this")
        public CondBuilder grp() {
            return this.grp(null, true);
        }

        @Contract(value="_->this")
        public CondBuilder grp(Condition cond) {
            return this.grp(cond, true);
        }

        @Contract(value="_,_->this")
        public CondBuilder grp(Condition cond, boolean valid) {
            this.calcStack.add(BGN);
            if (valid && cond != null) {
                this.calcStack.add(cond);
            }
            return this;
        }

        @Contract(value="_,_,_->this")
        public CondBuilder cond(Operator opr, Condition cond, boolean valid) {
            if (!valid || opr == null) {
                return this;
            }
            if (this.calcStack.isEmpty()) {
                if (cond != null) {
                    this.calcStack.add(cond);
                }
            } else {
                for (int i = this.calcStack.size() - 1; i >= 0; --i) {
                    Object obj = this.calcStack.get(i);
                    if (obj instanceof Condition) {
                        if (cond == null) {
                            this.calcStack.add(opr);
                            break;
                        }
                        this.calcStack.set(i, this.eval((Condition)obj, opr, cond));
                        break;
                    }
                    if (obj instanceof Operator) {
                        if (cond == null) break;
                    } else {
                        if (cond == null) break;
                        this.calcStack.add(cond);
                        break;
                    }
                    this.calcStack.remove(i);
                }
            }
            return this;
        }

        @Contract(value="->this")
        public CondBuilder end() {
            int idx;
            int cur;
            int size = this.calcStack.size();
            if (size <= 1) {
                return this;
            }
            Condition rt = null;
            Operator op = null;
            int grp = -1;
            for (cur = size - 1; cur >= 0; --cur) {
                Object obj = this.calcStack.get(cur);
                if (obj instanceof Condition) {
                    if (rt == null) {
                        rt = (Condition)obj;
                        continue;
                    }
                    rt = this.eval((Condition)obj, op, rt);
                    continue;
                }
                if (obj instanceof Operator) {
                    op = (Operator)obj;
                    continue;
                }
                if (grp >= 0) break;
                grp = cur;
            }
            if ((idx = cur + 1) < size - 1) {
                this.calcStack.set(idx, rt);
                this.calcStack.subList(idx + 1, size).clear();
            }
            return this;
        }

        @NotNull
        public Condition eval(Condition h1, Operator op, Condition h2) {
            if (h1 == null) {
                throw new IllegalStateException("bad expression: no left-hand Condition");
            }
            if (op == null && h2 == null) {
                return h1;
            }
            if (op == null || h2 == null) {
                throw new IllegalStateException("bad expression: no Condition or Operator");
            }
            return DSL.condition((Operator)op, (Condition)h1, (Condition)h2);
        }

        @NotNull
        public Condition build() {
            for (int i = this.calcStack.size(); i > 1 && this.calcStack.size() > 1; --i) {
                this.end();
            }
            return (Condition)this.calcStack.get(0);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Object o : this.calcStack) {
                sb.append(o.toString());
            }
            return sb.toString();
        }
    }
}

