/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.database.jooq.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jooq.OrderField;
import org.jooq.QueryPart;
import org.jooq.SelectFieldOrAsterisk;

public class SelectOrder {
    protected final List<QueryPart> queries = new ArrayList<QueryPart>(16);

    @Contract(value="_ -> this")
    public SelectOrder query(QueryPart ... part) {
        Collections.addAll(this.queries, part);
        return this;
    }

    @Contract(value="_ -> this")
    public SelectOrder query(Collection<? extends QueryPart> part) {
        this.queries.addAll(part);
        return this;
    }

    @NotNull
    public List<QueryPart> queries() {
        return this.queries;
    }

    @NotNull
    public Parts parts() {
        return new Parts(this.queries);
    }

    public static class Parts {
        public final Collection<SelectFieldOrAsterisk> selects;
        public final Collection<OrderField<?>> orders;

        public Parts(QueryPart ... selectsOrders) {
            this(List.of(selectsOrders));
        }

        public Parts(Collection<? extends QueryPart> selectsOrders) {
            if (selectsOrders == null || selectsOrders.isEmpty()) {
                this.selects = Collections.emptyList();
                this.orders = Collections.emptyList();
            } else {
                int size = selectsOrders.size();
                ArrayList<SelectFieldOrAsterisk> fields = new ArrayList<SelectFieldOrAsterisk>(size);
                ArrayList orders = new ArrayList(size);
                for (QueryPart queryPart : selectsOrders) {
                    if (queryPart instanceof SelectFieldOrAsterisk) {
                        fields.add((SelectFieldOrAsterisk)queryPart);
                        continue;
                    }
                    if (queryPart instanceof OrderField) {
                        orders.add((OrderField)queryPart);
                        continue;
                    }
                    throw new IllegalArgumentException("unsupported querypart=" + String.valueOf(queryPart));
                }
                this.selects = fields;
                this.orders = orders;
            }
        }
    }
}

