/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.spring.bean;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shardingsphere.driver.jdbc.core.driver.ShardingSphereURLManager;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pro.fessional.wings.faceless.database.DataSourceContext;
import pro.fessional.wings.faceless.database.sharding.WriteRouteOnlyAround;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class FacelessShardingSphereConfiguration {
    private static final Log log = LogFactory.getLog(FacelessShardingSphereConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public DataSourceContext.Customizer shardingDataSourceContext(@Value(value="${spring.datasource.url}") String jdbcUrl) throws Exception {
        if (!jdbcUrl.startsWith("jdbc:shardingsphere:")) {
            log.info((Object)("FacelessShard skip shardingSphereCustomizer jdbcUrl=" + jdbcUrl));
            return ignored -> false;
        }
        byte[] yamlBytes = ShardingSphereURLManager.getContent((String)jdbcUrl, (String)"jdbc:shardingsphere:");
        YamlRootConfiguration rootConfig = (YamlRootConfiguration)YamlEngine.unmarshal((byte[])yamlBytes, YamlRootConfiguration.class);
        YamlDataSourceConfigurationSwapper configurationSwapper = new YamlDataSourceConfigurationSwapper();
        Map dsMap = configurationSwapper.swapToDataSources(rootConfig.getDataSources());
        return ctx -> {
            log.info((Object)("FacelessShard spring-bean shardingSphereCustomizer backends size=" + dsMap.size()));
            ctx.clearBackend();
            ctx.addBackend(dsMap);
            return true;
        };
    }

    @Bean
    @ConditionalWingsEnabled
    public WriteRouteOnlyAround writeRouteOnlyAround() {
        log.info((Object)"FacelessShard spring-bean writeRouteOnlyAround");
        return new WriteRouteOnlyAround();
    }
}

