/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.concur;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import pro.fessional.wings.faceless.database.helper.JdbcTemplateHelper;

public class MysqlServerLock
implements Lock {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MysqlServerLock.class);
    private final JdbcTemplate jdbcTemplate;
    private final String lockName;

    @Override
    public void lock() {
        Integer rc = (Integer)this.jdbcTemplate.query("SELECT GET_LOCK(?, -1) FROM DUAL", JdbcTemplateHelper.FirstIntegerOrNull, new Object[]{this.lockName});
        if (rc == null) {
            throw new IllegalStateException("can not get lock, name=" + this.lockName);
        }
    }

    @Override
    public boolean tryLock() {
        Integer rc = (Integer)this.jdbcTemplate.query("SELECT IF(IS_FREE_LOCK(?)=1, GET_LOCK(?,-1), -1) FROM DUAL", JdbcTemplateHelper.FirstIntegerOrNull, new Object[]{this.lockName, this.lockName});
        if (rc == null) {
            throw new IllegalStateException("can not get lock, name=" + this.lockName);
        }
        return rc == 1;
    }

    @Override
    public boolean tryLock(long time, @NotNull TimeUnit unit) {
        int sec = (int)Math.max(1L, unit.toSeconds(time));
        Integer rc = (Integer)this.jdbcTemplate.query("SELECT IF(IS_FREE_LOCK(?)=1, GET_LOCK(?,?), -1) FROM DUAL", JdbcTemplateHelper.FirstIntegerOrNull, new Object[]{this.lockName, this.lockName, sec});
        if (rc == null) {
            throw new IllegalStateException("can not get lock, name=" + this.lockName);
        }
        return rc == 1;
    }

    @Override
    public void unlock() {
        Integer rc = (Integer)this.jdbcTemplate.query("SELECT RELEASE_LOCK(?) FROM DUAL", JdbcTemplateHelper.FirstIntegerOrNull, new Object[]{this.lockName});
        if (rc == null) {
            log.warn("unlock not existed lock, name={}", (Object)this.lockName);
        } else if (rc == 0) {
            log.warn("unlock not owned lock, name={}", (Object)this.lockName);
        } else {
            log.debug("unlock lock, name={}", (Object)this.lockName);
        }
    }

    @Override
    public void lockInterruptibly() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Condition newCondition() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Generated
    public MysqlServerLock(JdbcTemplate jdbcTemplate, String lockName) {
        this.jdbcTemplate = jdbcTemplate;
        this.lockName = lockName;
    }
}

