/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.converter;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.wings.faceless.converter.WingsConverter;
import pro.fessional.wings.faceless.enums.ConstantEnum;
import pro.fessional.wings.faceless.enums.ConstantEnumUtil;

public class ConsEnumConverter<E extends ConstantEnum>
implements WingsConverter<Integer, E> {
    private final E[] values;
    private final Class<Integer> srcClz = Integer.class;
    private final Class<E> tgtClz;

    public ConsEnumConverter(Class<E> toType, E[] values) {
        this.tgtClz = toType;
        this.values = values;
    }

    @NotNull
    public Class<Integer> sourceType() {
        return this.srcClz;
    }

    @NotNull
    public Class<E> targetType() {
        return this.tgtClz;
    }

    @Nullable
    public E toTarget(Integer s) {
        return (E)ConstantEnumUtil.idOrNull((Integer)s, this.values);
    }

    @Nullable
    public Integer toSource(E t) {
        return t == null ? null : Integer.valueOf(t.getId());
    }

    public static <E extends Enum<E>> ConsEnumConverter<E> of(Class<E> toType) {
        return new ConsEnumConverter(toType, (ConstantEnum[])((Enum[])toType.getEnumConstants()));
    }

    @SafeVarargs
    public static <E extends ConstantEnum> ConsEnumConverter<E> of(Class<E> toType, E ... values) {
        return new ConsEnumConverter(toType, values);
    }
}

