/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.database.helper;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.page.PageQuery;
import pro.fessional.mirana.page.PageResult;
import pro.fessional.mirana.page.PageUtil;
import pro.fessional.wings.faceless.converter.WingsConverter;
import pro.fessional.wings.faceless.database.helper.RowMapperHelper;

public class PageJdbcHelper {
    @NotNull
    public static CountJdbc use(JdbcTemplate tpl, PageQuery page) {
        return PageJdbcHelper.use(tpl, page, -1);
    }

    @NotNull
    public static CountJdbc use(JdbcTemplate tpl, PageQuery page, int total) {
        ContextJdbc context = new ContextJdbc();
        context.page = page;
        context.tpl = tpl;
        context.total = total;
        return new CountJdbc(context);
    }

    public static class CountJdbc {
        private final ContextJdbc context;

        public OrderJdbc2 wrap(String select, Map<String, String> bys, String ... dft) {
            this.context.wrap = select;
            this.context.orderBy(bys, dft);
            return new OrderJdbc2(this.context);
        }

        public OrderJdbc2 wrap(String select) {
            this.context.wrap = select;
            return new OrderJdbc2(this.context);
        }

        public FromJdbc count(String count) {
            this.context.count = count == null || count.isEmpty() ? "count(*)" : count;
            return new FromJdbc(this.context);
        }

        @Generated
        public CountJdbc(ContextJdbc context) {
            this.context = context;
        }
    }

    private static class ContextJdbc {
        private JdbcTemplate tpl;
        private PageQuery page;
        private String count;
        private String select;
        private String fromWhere;
        private String order = "";
        private String wrap;
        private Object[] bind = Null.Objects;
        private int total = -1;

        private ContextJdbc() {
        }

        private void orderBy(Map<String, String> bys, String ... dft) {
            List srt = PageUtil.sort((String)this.page.getSort());
            StringBuilder sb = new StringBuilder();
            if (srt.isEmpty()) {
                for (String s : dft) {
                    sb.append(',').append(s);
                }
            } else {
                if (dft.length > 0) {
                    bys = new HashMap<String, String>(bys);
                    for (String s : dft) {
                        bys.putIfAbsent(s, s);
                    }
                }
                for (PageUtil.By by : srt) {
                    String fd = bys.get(by.key);
                    if (fd == null) continue;
                    sb.append(',').append(fd);
                    if (by.asc) {
                        sb.append(" ASC");
                        continue;
                    }
                    sb.append(" DESC");
                }
            }
            if (!sb.isEmpty()) {
                this.order = sb.substring(1);
            }
        }

        private void orderLimit(StringBuilder sql) {
            if (!this.order.isEmpty()) {
                sql.append(" order by ");
                sql.append(this.order);
            }
            sql.append(" limit ");
            int offset = this.page.toOffset();
            if (offset > 0) {
                sql.append(offset).append(',');
            }
            sql.append(this.page.getSize());
        }
    }

    public static class OrderJdbc2 {
        private final ContextJdbc context;

        public BindJdbc2 orderNone() {
            return new BindJdbc2(this.context);
        }

        public BindJdbc2 order(String bys) {
            this.context.orderBy(Collections.emptyMap(), bys);
            return new BindJdbc2(this.context);
        }

        public BindJdbc2 order(Map<String, String> bys, String ... dft) {
            this.context.orderBy(bys, dft);
            return new BindJdbc2(this.context);
        }

        @Generated
        public OrderJdbc2(ContextJdbc context) {
            this.context = context;
        }
    }

    public static class OrderJdbc1 {
        private final ContextJdbc context;

        public BindJdbc1 orderNone() {
            return new BindJdbc1(this.context);
        }

        public BindJdbc1 order(String bys) {
            this.context.orderBy(Collections.emptyMap(), bys);
            return new BindJdbc1(this.context);
        }

        public BindJdbc1 order(Map<String, String> bys, String ... dft) {
            this.context.orderBy(bys, dft);
            return new BindJdbc1(this.context);
        }

        @Generated
        public OrderJdbc1(ContextJdbc context) {
            this.context = context;
        }
    }

    public static class FromJdbc {
        private final ContextJdbc context;

        public OrderJdbc1 fromWhere(String fromWhere) {
            this.context.fromWhere = fromWhere;
            return new OrderJdbc1(this.context);
        }

        @Generated
        public FromJdbc(ContextJdbc context) {
            this.context = context;
        }
    }

    public static class IntoJdbc2 {
        private final ContextJdbc context;

        @NotNull
        public <E> PageResult<E> fetchInto(Class<E> claz) {
            return this.fetchInto(RowMapperHelper.of(claz));
        }

        @NotNull
        public <E> PageResult<E> fetchInto(Class<E> claz, WingsConverter<?, ?> ... converters) {
            return this.fetchInto(RowMapperHelper.of(claz, converters));
        }

        @NotNull
        public <E> PageResult<E> fetchInto(RowMapper<E> mapper) {
            Integer total;
            if (this.context.total < 0 && (total = (Integer)this.context.tpl.queryForObject("SELECT count(*) FROM (" + this.context.wrap + ") WINGS_WRAP", Integer.class, this.context.bind)) != null) {
                this.context.total = total;
            }
            List list = null;
            if (this.context.total > 0) {
                StringBuilder sql = new StringBuilder(this.context.wrap.length() + this.context.order.length() + 30);
                sql.append(this.context.wrap);
                this.context.orderLimit(sql);
                list = this.context.tpl.query(sql.toString(), mapper, this.context.bind);
            }
            return PageResult.ok((int)this.context.total, list, (PageQuery)this.context.page);
        }

        @Generated
        public IntoJdbc2(ContextJdbc context) {
            this.context = context;
        }
    }

    public static class IntoJdbc1 {
        private final ContextJdbc context;

        @NotNull
        public <E> PageResult<E> into(Class<E> claz) {
            return this.into(RowMapperHelper.of(claz));
        }

        @NotNull
        public <E> PageResult<E> into(Class<E> claz, WingsConverter<?, ?> ... converters) {
            return this.into(RowMapperHelper.of(claz, converters));
        }

        @NotNull
        public <E> PageResult<E> into(RowMapper<E> mapper) {
            Integer total;
            if (this.context.total < 0 && (total = (Integer)this.context.tpl.queryForObject("SELECT " + this.context.count + " " + this.context.fromWhere, Integer.class, this.context.bind)) != null) {
                this.context.total = total;
            }
            List list = null;
            if (this.context.total > 0) {
                StringBuilder sql = new StringBuilder(this.context.select.length() + this.context.fromWhere.length() + this.context.order.length() + 50);
                sql.append("SELECT ");
                sql.append(this.context.select);
                sql.append(' ');
                sql.append(this.context.fromWhere);
                this.context.orderLimit(sql);
                list = this.context.tpl.query(sql.toString(), mapper, this.context.bind);
            }
            return PageResult.ok((int)this.context.total, list, (PageQuery)this.context.page);
        }

        @Generated
        public IntoJdbc1(ContextJdbc context) {
            this.context = context;
        }
    }

    public static class FetchJdbc1 {
        private final ContextJdbc context;

        @NotNull
        public IntoJdbc1 fetch(String fields) {
            this.context.select = fields == null || fields.isEmpty() ? "*" : fields;
            return new IntoJdbc1(this.context);
        }

        @Generated
        public FetchJdbc1(ContextJdbc context) {
            this.context = context;
        }
    }

    public static class BindJdbc2 {
        private final ContextJdbc context;

        public IntoJdbc2 bindNone() {
            return new IntoJdbc2(this.context);
        }

        public IntoJdbc2 bind(Object ... args) {
            if (args != null) {
                this.context.bind = args;
            }
            return new IntoJdbc2(this.context);
        }

        @Generated
        public BindJdbc2(ContextJdbc context) {
            this.context = context;
        }
    }

    public static class BindJdbc1 {
        private final ContextJdbc context;

        public FetchJdbc1 bindNone() {
            return new FetchJdbc1(this.context);
        }

        public FetchJdbc1 bind(Object ... args) {
            if (args != null) {
                this.context.bind = args;
            }
            return new FetchJdbc1(this.context);
        }

        @Generated
        public BindJdbc1(ContextJdbc context) {
            this.context = context;
        }
    }
}

