/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.enums;

import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.i18n.ZoneIdResolver;
import pro.fessional.wings.faceless.enums.ConstantEnumUtil;
import pro.fessional.wings.faceless.enums.StandardTimezoneEnum;

public class TimezoneEnumUtil
extends ConstantEnumUtil {
    private static final Map<Integer, ZoneId> ZoneIdMap = new HashMap<Integer, ZoneId>();

    public static void register(StandardTimezoneEnum en) {
        ZoneId neu = en.toZoneId();
        ZoneId old = ZoneIdMap.put(en.getId(), neu);
        if (old != null && !old.equals(neu)) {
            throw new IllegalArgumentException("need only one zoneId. old=" + old.getId() + ", new=" + neu.getId() + ", id=" + en.getId());
        }
    }

    public static void register(StandardTimezoneEnum ... enums) {
        for (StandardTimezoneEnum en : enums) {
            TimezoneEnumUtil.register(en);
        }
    }

    @Nullable
    public static ZoneId zoneIdOrNull(Integer zoneId) {
        if (zoneId == null) {
            return null;
        }
        return ZoneIdMap.get(zoneId);
    }

    @NotNull
    public static ZoneId zoneIdOrThrow(Integer zoneId) {
        ZoneId t = TimezoneEnumUtil.zoneIdOrNull(zoneId);
        if (t == null) {
            throw new IllegalArgumentException("can not found ZoneId by zoneId=" + zoneId);
        }
        return t;
    }

    @NotNull
    public static ZoneId zoneIdOrHint(Integer zoneId, String hint) {
        ZoneId t = TimezoneEnumUtil.zoneIdOrNull(zoneId);
        if (t == null) {
            throw new IllegalArgumentException(hint);
        }
        return t;
    }

    @NotNull
    public static ZoneId zoneIdOrElse(Integer zoneId, ZoneId el) {
        ZoneId t = TimezoneEnumUtil.zoneIdOrNull(zoneId);
        return t == null ? el : t;
    }

    @Nullable
    public static Integer zoneIdOrNull(ZoneId zoneId) {
        if (zoneId == null) {
            return null;
        }
        for (Map.Entry<Integer, ZoneId> en : ZoneIdMap.entrySet()) {
            if (!en.getValue().equals(zoneId)) continue;
            return en.getKey();
        }
        return null;
    }

    @NotNull
    public static Integer zoneIdOrThrow(ZoneId zoneId) {
        Integer t = TimezoneEnumUtil.zoneIdOrNull(zoneId);
        if (t == null) {
            throw new IllegalArgumentException("can not found ZoneId by zoneId=" + String.valueOf(zoneId));
        }
        return t;
    }

    @NotNull
    public static Integer zoneIdOrHint(ZoneId zoneId, String hint) {
        Integer t = TimezoneEnumUtil.zoneIdOrNull(zoneId);
        if (t == null) {
            throw new IllegalArgumentException(hint);
        }
        return t;
    }

    @NotNull
    public static Integer zoneIdOrElse(ZoneId zoneId, Integer el) {
        Integer t = TimezoneEnumUtil.zoneIdOrNull(zoneId);
        return t == null ? el : t;
    }

    @SafeVarargs
    @Nullable
    public static <T extends StandardTimezoneEnum> T zoneIdOrNull(String zoneId, T ... es) {
        if (zoneId == null || es == null || es.length == 0) {
            return null;
        }
        return (T)TimezoneEnumUtil.zoneIdOrNull((ZoneId)ZoneIdResolver.zoneId((String)zoneId), es);
    }

    @SafeVarargs
    @Nullable
    public static <T extends StandardTimezoneEnum> T zoneIdOrNull(ZoneId zoneId, T ... es) {
        if (zoneId == null || es == null || es.length == 0) {
            return null;
        }
        String zidStr = zoneId.getId();
        for (T e : es) {
            if (!e.toZoneId().getId().equalsIgnoreCase(zidStr)) continue;
            return e;
        }
        return null;
    }

    @SafeVarargs
    @NotNull
    public static <T extends StandardTimezoneEnum> T zoneIdOrThrow(String zoneId, T ... es) {
        StandardTimezoneEnum t = TimezoneEnumUtil.zoneIdOrNull((String)zoneId, es);
        if (t == null) {
            throw new IllegalArgumentException("can not found StandardTimezoneEnum by zoneId=" + zoneId);
        }
        return (T)t;
    }

    @SafeVarargs
    @NotNull
    public static <T extends StandardTimezoneEnum> T zoneIdOrThrow(ZoneId zoneId, T ... es) {
        StandardTimezoneEnum t = TimezoneEnumUtil.zoneIdOrNull((ZoneId)zoneId, es);
        if (t == null) {
            throw new IllegalArgumentException("can not found StandardTimezoneEnum by zoneId=" + String.valueOf(zoneId));
        }
        return (T)t;
    }

    @SafeVarargs
    @NotNull
    public static <T extends StandardTimezoneEnum> T zoneIdOrHint(String zoneId, String hint, T ... es) {
        StandardTimezoneEnum t = TimezoneEnumUtil.zoneIdOrNull((String)zoneId, es);
        if (t == null) {
            throw new IllegalArgumentException(hint);
        }
        return (T)t;
    }

    @SafeVarargs
    @NotNull
    public static <T extends StandardTimezoneEnum> T zoneIdOrHint(ZoneId zoneId, String hint, T ... es) {
        StandardTimezoneEnum t = TimezoneEnumUtil.zoneIdOrNull((ZoneId)zoneId, es);
        if (t == null) {
            throw new IllegalArgumentException(hint);
        }
        return (T)t;
    }

    @SafeVarargs
    @NotNull
    public static <T extends StandardTimezoneEnum> T zoneIdOrElse(String zoneId, T el, T ... es) {
        StandardTimezoneEnum t = TimezoneEnumUtil.zoneIdOrNull((String)zoneId, es);
        return (T)(t == null ? el : t);
    }

    @SafeVarargs
    @NotNull
    public static <T extends StandardTimezoneEnum> T zoneIdOrElse(ZoneId zoneId, T el, T ... es) {
        StandardTimezoneEnum t = TimezoneEnumUtil.zoneIdOrNull((ZoneId)zoneId, es);
        return (T)(t == null ? el : t);
    }
}

