/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.service.journal;

import java.beans.Transient;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class JournalDiff {
    private int count = 0;
    @NotNull
    private String table = "";
    @NotNull
    private List<String> column = Collections.emptyList();
    @NotNull
    private List<Object> value1 = Collections.emptyList();
    @NotNull
    private List<Object> value2 = Collections.emptyList();
    private transient boolean typed = false;

    @Transient
    public boolean isTyped() {
        return this.typed;
    }

    @Transient
    public boolean hasRecord() {
        return this.count > 0 && !this.table.isEmpty();
    }

    @Transient
    public boolean isValid() {
        return this.isInsert() || this.isUpdate() || this.isDelete();
    }

    @Transient
    public boolean isInsert() {
        return this.hasRecord() && this.value1.isEmpty() && this.value2.size() == this.column.size() * this.count;
    }

    @Transient
    public boolean isDelete() {
        return this.hasRecord() && this.value1.size() == this.column.size() * this.count && this.value2.isEmpty();
    }

    @Transient
    public boolean isUpdate() {
        int cs = this.column.size() * this.count;
        return this.hasRecord() && this.value1.size() == cs && this.value2.size() == cs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JournalDiff)) {
            return false;
        }
        JournalDiff diff = (JournalDiff)o;
        return this.count == diff.count && this.table.equals(diff.table) && this.column.equals(diff.column) && this.value1.equals(diff.value1) && this.value2.equals(diff.value2);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.table, this.column, this.value1, this.value2);
    }

    public String toString() {
        return "JournalDiff{count=" + this.count + ", table='" + this.table + "', column=" + String.valueOf(this.column) + ", value1=" + String.valueOf(this.value1) + ", value2=" + String.valueOf(this.value2) + "}";
    }

    @Generated
    public int getCount() {
        return this.count;
    }

    @NotNull
    @Generated
    public String getTable() {
        return this.table;
    }

    @NotNull
    @Generated
    public List<String> getColumn() {
        return this.column;
    }

    @NotNull
    @Generated
    public List<Object> getValue1() {
        return this.value1;
    }

    @NotNull
    @Generated
    public List<Object> getValue2() {
        return this.value2;
    }

    @Generated
    public void setCount(int count) {
        this.count = count;
    }

    @Generated
    public void setTable(@NotNull String table) {
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        this.table = table;
    }

    @Generated
    public void setColumn(@NotNull List<String> column) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        this.column = column;
    }

    @Generated
    public void setValue1(@NotNull List<Object> value1) {
        if (value1 == null) {
            throw new NullPointerException("value1 is marked non-null but is null");
        }
        this.value1 = value1;
    }

    @Generated
    public void setValue2(@NotNull List<Object> value2) {
        if (value2 == null) {
            throw new NullPointerException("value2 is marked non-null but is null");
        }
        this.value2 = value2;
    }

    @Generated
    public void setTyped(boolean typed) {
        this.typed = typed;
    }
}

