/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.spring.bean;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.core.JdbcTemplate;
import pro.fessional.wings.faceless.database.DataSourceContext;
import pro.fessional.wings.faceless.database.manual.single.modify.commitjournal.CommitJournalModify;
import pro.fessional.wings.faceless.database.manual.single.modify.commitjournal.impl.CommitJournalModifyJdbc;
import pro.fessional.wings.faceless.service.flakeid.impl.FlakeIdLightIdImpl;
import pro.fessional.wings.faceless.service.journal.impl.DefaultJournalService;
import pro.fessional.wings.faceless.service.lightid.BlockIdProvider;
import pro.fessional.wings.faceless.service.lightid.LightIdService;
import pro.fessional.wings.faceless.service.wini18n.impl.StandardI18nServiceJdbc;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class FacelessConfiguration {
    private static final Log log = LogFactory.getLog(FacelessConfiguration.class);

    @Bean
    @Lazy
    @ConditionalWingsEnabled
    public DataSourceContext dataSourceContext(DataSource current, List<DataSourceContext.Customizer> customizes) {
        DataSourceContext ctx = new DataSourceContext();
        ctx.setCurrent(current);
        ctx.addBackend("Current", current);
        for (DataSourceContext.Customizer it : customizes) {
            boolean md = it.customize(ctx);
            log.info((Object)("Faceless spring-bean dataSourceContext by modifier skipOthers=" + md + ", clz=" + String.valueOf(it.getClass())));
            if (!md) continue;
            break;
        }
        log.info((Object)("Faceless\ud83e\udd84 database-current-url=" + ctx.cacheJdbcUrl(ctx.getCurrent())));
        LinkedHashMap<String, DataSource> backends = ctx.getBackends();
        for (Map.Entry e : backends.entrySet()) {
            log.info((Object)("Faceless\ud83e\udd84 database-" + (String)e.getKey() + "-url=" + ctx.cacheJdbcUrl((DataSource)e.getValue())));
        }
        return ctx;
    }

    @Bean
    @ConditionalWingsEnabled
    public StandardI18nServiceJdbc standardI18nService(JdbcTemplate jdbcTemplate) {
        log.info((Object)"Faceless spring-bean standardI18nService");
        return new StandardI18nServiceJdbc(jdbcTemplate);
    }

    @Bean
    @ConditionalWingsEnabled(abs="wings.enabled.faceless.simple-flakeid")
    public FlakeIdLightIdImpl flakeIdService(LightIdService lightIdService) {
        log.info((Object)"Faceless spring-bean flakeIdService");
        return new FlakeIdLightIdImpl(lightIdService);
    }

    @Bean
    @ConditionalWingsEnabled
    public CommitJournalModifyJdbc commitJournalModify(JdbcTemplate jdbcTemplate) {
        log.info((Object)"Faceless spring-bean commitJournalModify");
        return new CommitJournalModifyJdbc(jdbcTemplate);
    }

    @Bean
    @ConditionalWingsEnabled(abs="wings.enabled.faceless.simple-journal")
    public DefaultJournalService journalService(LightIdService lightIdService, BlockIdProvider blockIdProvider, CommitJournalModify journalModify) {
        log.info((Object)"Faceless spring-bean journalService");
        return new DefaultJournalService(lightIdService, blockIdProvider, journalModify);
    }
}

