/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.database.helper;

import java.util.HashSet;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;

public class JdbcTemplateHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcTemplateHelper.class);
    public static final ResultSetExtractor<String> FirstStringOrNull = rs -> rs.next() ? rs.getString(1) : null;
    public static final ResultSetExtractor<Long> FirstLongOrNull = rs -> {
        if (rs.next()) {
            long v = rs.getLong(1);
            return rs.wasNull() ? null : Long.valueOf(v);
        }
        return null;
    };
    public static final ResultSetExtractor<Integer> FirstIntegerOrNull = rs -> {
        if (rs.next()) {
            int v = rs.getInt(1);
            return rs.wasNull() ? null : Integer.valueOf(v);
        }
        return null;
    };
    public static final ResultSetExtractor<Boolean> FirstBooleanOrNull = rs -> {
        if (rs.next()) {
            boolean v = rs.getBoolean(1);
            return rs.wasNull() ? null : Boolean.valueOf(v);
        }
        return null;
    };
    protected static final HashSet<String> SafeTables = new HashSet();
    protected static final HashSet<String> QuotedTables = new HashSet();
    @NotNull
    protected static String ShowTableSql = "SHOW TABLES";
    @NotNull
    protected static Function<String, String> Quotes = name -> "`" + name + "`";

    public static String safeWhere(String where) {
        if (where == null || where.isEmpty()) {
            throw new IllegalArgumentException("where clause is empty");
        }
        if (where.contains(";")) {
            throw new IllegalArgumentException("where clause may be sql-injected, should not contains ';'");
        }
        String key = " WHERE ";
        if (!where.regionMatches(true, 0, " WHERE ", 0, " WHERE ".length())) {
            throw new IllegalArgumentException("missing ' WHERE ' in where clause");
        }
        return where;
    }

    public static void initSafeTable(JdbcTemplate tmpl) {
        tmpl.query(ShowTableSql, rs -> {
            String tbl = rs.getString(1);
            log.info("init safe table={}", (Object)tbl);
            String lc = tbl.toLowerCase();
            String uc = tbl.toUpperCase();
            SafeTables.add(lc);
            SafeTables.add(uc);
            QuotedTables.add(Quotes.apply(lc));
            QuotedTables.add(Quotes.apply(uc));
        });
    }

    public static boolean isSafeTable(String table) {
        return SafeTables.contains(table) || QuotedTables.contains(table);
    }

    public static String safeName(@NotNull String name) {
        return Quotes.apply(name);
    }

    public static String safeTable(String table) {
        if (table == null || table.isEmpty()) {
            throw new NullPointerException("table is empty");
        }
        int safe = 0;
        if (SafeTables.contains(table)) {
            safe = 1;
        } else if (QuotedTables.contains(table)) {
            safe = 2;
        }
        if (safe == 0) {
            throw new IllegalArgumentException("unsafe table " + table);
        }
        return safe == 1 ? Quotes.apply(table) : table;
    }
}

