/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.database.helper;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import pro.fessional.mirana.best.DummyBlock;
import pro.fessional.mirana.time.DateFormatter;
import pro.fessional.wings.faceless.database.helper.JdbcTemplateHelper;
import pro.fessional.wings.faceless.service.journal.JournalService;

public class JournalJdbcHelper {
    public static final String COL_CREATE_DT = "create_dt";
    public static final String COL_MODIFY_DT = "modify_dt";
    public static final String COL_MODIFY_TM = "modify_time";
    public static final String COL_DELETE_DT = "delete_dt";
    public static final String COL_IS_DELETED = "is_deleted";
    public static final String COL_COMMIT_ID = "commit_id";
    private static final Map<String, String> tableJournal = new ConcurrentHashMap<String, String>();
    private static final ResultSetExtractor<String> filedJournal = rs -> JournalJdbcHelper.getJournalDateColumn(rs, false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJournalDateColumn(ResultSet rs, boolean needClose) {
        try {
            String[] columns = JournalJdbcHelper.extractColumn(rs.getMetaData(), COL_DELETE_DT, COL_MODIFY_DT, COL_MODIFY_TM);
            if (columns[0] != null) {
                String string = columns[0];
                return string;
            }
            if (columns[1] != null) {
                String string = columns[1];
                return string;
            }
        }
        catch (SQLException e) {
            DummyBlock.ignore((Throwable)e);
        }
        finally {
            if (needClose) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    DummyBlock.ignore((Throwable)e);
                }
            }
        }
        return "";
    }

    public static String getJournalDateColumn(String table, Function<String, String> fun) {
        return tableJournal.computeIfAbsent(table, fun);
    }

    public static String getJournalDateColumn(JdbcTemplate tmpl, String table) {
        return JournalJdbcHelper.getJournalDateColumn(table, (String s) -> {
            String tbl = JdbcTemplateHelper.safeTable(s);
            String sql = "SELECT * FROM " + tbl + " WHERE 1 = 0";
            return (String)tmpl.query(sql, filedJournal);
        });
    }

    public static int deleteByIds(JdbcTemplate tmpl, String table, JournalService.Journal commit, Long ... ids) {
        return JournalJdbcHelper.deleteByIds(tmpl, table, (Long)commit.getCommitId(), commit.getCommitDt(), ids);
    }

    public static int deleteByIds(JdbcTemplate tmpl, String table, JournalService.Journal commit, Collection<Long> ids) {
        return JournalJdbcHelper.deleteByIds(tmpl, table, (Long)commit.getCommitId(), commit.getCommitDt(), ids);
    }

    public static int deleteByIds(JdbcTemplate tmpl, String table, Long commitId, Long ... ids) {
        return JournalJdbcHelper.deleteByIds(tmpl, table, commitId, null, ids);
    }

    public static int deleteByIds(JdbcTemplate tmpl, String table, Long commitId, Collection<Long> ids) {
        return JournalJdbcHelper.deleteByIds(tmpl, table, commitId, null, ids);
    }

    public static int deleteByIds(JdbcTemplate tmpl, String table, Long commitId, LocalDateTime now, Long ... ids) {
        if (ids == null || ids.length == 0) {
            return 0;
        }
        return JournalJdbcHelper.deleteByIds(tmpl, table, commitId, now, Arrays.asList(ids));
    }

    public static int deleteByIds(JdbcTemplate tmpl, String table, Long commitId, LocalDateTime now, Collection<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return 0;
        }
        StringBuilder where = new StringBuilder(" WHERE id IN (");
        for (Long id : ids) {
            where.append(id).append(',');
        }
        where.deleteCharAt(where.length() - 1);
        where.append(')');
        return JournalJdbcHelper.deleteWhere(tmpl, table, commitId, now, where.toString(), new Object[0]);
    }

    public static int deleteWhere(JdbcTemplate tmpl, String table, JournalService.Journal commit, String where, Object ... args) {
        return JournalJdbcHelper.deleteWhere(tmpl, table, (Long)commit.getCommitId(), commit.getCommitDt(), where, args);
    }

    public static int deleteWhere(JdbcTemplate tmpl, String table, Long commitId, String where, Object ... args) {
        return JournalJdbcHelper.deleteWhere(tmpl, table, commitId, null, where, args);
    }

    public static int deleteWhere(JdbcTemplate tmpl, String table, Long commitId, LocalDateTime now, String where, Object ... args) {
        where = JdbcTemplateHelper.safeWhere(where);
        table = JdbcTemplateHelper.safeTable(table);
        String jf = JournalJdbcHelper.getJournalDateColumn(tmpl, table);
        Object journalSetter = " ";
        if (!jf.isEmpty()) {
            String ldt = now == null ? "NOW(3)" : "'" + DateFormatter.full19((LocalDateTime)now) + "'";
            journalSetter = ", " + jf + "=" + ldt + " ";
        }
        String update = "UPDATE " + table + " SET commit_id=" + commitId + (String)journalSetter + where;
        tmpl.update(update, args);
        String delete = "DELETE FROM " + table + " " + where;
        return tmpl.update(delete, args);
    }

    public static String[] extractColumn(ResultSetMetaData md, String ... name) throws SQLException {
        String[] result = new String[name.length];
        int count = md.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String cn = JournalJdbcHelper.getFieldName(md.getColumnName(i));
            for (int j = 0; j < name.length; ++j) {
                if (result[j] != null || !cn.equalsIgnoreCase(name[j])) continue;
                result[j] = cn;
            }
        }
        return result;
    }

    public static String getFieldName(String name) {
        int dot = name.lastIndexOf(46);
        return dot < 0 ? name : name.substring(dot + 1);
    }
}

