/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.database.manual.single.select.lightsequence.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import pro.fessional.mirana.data.U;
import pro.fessional.mirana.math.AnyIntegerUtil;
import pro.fessional.wings.faceless.database.manual.single.select.lightsequence.LightSequenceSelect;

public class LightSequenceSelectJdbc
implements LightSequenceSelect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LightSequenceSelectJdbc.class);
    private final JdbcTemplate jdbcTemplate;
    private final String selectOne;
    private final String selectAll;
    private final String adjustTbl;
    private final RowMapper<LightSequenceSelect.NextStep> mapperNextStep = (rs, ignored) -> {
        LightSequenceSelect.NextStep one = new LightSequenceSelect.NextStep();
        long nextVal = rs.getLong("next_val");
        one.setNextVal(nextVal);
        one.setOldNext(nextVal);
        one.setStepVal(rs.getInt("step_val"));
        return one;
    };
    private final RowMapper<LightSequenceSelect.NameNextStep> mapperNameNextStep = (rs, ignored) -> {
        LightSequenceSelect.NameNextStep one = new LightSequenceSelect.NameNextStep();
        one.setSeqName(rs.getString("seq_name"));
        one.setStepVal(rs.getInt("step_val"));
        one.setStepVal(rs.getInt("step_val"));
        return one;
    };
    private final Map<String, Long> adjusted = new ConcurrentHashMap<String, Long>();
    private final ResultSetExtractor<U.Two<String, String>> headTableKey = rs -> rs.next() ? U.of((Object)rs.getString(1), (Object)rs.getString(2)) : null;

    @Override
    @Nullable
    public LightSequenceSelect.NextStep selectOneLock(int block, @NotNull String name) {
        List list = this.jdbcTemplate.query(this.selectOne, this.mapperNextStep, new Object[]{block, name});
        int size = list.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            LightSequenceSelect.NextStep st = (LightSequenceSelect.NextStep)list.get(0);
            LightSequenceSelect.NameNextStep ad = this.checkTableAndAdjust(st, name);
            return ad == null ? st : ad;
        }
        throw new IllegalStateException("find " + size + " records, block=" + block + ", name=" + name);
    }

    @Override
    public List<LightSequenceSelect.NameNextStep> selectAllLock(int block) {
        List all = this.jdbcTemplate.query(this.selectAll, this.mapperNameNextStep, new Object[]{block});
        try {
            ArrayList<LightSequenceSelect.NameNextStep> adjust = new ArrayList<LightSequenceSelect.NameNextStep>(all.size());
            for (LightSequenceSelect.NameNextStep st : all) {
                LightSequenceSelect.NameNextStep ad = this.checkTableAndAdjust(st, st.getSeqName());
                adjust.add(ad == null ? st : ad);
            }
            return adjust;
        }
        catch (Exception e) {
            log.error("failed to adjust LightSequence", (Throwable)e);
            return all;
        }
    }

    private LightSequenceSelect.NameNextStep checkTableAndAdjust(LightSequenceSelect.NextStep step, String name) {
        long cur;
        if (this.adjustTbl == null || this.adjustTbl.isEmpty()) {
            return null;
        }
        long dbMax = this.adjusted.computeIfAbsent(name, ignored -> {
            try {
                U.Two two = (U.Two)this.jdbcTemplate.query(this.adjustTbl, this.headTableKey, new Object[]{name});
                if (two == null) {
                    return Long.MIN_VALUE;
                }
                String sql = "SELECT MAX(" + (String)two.two() + ") FROM " + (String)two.one();
                Long max = (Long)this.jdbcTemplate.queryForObject(sql, Long.class);
                return max == null ? Long.MIN_VALUE : max;
            }
            catch (Exception e) {
                log.warn("LightSequence failed to load dbMax, name=" + name, (Throwable)e);
                return Long.MIN_VALUE;
            }
        });
        if (dbMax < (cur = step.getNextVal())) {
            return null;
        }
        long nid = AnyIntegerUtil.next64((long)dbMax, (long)10L);
        log.warn("LightSequence adjust, name={}, cur={}, db={}, to={}", new Object[]{name, cur, dbMax, nid});
        LightSequenceSelect.NameNextStep nn = new LightSequenceSelect.NameNextStep();
        nn.setSeqName(name);
        nn.setNextVal(nid);
        nn.setStepVal(step.getStepVal());
        nn.setOldNext(step.getOldNext());
        return nn;
    }

    @Generated
    public LightSequenceSelectJdbc(JdbcTemplate jdbcTemplate, String selectOne, String selectAll, String adjustTbl) {
        this.jdbcTemplate = jdbcTemplate;
        this.selectOne = selectOne;
        this.selectAll = selectAll;
        this.adjustTbl = adjustTbl;
    }
}

