/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.enums.autogen;

import java.time.ZoneId;
import java.util.TimeZone;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.i18n.ZoneIdResolver;
import pro.fessional.wings.faceless.enums.StandardTimezoneEnum;

public enum StandardTimezone implements StandardTimezoneEnum
{
    SUPER(1010100, "standard_timezone", "standard timezone", "classpath:/wings-tmpl/StandardTimezoneTemplate.java"),
    GMT(1010101, "GMT", "Greenwich Mean Time (Zero)", ""),
    ASIA_SHANGHAI(1010201, "Asia/Shanghai", "China: BeiJing, ShangHai, HongKong", "China"),
    AMERICA_CHICAGO(1010301, "America/Chicago", "CST: Chicago, Houston", "USA"),
    AMERICA_LOS_ANGELES(1010302, "America/Los_Angeles", "PST: L.A., Seattle", "USA"),
    AMERICA_NEW_YORK(1010303, "America/New_York", "EST: NewYork, D.C.", "USA"),
    AMERICA_PHOENIX(1010304, "America/Phoenix", "MST: Denver, Phoenix", "USA"),
    US_ALASKA(1010305, "US/Alaska", "AKST: Alaska, Fairbanks", "USA"),
    US_HAWAII(1010306, "US/Hawaii", "HST: Hawaii, Honolulu", "USA"),
    ASIA_JAKARTA(1010401, "Asia/Jakarta", "Indonesia: Jakarta, Surabaya, Medan", "Indonesia"),
    ASIA_JAYAPURA(1010402, "Asia/Jayapura", "Indonesia: Jayapura, Manokwari", "Indonesia"),
    ASIA_MAKASSAR(1010403, "Asia/Makassar", "Indonesia: Makassar, Manado, Balikpapan", "Indonesia"),
    ASIA_KUALA_LUMPUR(1010501, "Asia/Kuala_Lumpur", "Malaysia: KualaLumpur", "Malaysia"),
    ASIA_SEOUL(1010601, "Asia/Seoul", "Korea: Seoul", "Korea"),
    ASIA_SINGAPORE(1010701, "Asia/Singapore", "Singapore", "Singapore"),
    ASIA_TOKYO(1010801, "Asia/Tokyo", "Japan: Tokyo", "Japan"),
    CANADA_ATLANTIC(1010901, "Canada/Atlantic", "AST: Halifax", "Canada"),
    CANADA_CENTRAL(1010902, "Canada/Central", "CST: Winnipeg", "Canada"),
    CANADA_EASTERN(1010903, "Canada/Eastern", "EST: Toronto, Ottawa, Quebec", "Canada"),
    CANADA_MOUNTAIN(1010904, "Canada/Mountain", "MST: Edmonton, Calgary", "Canada"),
    CANADA_NEWFOUNDLAND(1010905, "Canada/Newfoundland", "NST: St.John", "Canada"),
    CANADA_PACIFIC(1010906, "Canada/Pacific", "PST: Vancouver", "Canada");

    public static final String $SUPER;
    public static final String $GMT;
    public static final String $ASIA_SHANGHAI;
    public static final String $AMERICA_CHICAGO;
    public static final String $AMERICA_LOS_ANGELES;
    public static final String $AMERICA_NEW_YORK;
    public static final String $AMERICA_PHOENIX;
    public static final String $US_ALASKA;
    public static final String $US_HAWAII;
    public static final String $ASIA_JAKARTA;
    public static final String $ASIA_JAYAPURA;
    public static final String $ASIA_MAKASSAR;
    public static final String $ASIA_KUALA_LUMPUR;
    public static final String $ASIA_SEOUL;
    public static final String $ASIA_SINGAPORE;
    public static final String $ASIA_TOKYO;
    public static final String $CANADA_ATLANTIC;
    public static final String $CANADA_CENTRAL;
    public static final String $CANADA_EASTERN;
    public static final String $CANADA_MOUNTAIN;
    public static final String $CANADA_NEWFOUNDLAND;
    public static final String $CANADA_PACIFIC;
    public static final boolean useIdAsKey = true;
    private final int id;
    private final String code;
    private final String hint;
    private final String info;
    private final String ukey;
    private final String rkey;
    private final TimeZone zone;
    private final ZoneId tzid;

    private StandardTimezone(int id, String code, String hint, String info) {
        this.id = id;
        this.code = code;
        this.hint = hint;
        this.info = info;
        this.ukey = "standard_timezone.id." + id;
        this.rkey = "sys_constant_enum.hint." + this.ukey;
        this.tzid = ZoneIdResolver.zoneId((String)code);
        this.zone = ZoneIdResolver.timeZone((String)code);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getType() {
        return "standard_timezone";
    }

    @Override
    @NotNull
    public String getInfo() {
        return this.info;
    }

    @Override
    public TimeZone toTimeZone() {
        return this.zone;
    }

    @Override
    public ZoneId toZoneId() {
        return this.tzid;
    }

    @Override
    @NotNull
    public String getBase() {
        return "sys_constant_enum";
    }

    @Override
    @NotNull
    public String getKind() {
        return "hint";
    }

    @Override
    @NotNull
    public String getUkey() {
        return this.ukey;
    }

    @NotNull
    public String getCode() {
        return this.code;
    }

    @NotNull
    public String getHint() {
        return this.hint;
    }

    @Override
    @NotNull
    public String getI18nCode() {
        return this.rkey;
    }

    @Nullable
    public static StandardTimezone valueOf(int id) {
        for (StandardTimezone v : StandardTimezone.values()) {
            if (id != v.id) continue;
            return v;
        }
        return null;
    }

    @Contract(value="_, !null -> !null")
    public static StandardTimezone idOf(Integer id, StandardTimezone elz) {
        if (id == null) {
            return elz;
        }
        int i = id;
        for (StandardTimezone v : StandardTimezone.values()) {
            if (i != v.id) continue;
            return v;
        }
        return elz;
    }

    @Contract(value="_, !null -> !null")
    public static StandardTimezone codeOf(String code, StandardTimezone elz) {
        if (code == null) {
            return elz;
        }
        for (StandardTimezone v : StandardTimezone.values()) {
            if (!code.equalsIgnoreCase(v.code)) continue;
            return v;
        }
        return elz;
    }

    @Contract(value="_, !null -> !null")
    public static StandardTimezone nameOf(String name, StandardTimezone elz) {
        if (name == null) {
            return elz;
        }
        for (StandardTimezone v : StandardTimezone.values()) {
            if (!name.equalsIgnoreCase(v.name())) continue;
            return v;
        }
        return elz;
    }

    static {
        $SUPER = StandardTimezone.SUPER.code;
        $GMT = StandardTimezone.GMT.code;
        $ASIA_SHANGHAI = StandardTimezone.ASIA_SHANGHAI.code;
        $AMERICA_CHICAGO = StandardTimezone.AMERICA_CHICAGO.code;
        $AMERICA_LOS_ANGELES = StandardTimezone.AMERICA_LOS_ANGELES.code;
        $AMERICA_NEW_YORK = StandardTimezone.AMERICA_NEW_YORK.code;
        $AMERICA_PHOENIX = StandardTimezone.AMERICA_PHOENIX.code;
        $US_ALASKA = StandardTimezone.US_ALASKA.code;
        $US_HAWAII = StandardTimezone.US_HAWAII.code;
        $ASIA_JAKARTA = StandardTimezone.ASIA_JAKARTA.code;
        $ASIA_JAYAPURA = StandardTimezone.ASIA_JAYAPURA.code;
        $ASIA_MAKASSAR = StandardTimezone.ASIA_MAKASSAR.code;
        $ASIA_KUALA_LUMPUR = StandardTimezone.ASIA_KUALA_LUMPUR.code;
        $ASIA_SEOUL = StandardTimezone.ASIA_SEOUL.code;
        $ASIA_SINGAPORE = StandardTimezone.ASIA_SINGAPORE.code;
        $ASIA_TOKYO = StandardTimezone.ASIA_TOKYO.code;
        $CANADA_ATLANTIC = StandardTimezone.CANADA_ATLANTIC.code;
        $CANADA_CENTRAL = StandardTimezone.CANADA_CENTRAL.code;
        $CANADA_EASTERN = StandardTimezone.CANADA_EASTERN.code;
        $CANADA_MOUNTAIN = StandardTimezone.CANADA_MOUNTAIN.code;
        $CANADA_NEWFOUNDLAND = StandardTimezone.CANADA_NEWFOUNDLAND.code;
        $CANADA_PACIFIC = StandardTimezone.CANADA_PACIFIC.code;
    }
}

