/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.service.journal;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.cast.EnumConvertor;
import pro.fessional.wings.faceless.convention.EmptyValue;
import pro.fessional.wings.faceless.service.journal.JournalAware;

public interface JournalService {
    @NotNull
    public <R> R submit(@NotNull String var1, @Nullable String var2, @Nullable String var3, @Nullable String var4, @NotNull Function<Journal, R> var5);

    default public Journal commit(@NotNull String eventName, @Nullable String loginInfo, @Nullable String targetKey, @Nullable String otherInfo, @NotNull Consumer<Journal> commitSet) {
        return this.submit(eventName, loginInfo, targetKey, otherInfo, (Journal journal) -> {
            commitSet.accept((Journal)journal);
            return journal;
        });
    }

    @NotNull
    default public <R> R submit(@NotNull Class<?> eventClass, @Nullable String loginInfo, @Nullable Object targetKey, @Nullable Object otherInfo, @NotNull Function<Journal, R> commitSet) {
        String lgn = loginInfo == null ? "" : loginInfo;
        String key = targetKey == null ? "" : String.valueOf(targetKey);
        String oth = otherInfo == null ? "" : String.valueOf(otherInfo);
        return this.submit(eventClass.getName(), lgn, key, oth, commitSet);
    }

    default public Journal commit(@NotNull Class<?> eventClass, @Nullable String loginInfo, @Nullable Object targetKey, @Nullable Object otherInfo, @NotNull Consumer<Journal> commitSet) {
        return this.submit(eventClass, loginInfo, targetKey, otherInfo, (Journal journal) -> {
            commitSet.accept((Journal)journal);
            return journal;
        });
    }

    @NotNull
    default public <R> R submit(@NotNull Class<?> eventClass, @Nullable Object targetKey, @Nullable Object otherInfo, @NotNull Function<Journal, R> commitSet) {
        return this.submit(eventClass, null, targetKey, otherInfo, commitSet);
    }

    default public Journal commit(@NotNull Class<?> eventClass, @Nullable Object targetKey, @Nullable Object otherInfo, @NotNull Consumer<Journal> commitSet) {
        return this.commit(eventClass, null, targetKey, otherInfo, commitSet);
    }

    @NotNull
    default public <R> R submit(@NotNull Class<?> eventClass, @Nullable Object targetKey, @NotNull Function<Journal, R> commitSet) {
        return this.submit(eventClass, null, targetKey, null, commitSet);
    }

    default public Journal commit(@NotNull Class<?> eventClass, @Nullable Object targetKey, @NotNull Consumer<Journal> commitSet) {
        return this.commit(eventClass, null, targetKey, null, commitSet);
    }

    @NotNull
    default public <R> R submit(@NotNull Class<?> eventClass, @NotNull Function<Journal, R> commitSet) {
        return this.submit(eventClass, null, null, null, commitSet);
    }

    default public Journal commit(@NotNull Class<?> eventClass, @NotNull Consumer<Journal> commitSet) {
        return this.commit(eventClass, null, null, null, commitSet);
    }

    @NotNull
    default public <R> R submit(@NotNull Enum<?> eventEnum, @Nullable String loginInfo, @Nullable Object targetKey, @Nullable Object otherInfo, @NotNull Function<Journal, R> commitSet) {
        String lgn = loginInfo == null ? "" : loginInfo;
        String key = targetKey == null ? "" : String.valueOf(targetKey);
        String oth = otherInfo == null ? "" : String.valueOf(otherInfo);
        return this.submit(EnumConvertor.enum2Str(eventEnum), lgn, key, oth, commitSet);
    }

    default public Journal commit(@NotNull Enum<?> eventEnum, @Nullable String loginInfo, @Nullable Object targetKey, @Nullable Object otherInfo, @NotNull Consumer<Journal> commitSet) {
        return this.submit(eventEnum, loginInfo, targetKey, otherInfo, (Journal journal) -> {
            commitSet.accept((Journal)journal);
            return journal;
        });
    }

    @NotNull
    default public <R> R submit(@NotNull Enum<?> eventEnum, @Nullable Object targetKey, @Nullable Object otherInfo, @NotNull Function<Journal, R> commitSet) {
        return this.submit(eventEnum, null, targetKey, otherInfo, commitSet);
    }

    default public Journal commit(@NotNull Enum<?> eventEnum, @Nullable Object targetKey, @Nullable Object otherInfo, @NotNull Consumer<Journal> commitSet) {
        return this.commit(eventEnum, null, targetKey, otherInfo, commitSet);
    }

    @NotNull
    default public <R> R submit(@NotNull Enum<?> eventEnum, @Nullable Object targetKey, @NotNull Function<Journal, R> commitSet) {
        return this.submit(eventEnum, null, targetKey, null, commitSet);
    }

    default public Journal commit(@NotNull Enum<?> eventEnum, @Nullable Object targetKey, @NotNull Consumer<Journal> commitSet) {
        return this.commit(eventEnum, null, targetKey, null, commitSet);
    }

    @NotNull
    default public <R> R submit(@NotNull Enum<?> eventEnum, @NotNull Function<Journal, R> commitSet) {
        return this.submit(eventEnum, null, null, null, commitSet);
    }

    default public Journal commit(@NotNull Enum<?> eventEnum, @NotNull Consumer<Journal> commitSet) {
        return this.commit(eventEnum, null, null, null, commitSet);
    }

    public static class Journal {
        private final long commitId;
        private final LocalDateTime commitDt;
        private final String eventName;
        private final String targetKey;
        private final String loginInfo;
        private final String otherInfo;

        public void create(@Nullable JournalAware po) {
            if (po == null) {
                return;
            }
            po.setCommitId(this.commitId);
            po.setCreateDt(this.commitDt);
            po.setModifyDt(EmptyValue.DATE_TIME);
            po.setDeleteDt(EmptyValue.DATE_TIME);
        }

        public void modify(@Nullable JournalAware po) {
            if (po == null) {
                return;
            }
            po.setCommitId(this.commitId);
            po.setModifyDt(this.commitDt);
        }

        public void delete(@Nullable JournalAware po) {
            if (po == null) {
                return;
            }
            po.setCommitId(this.commitId);
            po.setDeleteDt(this.commitDt);
        }

        public void create(@Nullable Collection<? extends JournalAware> pos) {
            if (pos == null) {
                return;
            }
            for (JournalAware journalAware : pos) {
                this.create(journalAware);
            }
        }

        public void modify(@Nullable Collection<? extends JournalAware> pos) {
            if (pos == null) {
                return;
            }
            for (JournalAware journalAware : pos) {
                this.modify(journalAware);
            }
        }

        public void delete(@Nullable Collection<? extends JournalAware> pos) {
            if (pos == null) {
                return;
            }
            for (JournalAware journalAware : pos) {
                this.delete(journalAware);
            }
        }

        public long getId() {
            return this.commitId;
        }

        @Generated
        public long getCommitId() {
            return this.commitId;
        }

        @Generated
        public LocalDateTime getCommitDt() {
            return this.commitDt;
        }

        @Generated
        public String getEventName() {
            return this.eventName;
        }

        @Generated
        public String getTargetKey() {
            return this.targetKey;
        }

        @Generated
        public String getLoginInfo() {
            return this.loginInfo;
        }

        @Generated
        public String getOtherInfo() {
            return this.otherInfo;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Journal)) {
                return false;
            }
            Journal other = (Journal)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCommitId() != other.getCommitId()) {
                return false;
            }
            LocalDateTime this$commitDt = this.getCommitDt();
            LocalDateTime other$commitDt = other.getCommitDt();
            if (this$commitDt == null ? other$commitDt != null : !((Object)this$commitDt).equals(other$commitDt)) {
                return false;
            }
            String this$eventName = this.getEventName();
            String other$eventName = other.getEventName();
            if (this$eventName == null ? other$eventName != null : !this$eventName.equals(other$eventName)) {
                return false;
            }
            String this$targetKey = this.getTargetKey();
            String other$targetKey = other.getTargetKey();
            if (this$targetKey == null ? other$targetKey != null : !this$targetKey.equals(other$targetKey)) {
                return false;
            }
            String this$loginInfo = this.getLoginInfo();
            String other$loginInfo = other.getLoginInfo();
            if (this$loginInfo == null ? other$loginInfo != null : !this$loginInfo.equals(other$loginInfo)) {
                return false;
            }
            String this$otherInfo = this.getOtherInfo();
            String other$otherInfo = other.getOtherInfo();
            return !(this$otherInfo == null ? other$otherInfo != null : !this$otherInfo.equals(other$otherInfo));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Journal;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $commitId = this.getCommitId();
            result = result * 59 + (int)($commitId >>> 32 ^ $commitId);
            LocalDateTime $commitDt = this.getCommitDt();
            result = result * 59 + ($commitDt == null ? 43 : ((Object)$commitDt).hashCode());
            String $eventName = this.getEventName();
            result = result * 59 + ($eventName == null ? 43 : $eventName.hashCode());
            String $targetKey = this.getTargetKey();
            result = result * 59 + ($targetKey == null ? 43 : $targetKey.hashCode());
            String $loginInfo = this.getLoginInfo();
            result = result * 59 + ($loginInfo == null ? 43 : $loginInfo.hashCode());
            String $otherInfo = this.getOtherInfo();
            result = result * 59 + ($otherInfo == null ? 43 : $otherInfo.hashCode());
            return result;
        }

        @NotNull
        @Generated
        public String toString() {
            return "JournalService.Journal(commitId=" + this.getCommitId() + ", commitDt=" + String.valueOf(this.getCommitDt()) + ", eventName=" + this.getEventName() + ", targetKey=" + this.getTargetKey() + ", loginInfo=" + this.getLoginInfo() + ", otherInfo=" + this.getOtherInfo() + ")";
        }

        @Generated
        public Journal(long commitId, LocalDateTime commitDt, String eventName, String targetKey, String loginInfo, String otherInfo) {
            this.commitId = commitId;
            this.commitDt = commitDt;
            this.eventName = eventName;
            this.targetKey = targetKey;
            this.loginInfo = loginInfo;
            this.otherInfo = otherInfo;
        }
    }
}

