/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.service.journal.impl;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.faceless.database.helper.DaoAssert;
import pro.fessional.wings.faceless.database.manual.single.modify.commitjournal.CommitJournalModify;
import pro.fessional.wings.faceless.service.journal.JournalService;
import pro.fessional.wings.faceless.service.lightid.BlockIdProvider;
import pro.fessional.wings.faceless.service.lightid.LightIdService;

public class DefaultJournalService
implements JournalService {
    public static final String SEQ_JOURNAL = "sys_commit_journal";
    private final TransmittableThreadLocal<JournalService.Journal> context = new TransmittableThreadLocal();
    private final LightIdService lightIdService;
    private final BlockIdProvider blockIdProvider;
    private final CommitJournalModify journalModify;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @NotNull
    public <R> R submit(@NotNull String eventName, @Nullable String loginInfo, @Nullable String targetKey, @Nullable String otherInfo, @NotNull Function<JournalService.Journal, R> commitSet) {
        JournalService.Journal commit = (JournalService.Journal)this.context.get();
        if (commit == null) {
            long id = this.lightIdService.getId(SEQ_JOURNAL, this.blockIdProvider.getBlockId());
            JournalService.Journal journal = new JournalService.Journal(id, ThreadNow.localDateTime(), eventName, targetKey == null ? "" : targetKey, loginInfo == null ? "" : loginInfo, otherInfo == null ? "" : otherInfo);
            int rc = this.journalModify.insert(journal);
            DaoAssert.assertEq1(rc, "failed to insert Journal={}", journal);
            this.context.set((Object)journal);
            try {
                R r = commitSet.apply(journal);
                return r;
            }
            finally {
                this.context.remove();
            }
        }
        return commitSet.apply(commit);
    }

    @Generated
    public DefaultJournalService(LightIdService lightIdService, BlockIdProvider blockIdProvider, CommitJournalModify journalModify) {
        this.lightIdService = lightIdService;
        this.blockIdProvider = blockIdProvider;
        this.journalModify = journalModify;
    }
}

