/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.service.lightid.impl;

import lombok.Generated;
import org.springframework.jdbc.core.JdbcTemplate;
import pro.fessional.wings.faceless.database.helper.JdbcTemplateHelper;
import pro.fessional.wings.faceless.service.lightid.BlockIdProvider;

public class DefaultBlockIdProvider
implements BlockIdProvider {
    private final String sql;
    private final JdbcTemplate template;
    private volatile int blockId = Integer.MIN_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBlockId() {
        if (this.blockId != Integer.MIN_VALUE) {
            return this.blockId;
        }
        DefaultBlockIdProvider defaultBlockIdProvider = this;
        synchronized (defaultBlockIdProvider) {
            if (this.blockId == Integer.MIN_VALUE) {
                this.blockId = this.selectBlockId();
            }
        }
        return this.blockId;
    }

    private int selectBlockId() {
        Integer id = (Integer)this.template.query(this.sql, JdbcTemplateHelper.FirstIntegerOrNull);
        if (id == null) {
            throw new IllegalStateException("can not find blockId by sql=" + this.sql);
        }
        return id;
    }

    @Generated
    public DefaultBlockIdProvider(String sql, JdbcTemplate template) {
        this.sql = sql;
        this.template = template;
    }
}

