/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.spring.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import pro.fessional.mirana.id.LightIdBufferedProvider;
import pro.fessional.mirana.id.LightIdProvider;
import pro.fessional.mirana.id.LightIdUtil;
import pro.fessional.wings.faceless.database.manual.single.modify.lightsequence.LightSequenceModify;
import pro.fessional.wings.faceless.database.manual.single.modify.lightsequence.impl.LightSequenceModifyJdbc;
import pro.fessional.wings.faceless.database.manual.single.select.lightsequence.LightSequenceSelect;
import pro.fessional.wings.faceless.database.manual.single.select.lightsequence.impl.LightSequenceSelectJdbc;
import pro.fessional.wings.faceless.service.lightid.BlockIdProvider;
import pro.fessional.wings.faceless.service.lightid.impl.BlockingLightIdProvider;
import pro.fessional.wings.faceless.service.lightid.impl.DefaultBlockIdProvider;
import pro.fessional.wings.faceless.service.lightid.impl.LightIdMysqlLoader;
import pro.fessional.wings.faceless.service.lightid.impl.LightIdServiceImpl;
import pro.fessional.wings.faceless.spring.prop.LightIdInsertProp;
import pro.fessional.wings.faceless.spring.prop.LightIdLayoutProp;
import pro.fessional.wings.faceless.spring.prop.LightIdProviderProp;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class FacelessLightIdConfiguration {
    private static final Log log = LogFactory.getLog(FacelessLightIdConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    @ConditionalOnExpression(value="!'${wings.faceless.lightid.provider.block-type}'.equals('biz')")
    public BlockIdProvider blockProvider(LightIdProviderProp providerProp, ObjectProvider<JdbcTemplate> jdbcTemplate) {
        String blockType = providerProp.getBlockType();
        log.info((Object)("Faceless spring-bean lightIdProvider" + blockType));
        if ("sql".equalsIgnoreCase(blockType)) {
            return new DefaultBlockIdProvider(providerProp.getBlockPara(), (JdbcTemplate)jdbcTemplate.getIfAvailable());
        }
        if ("fix".equalsIgnoreCase(blockType)) {
            int id = Integer.parseInt(providerProp.getBlockPara());
            return () -> id;
        }
        if ("biz".equalsIgnoreCase(blockType)) {
            throw new IllegalArgumentException("should not be here for user biz bean");
        }
        throw new IllegalArgumentException("unsupported wings.faceless.lightid.provider.block-type=" + blockType);
    }

    @Bean
    @ConditionalWingsEnabled
    public LightSequenceSelectJdbc lightSequenceSelect(LightIdProviderProp prop, JdbcTemplate jdbcTemplate) {
        log.info((Object)"Faceless spring-bean lightSequenceSelect");
        return new LightSequenceSelectJdbc(jdbcTemplate, prop.getSequenceGetOne(), prop.getSequenceGetAll(), prop.getSequenceAdjust());
    }

    @Bean
    @ConditionalWingsEnabled
    public LightSequenceModifyJdbc lightSequenceModify(LightIdProviderProp providerProp, JdbcTemplate jdbcTemplate) {
        log.info((Object)"Faceless spring-bean lightSequenceModify");
        return new LightSequenceModifyJdbc(jdbcTemplate, providerProp.getSequenceInsert(), providerProp.getSequenceUpdate());
    }

    @Bean
    @ConditionalWingsEnabled
    public LightIdMysqlLoader lightIdLoader(LightSequenceSelect lightSequenceSelect, LightSequenceModify lightSequenceModify, LightIdInsertProp insertProp) {
        log.info((Object)"Faceless spring-bean lightIdLoader");
        return new LightIdMysqlLoader(lightSequenceSelect, lightSequenceModify, insertProp);
    }

    @Bean
    @ConditionalWingsEnabled
    @ConditionalOnProperty(name={"wings.faceless.lightid.provider.monotonic"}, havingValue="jvm")
    public LightIdBufferedProvider jvmLightIdProvider(LightIdProvider.Loader loader, LightIdProviderProp prop, ObjectProvider<LightIdProvider.Generator> generator) {
        log.info((Object)"Faceless spring-bean jvmLightIdProvider");
        LightIdBufferedProvider provider = new LightIdBufferedProvider(loader);
        provider.setTimeout(prop.getTimeout());
        provider.setErrAlive(prop.getErrAlive());
        provider.setMaxError(prop.getMaxError());
        provider.setMaxCount(prop.getMaxCount());
        generator.ifAvailable(arg_0 -> ((LightIdBufferedProvider)provider).setGenerator(arg_0));
        return provider;
    }

    @Bean
    @ConditionalWingsEnabled
    @ConditionalOnProperty(name={"wings.faceless.lightid.provider.monotonic"}, havingValue="db")
    public BlockingLightIdProvider dbLightIdProvider(LightIdProvider.Loader loader, LightIdProviderProp prop) {
        log.info((Object)"Faceless spring-bean dbLightIdProvider");
        log.warn((Object)"the BlockingLightIdProvider is slow, about 10ms per id");
        BlockingLightIdProvider provider = new BlockingLightIdProvider(loader);
        provider.setTimeout(prop.getTimeout());
        return provider;
    }

    @Bean
    @ConditionalWingsEnabled
    public LightIdServiceImpl lightIdService(LightIdProvider lightIdProvider, BlockIdProvider blockIdProvider) {
        log.info((Object)"Faceless spring-bean lightIdService");
        return new LightIdServiceImpl(lightIdProvider, blockIdProvider);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalWingsEnabled
    public static class LayoutWired {
        @Autowired
        public void auto(@NotNull LightIdLayoutProp prop) {
            Integer bb;
            Boolean bf = prop.getBlockFirst();
            if (bf != null) {
                log.info((Object)("Faceless spring-auto forceLightIdLayout forceBlockFirst=" + bf));
                LightIdUtil.forceBlockFirst((boolean)bf);
            }
            if ((bb = prop.getBlockBits()) != null) {
                log.info((Object)("Faceless spring-auto forceLightIdLayout forceBlockBit=" + bb));
                LightIdUtil.forceBlockBit((int)bb);
            }
        }
    }
}

