/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.convention;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import pro.fessional.wings.faceless.convention.EmptySugar;

public class SetterSugar {
    public static <T> boolean ifObj(@NotNull Consumer<T> setter, @NotNull Supplier<T> value, boolean truthy) {
        if (truthy) {
            setter.accept(value.get());
            return true;
        }
        return false;
    }

    public static <T> boolean ifObj(@NotNull Consumer<T> setter, T value) {
        return SetterSugar.ifObj(setter, value, Objects::nonNull);
    }

    public static <T> boolean ifObj(@NotNull Consumer<T> setter, T value, @NotNull Predicate<T> predicate) {
        if (predicate.test(value)) {
            setter.accept(value);
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> boolean ifObj(@NotNull Consumer<T> setter, T value, @NotNull Predicate<T> predicate, Supplier<T> ... values) {
        if (predicate.test(value)) {
            setter.accept(value);
            return true;
        }
        for (Supplier<T> supplier : values) {
            T v = supplier.get();
            if (!predicate.test(v)) continue;
            setter.accept(v);
            return true;
        }
        return false;
    }

    public static boolean ifVal(@NotNull IntConsumer setter, int value, boolean truthy) {
        if (truthy) {
            setter.accept(value);
            return true;
        }
        return false;
    }

    public static boolean ifVal(@NotNull IntConsumer setter, @NotNull IntSupplier value, boolean truthy) {
        if (truthy) {
            setter.accept(value.getAsInt());
            return true;
        }
        return false;
    }

    public static boolean ifVal(@NotNull IntConsumer setter, int value) {
        return SetterSugar.ifVal(setter, value, EmptySugar::nonEmptyValue);
    }

    public static boolean ifVal(@NotNull IntConsumer setter, int value, @NotNull IntPredicate predicate) {
        if (predicate.test(value)) {
            setter.accept(value);
            return true;
        }
        return false;
    }

    public static boolean ifVal(@NotNull IntConsumer setter, int value, @NotNull IntPredicate predicate, int ... values) {
        if (predicate.test(value)) {
            setter.accept(value);
            return true;
        }
        for (int v : values) {
            if (!predicate.test(v)) continue;
            setter.accept(v);
            return true;
        }
        return false;
    }

    public static boolean ifVal(@NotNull IntConsumer setter, int value, @NotNull IntPredicate predicate, IntSupplier ... values) {
        if (predicate.test(value)) {
            setter.accept(value);
            return true;
        }
        for (IntSupplier supplier : values) {
            int v = supplier.getAsInt();
            if (!predicate.test(v)) continue;
            setter.accept(v);
            return true;
        }
        return false;
    }

    public static boolean ifVal(@NotNull LongConsumer setter, long value, boolean truthy) {
        if (truthy) {
            setter.accept(value);
            return true;
        }
        return false;
    }

    public static boolean ifVal(@NotNull LongConsumer setter, @NotNull LongSupplier value, boolean truthy) {
        if (truthy) {
            setter.accept(value.getAsLong());
            return true;
        }
        return false;
    }

    public static boolean ifVal(@NotNull LongConsumer setter, long value) {
        return SetterSugar.ifVal(setter, value, EmptySugar::nonEmptyValue);
    }

    public static boolean ifVal(@NotNull LongConsumer setter, long value, @NotNull LongPredicate predicate) {
        if (predicate.test(value)) {
            setter.accept(value);
            return true;
        }
        return false;
    }

    public static boolean ifVal(@NotNull LongConsumer setter, long value, @NotNull LongPredicate predicate, long ... values) {
        if (predicate.test(value)) {
            setter.accept(value);
            return true;
        }
        for (long v : values) {
            if (!predicate.test(v)) continue;
            setter.accept(v);
            return true;
        }
        return false;
    }

    public static boolean ifVal(@NotNull LongConsumer setter, long value, @NotNull LongPredicate predicate, LongSupplier ... values) {
        if (predicate.test(value)) {
            setter.accept(value);
            return true;
        }
        for (LongSupplier supplier : values) {
            long v = supplier.getAsLong();
            if (!predicate.test(v)) continue;
            setter.accept(v);
            return true;
        }
        return false;
    }

    public static boolean ifVal(@NotNull DoubleConsumer setter, double value, boolean truthy) {
        if (truthy) {
            setter.accept(value);
            return true;
        }
        return false;
    }

    public static boolean ifVal(@NotNull DoubleConsumer setter, @NotNull DoubleSupplier value, boolean truthy) {
        if (truthy) {
            setter.accept(value.getAsDouble());
            return true;
        }
        return false;
    }

    public static boolean ifVal(@NotNull DoubleConsumer setter, double value) {
        return SetterSugar.ifVal(setter, value, EmptySugar::nonEmptyValue);
    }

    public static boolean ifVal(@NotNull DoubleConsumer setter, double value, @NotNull DoublePredicate predicate) {
        if (predicate.test(value)) {
            setter.accept(value);
            return true;
        }
        return false;
    }

    public static boolean ifVal(@NotNull DoubleConsumer setter, double value, @NotNull DoublePredicate predicate, double ... values) {
        if (predicate.test(value)) {
            setter.accept(value);
            return true;
        }
        for (double v : values) {
            if (!predicate.test(v)) continue;
            setter.accept(v);
            return true;
        }
        return false;
    }

    public static boolean ifVal(@NotNull DoubleConsumer setter, double value, @NotNull DoublePredicate predicate, DoubleSupplier ... values) {
        if (predicate.test(value)) {
            setter.accept(value);
            return true;
        }
        for (DoubleSupplier supplier : values) {
            double v = supplier.getAsDouble();
            if (!predicate.test(v)) continue;
            setter.accept(v);
            return true;
        }
        return false;
    }
}

