/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.converter;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.i18n.CodeEnum;
import pro.fessional.wings.faceless.converter.WingsConverter;
import pro.fessional.wings.faceless.enums.ConstantEnumUtil;

public class CodeEnumConverter<E extends CodeEnum>
implements WingsConverter<String, E> {
    private final E[] values;
    private final Class<String> srcClz = String.class;
    private final Class<E> tgtClz;

    public CodeEnumConverter(Class<E> toType, E[] values) {
        this.tgtClz = toType;
        this.values = values;
    }

    @NotNull
    public Class<String> sourceType() {
        return this.srcClz;
    }

    @NotNull
    public Class<E> targetType() {
        return this.tgtClz;
    }

    @Nullable
    public E toTarget(String s) {
        return (E)ConstantEnumUtil.codeOrNull((String)s, this.values);
    }

    @Nullable
    public String toSource(E t) {
        return t == null ? null : t.getCode();
    }

    public static <E extends Enum<E>> CodeEnumConverter<E> of(Class<E> toType) {
        return new CodeEnumConverter(toType, (CodeEnum[])((Enum[])toType.getEnumConstants()));
    }

    @SafeVarargs
    public static <E extends CodeEnum> CodeEnumConverter<E> of(Class<E> toType, E ... values) {
        return new CodeEnumConverter(toType, values);
    }
}

