/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.database;

import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;

public class DataSourceContext {
    private DataSource current = null;
    private final LinkedHashMap<String, DataSource> backendMap = new LinkedHashMap();
    private final HashMap<DataSource, String> dataSourceUrls = new HashMap();

    public DataSource getCurrent() {
        return this.current;
    }

    @Contract(value="_->this")
    public DataSourceContext setCurrent(DataSource current) {
        this.current = current;
        return this;
    }

    @Contract(value="->this")
    public DataSourceContext clearBackend() {
        this.backendMap.clear();
        return this;
    }

    @Contract(value="_,_->this")
    public DataSourceContext addBackend(String name, DataSource ds) {
        if (name != null && ds != null) {
            this.backendMap.put(name, ds);
        }
        return this;
    }

    @Contract(value="_->this")
    public DataSourceContext addBackend(Map<String, DataSource> map) {
        if (map != null) {
            this.backendMap.putAll(map);
        }
        return this;
    }

    @NotNull
    public LinkedHashMap<String, DataSource> getBackends() {
        return this.backendMap;
    }

    @NotNull
    public String backendJdbcUrl(String name) {
        return this.cacheJdbcUrl(this.backendMap.get(name));
    }

    @NotNull
    public String cacheJdbcUrl(DataSource ds) {
        return ds == null ? "datasource-is-null" : this.dataSourceUrls.computeIfAbsent(ds, DataSourceContext::extractUrl);
    }

    @NotNull
    public static String extractUrl(DataSource ds) {
        try {
            Object object = DataSourceContext.knownJdbcUrl(ds);
            if (object instanceof String) {
                String url = (String)object;
                return url;
            }
            return (String)JdbcUtils.extractDatabaseMetaData((DataSource)ds, it -> {
                try {
                    return (String)DatabaseMetaData.class.getMethod("getURL", new Class[0]).invoke((Object)it, new Object[0]);
                }
                catch (Exception ex) {
                    throw new MetaDataAccessException("No method named 'getURL' found on DatabaseMetaData instance [" + String.valueOf(it) + "]", (Throwable)ex);
                }
            });
        }
        catch (MetaDataAccessException e) {
            return "unknown";
        }
    }

    public static Object knownJdbcUrl(@NotNull DataSource ds) {
        try {
            for (Method md : ds.getClass().getMethods()) {
                String name = md.getName();
                if ("getJdbcUrl".equals(name)) {
                    return md.invoke((Object)ds, new Object[0]);
                }
                if (!"getUrl".equals(name)) continue;
                return md.invoke((Object)ds, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\ncurrent=").append(this.cacheJdbcUrl(this.current));
        for (Map.Entry<String, DataSource> entry : this.backendMap.entrySet()) {
            sb.append("\n  backend ").append(entry.getKey()).append("=").append(this.cacheJdbcUrl(entry.getValue()));
        }
        return sb.toString();
    }

    public static interface Customizer {
        public boolean customize(DataSourceContext var1);
    }
}

