/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.database.helper;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.TimeZone;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.JdbcUtils;
import pro.fessional.mirana.best.DummyBlock;
import pro.fessional.mirana.time.DateFormatter;
import pro.fessional.mirana.time.DateParser;
import pro.fessional.wings.faceless.database.DataSourceContext;
import pro.fessional.wings.faceless.database.helper.JdbcTemplateHelper;
import pro.fessional.wings.silencer.spring.help.ApplicationContextHelper;

public class DatabaseChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatabaseChecker.class);

    public static boolean isH2(DataSource ds) {
        return DatabaseChecker.extractJdbcUrl(ds).contains(":h2:");
    }

    @NotNull
    public static String extractJdbcUrl(DataSource ds) {
        return (String)JdbcUtils.extractDatabaseMetaData((DataSource)ds, it -> {
            try {
                return (String)DatabaseMetaData.class.getMethod("getURL", new Class[0]).invoke((Object)it, new Object[0]);
            }
            catch (Exception e) {
                log.warn("failed to get jdbcUrl", (Throwable)e);
                return "";
            }
        });
    }

    public static void timezone(DataSource ds) {
        DatabaseChecker.timezone(ds, 5, true);
    }

    public static void timezone(DataSource ds, int off, boolean fail) {
        if (DatabaseChecker.isH2(ds)) {
            log.info("skip timezone check for h2database");
            return;
        }
        String epo = "1979-01-01 00:00:00";
        LocalDateTime ldt = DateParser.parseDateTime((CharSequence)"1979-01-01 00:00:00");
        String sql = "SELECT @@system_time_zone,  @@global.time_zone, @@session.time_zone, NOW(), TIMESTAMPDIFF(SECOND, ?, '1979-01-01 00:00:00') FROM dual";
        JdbcTemplate tmpl = new JdbcTemplate(ds);
        tmpl.query("SELECT @@system_time_zone,  @@global.time_zone, @@session.time_zone, NOW(), TIMESTAMPDIFF(SECOND, ?, '1979-01-01 00:00:00') FROM dual", rs -> {
            LocalDateTime jvNow = LocalDateTime.now();
            StringBuilder sb = new StringBuilder();
            String dbStz = rs.getString(1);
            String dbGtz = rs.getString(2);
            String dbNtz = rs.getString(3);
            LocalDateTime dbNow = DateParser.parseDateTime((CharSequence)rs.getString(4));
            int dbOff = rs.getInt(5);
            int jvOff = (int)(jvNow.toEpochSecond(ZoneOffset.UTC) - dbNow.toEpochSecond(ZoneOffset.UTC));
            sb.append("\ndb-system_time_zone=").append(dbStz);
            sb.append("\ndb-global.time_zone=").append(dbGtz);
            sb.append("\ndb-session.time_zone=").append(dbNtz);
            sb.append("\njvm-default-timezone=").append(ZoneOffset.ofTotalSeconds(TimeZone.getDefault().getRawOffset() / 1000)).append(", ").append(ZoneId.systemDefault().getId());
            sb.append("\ndb-session.now=").append(DateFormatter.full19((LocalDateTime)dbNow));
            sb.append("\njvm-local.now =").append(DateFormatter.full19((LocalDateTime)jvNow));
            sb.append("\ndb-zone-offset =").append(ZoneOffset.ofTotalSeconds(dbOff));
            sb.append("\njvm-zone-offset=").append(ZoneOffset.ofTotalSeconds(jvOff));
            if (Math.abs(jvOff) <= Math.abs(off) && Math.abs(dbOff) <= Math.abs(off)) {
                for (String s : sb.substring(1).split("\n")) {
                    log.info(s);
                }
                return;
            }
            sb.append("\n=== DIFF TIMEZONE ===");
            sb.append("\nthe flowing can make session at same zone. be careful of Daylight Saving Time");
            sb.append("\n- mysql server `default-time-zone = '+08:00'`");
            sb.append("\n- jdbc url `?connectionTimeZone=%2B08:00&forceConnectionTimeZoneToSession=true`");
            sb.append("\n- wings conf `wings.silencer.i18n.zoneid=Asia/Shanghai`");
            sb.append("\n- wings stater.sh `TIME_ZID=Asia/Shanghai`");
            sb.append("\n- java args `-Duser.timezone=Asia/Shanghai`");
            sb.append("\n- java code `TimeZone.setDefault(TimeZone.getTimeZone(\"Asia/Shanghai\"));`");
            sb.append("\n- https://dev.mysql.com/doc/connector-j/8.0/en/connector-j-reference-configuration-properties.html");
            if (fail) {
                throw new IllegalStateException(sb.toString());
            }
            log.error(sb.toString());
        }, new Object[]{Timestamp.valueOf(ldt)});
    }

    public static long version(DataSource ds) {
        JdbcTemplate tmpl = new JdbcTemplate(ds);
        log.info("jdbcurl={}", (Object)DataSourceContext.extractUrl(ds));
        String ver = DatabaseChecker.isH2(ds) ? "H2VERSION()" : "VERSION()";
        tmpl.query("SELECT " + ver + " FROM dual", rs -> log.info("database {}={}", (Object)ver, (Object)rs.getString(1)));
        String reviTable = null;
        try {
            reviTable = ApplicationContextHelper.getProperties((String)"wings.faceless.flywave.ver.schema-version-table");
        }
        catch (Exception e) {
            DummyBlock.ignore((Throwable)e);
        }
        if (StringUtils.isBlank((CharSequence)reviTable)) {
            reviTable = "sys_schema_version";
        }
        String sql = "SELECT MAX(revision) FROM " + JdbcTemplateHelper.safeName(reviTable) + " WHERE apply_dt > '1111-11-11'";
        Long rev = null;
        try {
            rev = (Long)tmpl.query(sql, JdbcTemplateHelper.FirstLongOrNull);
        }
        catch (DataAccessException e) {
            log.info("flywave revision is unknown, for no sys_schema_version");
        }
        log.info("flywave revision={}", (Object)rev);
        return rev == null ? -1L : rev;
    }

    public static boolean existTable(Connection conn, String table) {
        boolean bl;
        block8: {
            String sql = "SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME=? AND TABLE_SCHEMA=SCHEMA()";
            PreparedStatement stm = conn.prepareStatement("SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME=? AND TABLE_SCHEMA=SCHEMA()");
            try {
                stm.setString(1, table);
                ResultSet rs = stm.executeQuery();
                bl = rs.next();
                if (stm == null) break block8;
            }
            catch (Throwable throwable) {
                if (stm != null) {
                    try {
                        stm.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            stm.close();
        }
        return bl;
    }
}

