/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.database.helper;

import java.beans.PropertyDescriptor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import pro.fessional.wings.faceless.converter.WingsConverter;

public class RowMapperHelper {
    public static <E> RowMapper<E> of(Class<E> clz) {
        return new BeanPropertyRowMapper(clz);
    }

    public static <E> RowMapper<E> of(Class<E> clz, WingsConverter<?, ?> ... convertors) {
        return new BeanPropertyRowMapperConverter<E>(clz, Arrays.asList(convertors));
    }

    public static <E> RowMapper<E> of(Class<E> clz, Collection<WingsConverter<?, ?>> convertors) {
        return new BeanPropertyRowMapperConverter<E>(clz, convertors);
    }

    public static class BeanPropertyRowMapperConverter<T>
    extends BeanPropertyRowMapper<T> {
        private final Collection<WingsConverter<?, ?>> convertors;

        public BeanPropertyRowMapperConverter(Class<T> mappedClass, Collection<WingsConverter<?, ?>> convertors) {
            super(mappedClass);
            this.convertors = convertors;
        }

        protected Object getColumnValue(@NotNull ResultSet rs, int index, @NotNull PropertyDescriptor pd) throws SQLException {
            if (!this.convertors.isEmpty()) {
                Object src = rs.getObject(index);
                Class<?> tc = pd.getPropertyType();
                for (WingsConverter<?, ?> conv : this.convertors) {
                    Object tgt = conv.tryToTarget(tc, src);
                    if (tgt == null) continue;
                    return tgt;
                }
            }
            return super.getColumnValue(rs, index, pd);
        }
    }
}

