/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.database.helper;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.function.SingletonSupplier;
import pro.fessional.wings.silencer.spring.help.ApplicationContextHelper;

public class TransactionHelper {
    private static final SingletonSupplier<PlatformTransactionManager> transactionManager = ApplicationContextHelper.getSingletonSupplier(PlatformTransactionManager.class);

    @NotNull
    public static PlatformTransactionManager manager() {
        return (PlatformTransactionManager)transactionManager.obtain();
    }

    @NotNull
    public static TransactionTemplate template() {
        return TransactionHelper.template(null, null, -1);
    }

    @NotNull
    public static TransactionTemplate template(@Nullable Propagation propagation) {
        return TransactionHelper.template(propagation, null, -1);
    }

    @NotNull
    public static TransactionTemplate template(@Nullable Propagation propagation, @Nullable Isolation isolation) {
        return TransactionHelper.template(propagation, isolation, -1);
    }

    @NotNull
    public static TransactionTemplate template(@Nullable Propagation propagation, @Nullable Isolation isolation, int timeoutSeconds) {
        return TransactionHelper.definition(new TransactionTemplate(TransactionHelper.manager()), propagation, isolation, timeoutSeconds);
    }

    @NotNull
    public static TransactionDefinition definition() {
        return TransactionHelper.definition(null, null, -1);
    }

    @NotNull
    public static TransactionDefinition definition(@Nullable Propagation propagation) {
        return TransactionHelper.definition(propagation, null, -1);
    }

    @NotNull
    public static TransactionDefinition definition(@Nullable Propagation propagation, @Nullable Isolation isolation) {
        return TransactionHelper.definition(propagation, isolation, -1);
    }

    @NotNull
    public static TransactionDefinition definition(@Nullable Propagation propagation, @Nullable Isolation isolation, int timeoutSeconds) {
        return TransactionHelper.definition(new DefaultTransactionDefinition(), propagation, isolation, timeoutSeconds);
    }

    @Contract(value="_,_,_,_->param1")
    public static <T extends DefaultTransactionDefinition> T definition(@NotNull T tpl, @Nullable Propagation propagation, @Nullable Isolation isolation, int timeoutSeconds) {
        tpl.setPropagationBehavior(propagation == null ? Propagation.REQUIRED.value() : propagation.value());
        tpl.setIsolationLevel(isolation == null ? Isolation.DEFAULT.value() : isolation.value());
        if (timeoutSeconds > 0) {
            tpl.setTimeout(timeoutSeconds);
        }
        return tpl;
    }

    @NotNull
    public static TransactionStatus begin() {
        return TransactionHelper.begin(null, null, -1);
    }

    @NotNull
    public static TransactionStatus begin(@Nullable Propagation propagation) {
        return TransactionHelper.begin(propagation, null, -1);
    }

    @NotNull
    public static TransactionStatus begin(@Nullable Propagation propagation, @Nullable Isolation isolation) {
        return TransactionHelper.begin(propagation, isolation, -1);
    }

    @NotNull
    public static TransactionStatus begin(@Nullable Propagation propagation, @Nullable Isolation isolation, int timeoutSeconds) {
        TransactionDefinition def = TransactionHelper.definition(propagation, isolation, timeoutSeconds);
        return TransactionHelper.begin(def);
    }

    @NotNull
    public static TransactionStatus begin(@NotNull TransactionDefinition definition) {
        return TransactionHelper.manager().getTransaction(definition);
    }

    public static void rollback(TransactionStatus status) {
        TransactionHelper.manager().rollback(status);
    }

    public static void commit(TransactionStatus status) {
        TransactionHelper.manager().commit(status);
    }
}

