/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.i18n.CodeEnum;
import pro.fessional.mirana.math.AnyIntegerUtil;
import pro.fessional.wings.faceless.enums.ConstantEnum;

public class ConstantEnumUtil {
    public static final Function<String, String> lastColon = s -> {
        int p = s.lastIndexOf(58);
        return p < 0 ? s : s.substring(0, p);
    };
    public static final Pattern JoinerRegex = Pattern.compile("[^a-z0-9_$]+", 2);

    public static boolean in(Enum<?> en, Enum<?> ... ens) {
        for (Enum<?> e : ens) {
            if (en != e) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    @Nullable
    public static <T extends ConstantEnum> T intOrNull(int id, T ... es) {
        for (T e : es) {
            if (id != e.getId()) continue;
            return e;
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    public static <T extends ConstantEnum> T idOrNull(Integer id, T ... es) {
        if (es == null || id == null) {
            return null;
        }
        return (T)ConstantEnumUtil.intOrNull((int)id, es);
    }

    @SafeVarargs
    @NotNull
    public static <T extends ConstantEnum> T intOrThrow(int id, T ... es) {
        ConstantEnum t = ConstantEnumUtil.intOrNull((int)id, es);
        if (t == null) {
            throw new IllegalArgumentException("can not found ConstantEnum by id=" + id);
        }
        return (T)t;
    }

    @SafeVarargs
    @NotNull
    public static <T extends ConstantEnum> T idOrThrow(Integer id, T ... es) {
        ConstantEnum t = ConstantEnumUtil.idOrNull((Integer)id, es);
        if (t == null) {
            throw new IllegalArgumentException("can not found ConstantEnum by id=" + id);
        }
        return (T)t;
    }

    @SafeVarargs
    @NotNull
    public static <T extends ConstantEnum> T intOrHint(int id, String hint, T ... es) {
        ConstantEnum t = ConstantEnumUtil.intOrNull((int)id, es);
        if (t == null) {
            throw new IllegalArgumentException(hint);
        }
        return (T)t;
    }

    @SafeVarargs
    @NotNull
    public static <T extends ConstantEnum> T idOrHint(Integer id, String hint, T ... es) {
        ConstantEnum t = ConstantEnumUtil.idOrNull((Integer)id, es);
        if (t == null) {
            throw new IllegalArgumentException(hint);
        }
        return (T)t;
    }

    @SafeVarargs
    @NotNull
    public static <T extends ConstantEnum> T intOrElse(int id, T el, T ... es) {
        ConstantEnum t = ConstantEnumUtil.intOrNull((int)id, es);
        return (T)(t == null ? el : t);
    }

    @SafeVarargs
    @NotNull
    public static <T extends ConstantEnum> T idOrElse(Integer id, T el, T ... es) {
        ConstantEnum t = ConstantEnumUtil.idOrNull((Integer)id, es);
        return (T)(t == null ? el : t);
    }

    @SafeVarargs
    @Nullable
    public static <T extends Enum<?>> T nameOrNull(String name, T ... es) {
        if (es == null || name == null) {
            return null;
        }
        for (T e : es) {
            if (!((Enum)e).name().equalsIgnoreCase(name)) continue;
            return e;
        }
        return null;
    }

    @SafeVarargs
    @NotNull
    public static <T extends Enum<?>> T nameOrThrow(String name, T ... es) {
        Enum t = ConstantEnumUtil.nameOrNull((String)name, es);
        if (t == null) {
            throw new IllegalArgumentException("can not found ConstantEnum by name=" + name);
        }
        return (T)t;
    }

    @SafeVarargs
    @NotNull
    public static <T extends Enum<?>> T nameOrHint(String name, String hint, T ... es) {
        Enum t = ConstantEnumUtil.nameOrNull((String)name, es);
        if (t == null) {
            throw new IllegalArgumentException(hint);
        }
        return (T)t;
    }

    @SafeVarargs
    @NotNull
    public static <T extends Enum<?>> T nameOrElse(String name, T el, T ... es) {
        Enum t = ConstantEnumUtil.nameOrNull((String)name, es);
        return (T)(t == null ? el : t);
    }

    @SafeVarargs
    @Nullable
    public static <T extends CodeEnum> T codeOrNull(String code, T ... es) {
        if (es == null || code == null) {
            return null;
        }
        for (T e : es) {
            if (!e.getCode().equalsIgnoreCase(code)) continue;
            return e;
        }
        return null;
    }

    @SafeVarargs
    @NotNull
    public static <T extends CodeEnum> T codeOrThrow(String code, T ... es) {
        CodeEnum t = ConstantEnumUtil.codeOrNull((String)code, es);
        if (t == null) {
            throw new IllegalArgumentException("can not found ConstantEnum by code=" + code);
        }
        return (T)t;
    }

    @SafeVarargs
    @NotNull
    public static <T extends CodeEnum> T codeOrElse(String name, T el, T ... es) {
        CodeEnum t = ConstantEnumUtil.codeOrNull((String)name, es);
        return (T)(t == null ? el : t);
    }

    @SafeVarargs
    public static <T extends CodeEnum> boolean codeIn(String code, T ... es) {
        if (code == null || es == null) {
            return false;
        }
        for (T e : es) {
            if (!e.getCode().equalsIgnoreCase(code)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T extends Enum<?>> boolean nameIn(String name, T ... es) {
        if (name == null || es == null) {
            return false;
        }
        for (T e : es) {
            if (!((Enum)e).name().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T extends ConstantEnum> boolean intIn(int id, T ... es) {
        if (es == null) {
            return false;
        }
        for (T e : es) {
            if (id != e.getId()) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T extends ConstantEnum> boolean idIn(Integer id, T ... es) {
        if (id == null || es == null) {
            return false;
        }
        int intId = id;
        for (T e : es) {
            if (intId != e.getId()) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    @NotNull
    public static <T extends ConstantEnum> List<T> groupInfo(T el, T ... es) {
        return ConstantEnumUtil.groupInfo(lastColon, el, es);
    }

    @SafeVarargs
    @NotNull
    public static <T extends ConstantEnum> List<T> groupInfo(Function<String, String> fun, T el, T ... es) {
        if (es == null || el == null) {
            return Collections.emptyList();
        }
        String info = fun.apply(el.getInfo());
        ArrayList<T> list = new ArrayList<T>(es.length);
        for (T e : es) {
            if (!info.equals(fun.apply(e.getInfo()))) continue;
            list.add(e);
        }
        return list;
    }

    @NotNull
    public static <T extends CodeEnum> List<T> codesAuto(T[] es, String codes) {
        if (codes == null || codes.isEmpty()) {
            return Collections.emptyList();
        }
        return ConstantEnumUtil.codes(es, (String[])JoinerRegex.split(codes));
    }

    @NotNull
    public static <T extends CodeEnum> List<T> codes(T[] es, String ... codes) {
        if (codes == null || codes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<CodeEnum> result = new ArrayList<CodeEnum>(codes.length);
        for (String s : codes) {
            CodeEnum c = ConstantEnumUtil.codeOrNull((String)s, es);
            if (c == null) continue;
            result.add(c);
        }
        return result;
    }

    @NotNull
    public static <T extends ConstantEnum> List<T> idsAuto(T[] es, String codes) {
        if (codes == null || codes.isEmpty()) {
            return Collections.emptyList();
        }
        return ConstantEnumUtil.ids(es, (String[])JoinerRegex.split(codes));
    }

    @NotNull
    public static <T extends ConstantEnum> List<T> ids(T[] es, String ... ids) {
        if (ids == null || ids.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ConstantEnum> result = new ArrayList<ConstantEnum>(ids.length);
        for (String s : ids) {
            ConstantEnum c = ConstantEnumUtil.idOrNull((Integer)AnyIntegerUtil.val32((CharSequence)s), es);
            if (c == null) continue;
            result.add(c);
        }
        return result;
    }

    @NotNull
    public static <T extends Enum<?>> List<T> namesAuto(T[] es, String codes) {
        if (codes == null || codes.isEmpty()) {
            return Collections.emptyList();
        }
        return ConstantEnumUtil.names(es, (String[])JoinerRegex.split(codes));
    }

    @NotNull
    public static <T extends Enum<?>> List<T> names(T[] es, String ... names) {
        if (names == null || names.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Enum> result = new ArrayList<Enum>(names.length);
        for (String s : names) {
            Enum c = ConstantEnumUtil.nameOrNull((String)s, es);
            if (c == null) continue;
            result.add(c);
        }
        return result;
    }

    @SafeVarargs
    @NotNull
    public static <T extends ConstantEnum> String joinIds(String delimiter, T ... es) {
        if (es == null || es.length == 0) {
            return "";
        }
        return ConstantEnumUtil.joinIds(delimiter, Arrays.asList(es));
    }

    @NotNull
    public static <T extends ConstantEnum> String joinIds(String delimiter, Collection<T> es) {
        if (es == null || es.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (ConstantEnum e : es) {
            sb.append(delimiter);
            sb.append(e.getId());
        }
        return sb.substring(delimiter.length());
    }

    @SafeVarargs
    @NotNull
    public static <T extends Enum<?>> String joinNames(String delimiter, T ... es) {
        if (es == null || es.length == 0) {
            return "";
        }
        return ConstantEnumUtil.joinNames(delimiter, Arrays.asList(es));
    }

    @NotNull
    public static <T extends Enum<?>> String joinNames(String delimiter, Collection<T> es) {
        if (es == null || es.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Enum e : es) {
            sb.append(delimiter);
            sb.append(e.name());
        }
        return sb.substring(delimiter.length());
    }

    @SafeVarargs
    @NotNull
    public static <T extends CodeEnum> String joinCodes(String delimiter, T ... es) {
        if (es == null || es.length == 0) {
            return "";
        }
        return ConstantEnumUtil.joinCodes(delimiter, Arrays.asList(es));
    }

    @NotNull
    public static <T extends CodeEnum> String joinCodes(String delimiter, Collection<T> es) {
        if (es == null || es.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (CodeEnum e : es) {
            sb.append(delimiter);
            sb.append(e.getCode());
        }
        return sb.substring(delimiter.length());
    }
}

