/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.service.journal.impl;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import pro.fessional.mirana.best.AssertCrud;
import pro.fessional.mirana.time.DateLocaling;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.faceless.database.helper.TransactionHelper;
import pro.fessional.wings.faceless.database.manual.single.modify.commitjournal.CommitJournalModify;
import pro.fessional.wings.faceless.service.journal.JournalService;
import pro.fessional.wings.faceless.service.lightid.BlockIdProvider;
import pro.fessional.wings.faceless.service.lightid.LightIdService;

public class DefaultJournalService
implements JournalService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultJournalService.class);
    public static final String SEQ_JOURNAL = "sys_commit_journal";
    private final TransmittableThreadLocal<JournalService.Journal> context = new TransmittableThreadLocal();
    private final LightIdService lightIdService;
    private final BlockIdProvider blockIdProvider;
    private final CommitJournalModify journalModify;
    private Propagation propagation = Propagation.REQUIRES_NEW;
    private AtomicLong dummyLightId = null;
    private int aliveSecond = 300;

    @NotNull
    @ApiStatus.Internal
    public JournalService.Journal create(long parentId, AtomicLong dummyId, long nowUtc, @NotNull String eventName, @Nullable String loginInfo, @Nullable String targetKey, @Nullable String otherInfo) {
        if (nowUtc <= 0L) {
            nowUtc = ThreadNow.millis();
        }
        long id = dummyId == null ? this.lightIdService.getId(SEQ_JOURNAL, this.blockIdProvider.getBlockId()) : dummyId.getAndIncrement();
        JournalService.Journal journal = new JournalService.Journal(id, DateLocaling.sysLdt((long)nowUtc), parentId, nowUtc, eventName, targetKey == null ? "" : targetKey, loginInfo == null ? "" : loginInfo, otherInfo == null ? "" : otherInfo);
        if (dummyId == null) {
            TransactionHelper.template(this.propagation).executeWithoutResult(ignore -> {
                int rc = this.journalModify.insert(journal);
                AssertCrud.affectEq((int)rc, (int)1, (String)"failed to insert Journal={}", (Object[])new Object[]{journal});
            });
        } else {
            log.warn("dummyLightId id={}", (Object)id);
        }
        return journal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    @ApiStatus.Internal
    public <R> R submit(int aliveSd, AtomicLong dummyId, @NotNull String eventName, @Nullable String loginInfo, @Nullable String targetKey, @Nullable String otherInfo, @NotNull Function<JournalService.Journal, R> commitSet) {
        long now = 0L;
        long pid = 0L;
        JournalService.Journal oldOne = (JournalService.Journal)this.context.get();
        if (oldOne != null) {
            if (aliveSd < 0) {
                return commitSet.apply(oldOne);
            }
            if (aliveSd > 0) {
                now = ThreadNow.millis();
                long live = (now - oldOne.getCommitMs()) / 1000L;
                if (live <= (long)aliveSd) {
                    return commitSet.apply(oldOne);
                }
                pid = oldOne.getId();
                log.warn("renew timeout journal id={}, for alive={}, but live={}", new Object[]{pid, aliveSd, live});
            }
        }
        JournalService.Journal newOne = this.create(pid, dummyId, now, eventName, loginInfo, targetKey, otherInfo);
        this.context.set((Object)newOne);
        try {
            R r = commitSet.apply(newOne);
            return r;
        }
        finally {
            this.context.remove();
            this.elapse(newOne);
        }
    }

    @ApiStatus.Internal
    public long elapse(AtomicLong dummyId, @NotNull JournalService.Journal journal) {
        long cost = ThreadNow.millis() - journal.getCommitMs();
        if (dummyId == null) {
            try {
                this.journalModify.elapse(cost, journal.getId());
            }
            catch (Exception e) {
                log.warn("fail to update elapse=" + cost + ", id=" + journal.getId(), (Throwable)e);
            }
        }
        return cost;
    }

    @Override
    public long elapse(@NotNull JournalService.Journal journal) {
        return this.elapse(this.dummyLightId, journal);
    }

    @Override
    @NotNull
    public JournalService.Journal create(long parentId, @NotNull String eventName, @Nullable String loginInfo, @Nullable String targetKey, @Nullable String otherInfo) {
        return this.create(parentId, this.dummyLightId, 0L, eventName, loginInfo, targetKey, otherInfo);
    }

    @Override
    @NotNull
    public <R> R submit(@NotNull String eventName, @Nullable String loginInfo, @Nullable String targetKey, @Nullable String otherInfo, @NotNull Function<JournalService.Journal, R> commitSet) {
        return this.submit(this.aliveSecond, this.dummyLightId, eventName, loginInfo, targetKey, otherInfo, commitSet);
    }

    @Generated
    public DefaultJournalService(LightIdService lightIdService, BlockIdProvider blockIdProvider, CommitJournalModify journalModify) {
        this.lightIdService = lightIdService;
        this.blockIdProvider = blockIdProvider;
        this.journalModify = journalModify;
    }

    @Generated
    public void setPropagation(Propagation propagation) {
        this.propagation = propagation;
    }

    @Generated
    public void setDummyLightId(AtomicLong dummyLightId) {
        this.dummyLightId = dummyLightId;
    }

    @Generated
    public void setAliveSecond(int aliveSecond) {
        this.aliveSecond = aliveSecond;
    }
}

