/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.service.lightid.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import pro.fessional.mirana.id.LightIdProvider;
import pro.fessional.wings.faceless.database.manual.single.modify.lightsequence.LightSequenceModify;
import pro.fessional.wings.faceless.database.manual.single.select.lightsequence.LightSequenceSelect;
import pro.fessional.wings.faceless.database.sharding.WriteRouteOnly;
import pro.fessional.wings.faceless.spring.prop.LightIdInsertProp;

@Transactional(propagation=Propagation.REQUIRES_NEW)
public class LightIdMysqlLoader
implements LightIdProvider.Loader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LightIdMysqlLoader.class);
    private final LightSequenceSelect select;
    private final LightSequenceModify modify;
    private final LightIdInsertProp properties;

    @WriteRouteOnly
    @NotNull
    public LightIdProvider.Segment require(@NotNull String name, int block, int count, boolean exact) {
        long newNext;
        LightSequenceSelect.NextStep one = this.select.selectOneLock(block, name);
        if (one == null) {
            if (this.properties.isAuto()) {
                log.warn("not found and insert name={}, block={}", (Object)name, (Object)block);
                LightSequenceModify.SysLightSequence po = new LightSequenceModify.SysLightSequence();
                po.setSeqName(name);
                po.setBlockId(block);
                po.setNextVal(this.properties.getNext());
                po.setStepVal(this.properties.getStep());
                po.setComments("Auto insert if Not found");
                int cnt = this.modify.insert(po);
                if (cnt != 1) {
                    throw new NoSuchElementException("not found and failed to insert. name=" + name + ", block=" + block);
                }
                log.warn("inserted and retry, name={}, block={}", (Object)name, (Object)block);
                one = new LightSequenceSelect.NextStep(this.properties.getNext(), this.properties.getStep());
            } else {
                throw new NoSuchElementException("not existed name=" + name + ", block=" + block);
            }
        }
        long curNext = one.getNextVal();
        if (exact) {
            newNext = curNext + (long)count;
        } else {
            long page = (count - 1) / one.getStepVal() + 1;
            newNext = curNext + (long)one.getStepVal() * page;
        }
        int upd = this.modify.updateNextVal(newNext, block, name, one.getOldNext());
        if (upd != 1) {
            throw new IllegalStateException("failed to require, name=" + name + ", block=" + block);
        }
        return new LightIdProvider.Segment(name, block, curNext, newNext - 1L);
    }

    @WriteRouteOnly
    @NotNull
    public List<LightIdProvider.Segment> preload(int block) {
        List<LightSequenceSelect.NameNextStep> all = this.select.selectAllLock(block);
        int[] updates = this.modify.updateNextPlusStep(all, block);
        ArrayList<LightIdProvider.Segment> result = new ArrayList<LightIdProvider.Segment>(all.size());
        StringBuilder err = new StringBuilder();
        int index = 0;
        for (LightSequenceSelect.NameNextStep e : all) {
            if (updates[index++] != 1) {
                err.append("name=").append(e.getSeqName()).append(",block=").append(block).append("\n");
                continue;
            }
            result.add(new LightIdProvider.Segment(e.getSeqName(), block, e.getNextVal(), e.getNextVal() + (long)e.getStepVal() - 1L));
        }
        if (!err.isEmpty()) {
            throw new IllegalStateException("failed to preload, error=" + String.valueOf(err));
        }
        return result;
    }

    @Generated
    public LightIdMysqlLoader(LightSequenceSelect select, LightSequenceModify modify, LightIdInsertProp properties) {
        this.select = select;
        this.modify = modify;
        this.properties = properties;
    }
}

