/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.faceless.service.wini18n.impl;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import pro.fessional.mirana.i18n.LocaleResolver;
import pro.fessional.wings.faceless.database.helper.JdbcTemplateHelper;
import pro.fessional.wings.faceless.service.wini18n.StandardI18nService;
import pro.fessional.wings.silencer.message.MessageSourceHelper;

public class StandardI18nServiceJdbc
implements StandardI18nService {
    private final JdbcTemplate jdbcTemplate;
    private final ConcurrentHashMap<String, String> cache = new ConcurrentHashMap();
    private static final RowMapper<Po> poMapper = (rs, rowNum) -> {
        Po po = new Po();
        po.base = rs.getString("base");
        po.kind = rs.getString("kind");
        po.ukey = rs.getString("ukey");
        po.lang = rs.getString("lang");
        po.hint = rs.getString("hint");
        return po;
    };

    @Override
    public int reloadAll() {
        List pos = this.jdbcTemplate.query("SELECT base, kind, ukey, lang, hint FROM sys_standard_i18n", poMapper);
        return this.cache(pos);
    }

    @Override
    public int reloadBase(String base) {
        List pos = this.jdbcTemplate.query("SELECT base, kind, ukey, lang, hint FROM sys_standard_i18n WHERE base=?", poMapper, new Object[]{base});
        return this.cache(pos);
    }

    @Override
    @Nullable
    public String load(String base, String kind, String ukey, Locale lang) {
        String lan = lang.getLanguage() + "_" + lang.getCountry();
        String key = this.key(base, kind, ukey, lan);
        return this.cache.computeIfAbsent(key, s -> {
            String hint;
            String txt = (String)this.jdbcTemplate.query("SELECT hint FROM sys_standard_i18n WHERE base=? AND kind=? AND ukey=? AND lang=?", JdbcTemplateHelper.FirstStringOrNull, new Object[]{base, kind, ukey, lan});
            String string = hint = txt == null ? "" : txt;
            if (!hint.isEmpty()) {
                MessageSourceHelper.Combine.addMessage(this.code(base, kind, ukey), lang, hint);
            }
            return hint;
        });
    }

    private int cache(List<Po> pos) {
        for (Po po : pos) {
            String key = this.key(po.base, po.kind, po.ukey, po.lang);
            String txt = po.hint;
            this.cache.put(key, txt);
            String code = this.code(po.base, po.kind, po.ukey);
            Locale lang = LocaleResolver.locale((String)po.lang);
            MessageSourceHelper.Combine.addMessage(code, lang, txt);
        }
        return pos.size();
    }

    private String code(String base, String kind, String ukey) {
        return base + "." + kind + "." + ukey;
    }

    private String key(String base, String kind, String ukey, String lang) {
        return base + "." + kind + "." + ukey + "@" + lang;
    }

    @Generated
    public StandardI18nServiceJdbc(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private static class Po {
        private String base = "";
        private String kind = "";
        private String ukey = "";
        private String lang = "";
        private String hint = "";

        private Po() {
        }
    }
}

