/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.watch;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.annotation.Order;
import pro.fessional.mirana.time.StopWatch;
import pro.fessional.wings.silencer.watch.Watches;
import pro.fessional.wings.silencer.watch.Watching;

@Aspect
@Order(value=-10000000)
public class WatchingAround {
    private long thresholdMillis = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(watching)", argNames="joinPoint, watching")
    public Object watchAround(ProceedingJoinPoint joinPoint, Watching watching) throws Throwable {
        Object object;
        long maxm = watching.threshold();
        if (maxm == 0L) {
            maxm = this.thresholdMillis;
        }
        if (maxm < 0L) {
            return joinPoint.proceed();
        }
        Object name = watching.value();
        if (name == null || ((String)name).isEmpty()) {
            Signature sn = joinPoint.getSignature();
            name = sn.getDeclaringType().getSimpleName() + "#" + sn.getName();
        }
        StopWatch.Watch watch = Watches.acquire((String)name);
        try {
            object = joinPoint.proceed();
        }
        catch (Throwable throwable) {
            watch.close();
            Watches.release(true, watch.getElapseMs() < this.thresholdMillis ? null : "WatchingAround");
            throw throwable;
        }
        watch.close();
        Watches.release(true, watch.getElapseMs() < this.thresholdMillis ? null : "WatchingAround");
        return object;
    }

    public long getThresholdMillis() {
        return this.thresholdMillis;
    }

    public void setThresholdMillis(long thresholdMillis) {
        this.thresholdMillis = thresholdMillis;
    }
}

