/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.encrypt;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pro.fessional.mirana.bits.Aes256;
import pro.fessional.wings.silencer.encrypt.SecretProvider;

public class Aes256Provider {
    @NotNull
    public static Aes256 system() {
        return Aes256Provider.get("system", true);
    }

    @NotNull
    public static Aes256 ticket() {
        return Aes256Provider.get("ticket", true);
    }

    @NotNull
    public static Aes256 cookie() {
        return Aes256Provider.get("cookie", true);
    }

    @NotNull
    public static Aes256 config() {
        return Aes256Provider.get("config", true);
    }

    @Contract(value="_,true->!null")
    public static Aes256 get(String name, boolean nonnull) {
        String key = SecretProvider.get(name, false);
        if (key == null) {
            if (nonnull) {
                throw new IllegalStateException("must init before using");
            }
            return null;
        }
        return Aes256.of((String)key);
    }
}

