/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.encrypt;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.code.RandCode;

public class SecretProvider {
    public static final int Length = 32;
    public static final String System = "system";
    public static final String Ticket = "ticket";
    public static final String Cookie = "cookie";
    public static final String Config = "config";
    protected static final ConcurrentHashMap<String, String> Secrets = new ConcurrentHashMap();

    protected SecretProvider(@NotNull Map<String, String> keys) {
        Secrets.putAll(keys);
    }

    @NotNull
    public static String strong(int len) {
        return RandCode.strong((int)len);
    }

    @NotNull
    public static String human(int len) {
        return RandCode.human((int)len);
    }

    @NotNull
    public static String get(String name) {
        return SecretProvider.get(name, true);
    }

    @Contract(value="_,true->!null")
    public static String get(String name, boolean computeIfAbsent) {
        if (name == null || name.isEmpty()) {
            name = System;
        }
        if (computeIfAbsent) {
            return Secrets.computeIfAbsent(name, k -> RandCode.strong((int)32));
        }
        return Secrets.get(name);
    }

    @Nullable
    public String tryGet(String name) {
        return SecretProvider.get(name, false);
    }

    public static void put(@NotNull String name, @NotNull String secret, boolean replace) {
        if (replace) {
            Secrets.put(name, secret);
        } else {
            Secrets.putIfAbsent(name, secret);
        }
    }
}

