/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.spring.help;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class CommonPropHelper {
    public static final String DisabledValue = "-";
    public static final String MaskingValue = "*****";

    public static boolean notValue(String str) {
        return str == null || str.isEmpty() || DisabledValue.equals(str) || MaskingValue.equals(str);
    }

    public static boolean hasValue(String value) {
        return !CommonPropHelper.notValue(value);
    }

    @NotNull
    public static LinkedHashSet<String> onlyValue(Collection<String> values) {
        if (values == null) {
            values = Collections.emptyList();
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>(values);
        set.removeIf(CommonPropHelper::notValue);
        return set;
    }

    @NotNull
    public static LinkedHashMap<String, String> onlyValue(Map<String, String> values) {
        if (values == null) {
            values = Collections.emptyMap();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> en : values.entrySet()) {
            String value = en.getValue();
            if (!CommonPropHelper.hasValue(value)) continue;
            map.put(en.getKey(), value);
        }
        return map;
    }

    @NotNull
    public static String toString(@NotNull Resource resource) {
        if (resource instanceof ClassPathResource) {
            String path = ((ClassPathResource)resource).getPath();
            return "classpath:" + path;
        }
        return resource.getURL().toExternalForm();
    }

    public static void mergeNotValue(@NotNull Map<String, String> thiz, @Nullable Map<String, String> that) {
        if (that == null || that.isEmpty()) {
            return;
        }
        if (thiz.isEmpty()) {
            thiz.putAll(that);
        } else {
            for (Map.Entry<String, String> en : thiz.entrySet()) {
                String v = en.getValue();
                if (!CommonPropHelper.notValue(v)) continue;
                String tv = that.get(en.getKey());
                en.setValue(tv);
            }
        }
    }

    @Contract(value="_,true->!null")
    public static String[] arrayOrNull(String str, boolean nonnull) {
        String[] arr = StringUtils.commaDelimitedListToStringArray((String)str);
        if (nonnull) {
            return arr;
        }
        return arr.length == 0 ? null : arr;
    }
}

