/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.tweak;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.slf4j.spi.MDCAdapter;

public class TtlMDCAdapter
implements MDCAdapter {
    private final ThreadLocal<Map<String, String>> valueMap = TransmittableThreadLocal.withInitial(HashMap::new);
    private final ThreadLocal<Map<String, String>> cacheMap = TransmittableThreadLocal.withInitial(Collections::emptyMap);
    private final ThreadLocal<Map<String, Deque<String>>> dequeMap = TransmittableThreadLocal.withInitial(HashMap::new);

    public void put(String key, String val) {
        if (key == null) {
            return;
        }
        this.valueMap.get().put(key, val);
        this.clearCache();
    }

    public String get(String key) {
        return key == null ? null : this.valueMap.get().get(key);
    }

    public void remove(String key) {
        if (key == null) {
            return;
        }
        this.valueMap.get().remove(key);
        this.clearCache();
    }

    public void clear() {
        this.valueMap.remove();
        this.cacheMap.remove();
    }

    private void clearCache() {
        this.cacheMap.set(Collections.emptyMap());
    }

    @NotNull
    public Map<String, String> getReadOnlyMap() {
        Map<String, String> map = this.cacheMap.get();
        if (map == Collections.EMPTY_MAP) {
            map = Map.copyOf(this.valueMap.get());
            this.cacheMap.set(map);
        }
        return map;
    }

    public Map<String, String> getCopyOfContextMap() {
        return new HashMap<String, String>(this.getReadOnlyMap());
    }

    public Set<String> getKeys() {
        return this.getReadOnlyMap().keySet();
    }

    public void setContextMap(Map<String, String> ctx) {
        HashMap map = ctx == null ? new HashMap() : new HashMap<String, String>(ctx);
        this.valueMap.set(map);
        this.clearCache();
    }

    public void pushByKey(String key, String value) {
        if (key != null) {
            this.dequeMap.get().computeIfAbsent(key, k -> new ArrayDeque()).push(value);
        }
    }

    public String popByKey(String key) {
        if (key == null) {
            return null;
        }
        Deque<String> deque = this.dequeMap.get().get(key);
        return deque == null ? null : deque.pop();
    }

    public Deque<String> getCopyOfDequeByKey(String key) {
        if (key == null) {
            return null;
        }
        Deque<String> deque = this.dequeMap.get().get(key);
        return deque == null ? null : new ArrayDeque<String>(deque);
    }

    public void clearDequeByKey(String key) {
        if (key == null) {
            return;
        }
        Deque<String> deque = this.dequeMap.get().get(key);
        if (deque != null) {
            deque.clear();
        }
    }
}

