/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class Splitter {
    @NotNull
    public static List<String> list(@NotNull String sep, String str) {
        if (str == null || str.isEmpty()) {
            return Collections.emptyList();
        }
        return com.google.common.base.Splitter.on((String)sep).splitToList((CharSequence)str);
    }

    @NotNull
    public static List<String> list(@NotNull String sep, String str, int max) {
        if (str == null || str.isEmpty()) {
            return Collections.emptyList();
        }
        return com.google.common.base.Splitter.on((String)sep).limit(max).splitToList((CharSequence)str);
    }

    @NotNull
    public static <T> List<T> list(@NotNull String sep, String str, @NotNull Function<String, T> fun) {
        if (str == null || str.isEmpty()) {
            return Collections.emptyList();
        }
        Iterable iter = com.google.common.base.Splitter.on((String)sep).split((CharSequence)str);
        ArrayList<T> result = new ArrayList<T>();
        for (String s : iter) {
            result.add(fun.apply(s));
        }
        return Collections.unmodifiableList(result);
    }

    @NotNull
    public static <T> List<T> list(@NotNull String sep, String str, int max, @NotNull Function<String, T> fun) {
        if (str == null || str.isEmpty()) {
            return Collections.emptyList();
        }
        Iterable iter = com.google.common.base.Splitter.on((String)sep).limit(max).split((CharSequence)str);
        ArrayList<T> result = new ArrayList<T>();
        for (String s : iter) {
            result.add(fun.apply(s));
        }
        return Collections.unmodifiableList(result);
    }

    public static int count(@NotNull String sep, String str) {
        if (str == null || str.isEmpty()) {
            return 0;
        }
        return StringUtils.countMatches((CharSequence)str, (CharSequence)sep) + 1;
    }
}

