/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.spring.bean;

import ch.qos.logback.classic.LoggerContext;
import java.time.Clock;
import java.time.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.LoggerFactory;
import org.slf4j.TweakMDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggerGroups;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.context.annotation.Configuration;
import pro.fessional.mirana.evil.ThreadLocalAttention;
import pro.fessional.mirana.pain.CodeException;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.silencer.spring.prop.SilencerTweakProp;
import pro.fessional.wings.silencer.tweak.TtlMDCAdapter;
import pro.fessional.wings.silencer.tweak.TweakLogger;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class SilencerTweakConfiguration {
    private static final Log log = LogFactory.getLog(SilencerTweakConfiguration.class);

    @Configuration(proxyBeanMethods=false)
    @ConditionalWingsEnabled(abs="wings.enabled.silencer.tweak-stack")
    public static class StackWired {
        @Autowired
        public void auto(SilencerTweakProp prop) throws ThreadLocalAttention {
            log.info((Object)("SilencerCurse spring-auto initCodeExceptionTweak with TransmittableThreadLocal, stack=" + prop.isCodeStack()));
            CodeException.TweakStack.initDefault(prop::isCodeStack);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalWingsEnabled(abs="wings.enabled.silencer.tweak-logback")
    public static class LogbackWired {
        @Autowired
        public void auto(SilencerTweakProp prop, LoggingSystem loggingSystem, LoggerGroups loggerGroups, @Value(value="${debug:false}") boolean debug, @Value(value="${trace:false}") boolean trace) {
            log.info((Object)"SilencerCurse spring-auto autowireLogbackTweak, init TtlMDC");
            TweakMDC.adapt(new TtlMDCAdapter());
            if (prop.isMdcThreshold()) {
                log.info((Object)"SilencerCurse spring-conf autowireLogbackTweak WingsMdcThresholdFilter");
                LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
                lc.getTurboFilterList().add(0, (Object)TweakLogger.MdcThresholdFilter);
            }
            Object core = debug ? LogLevel.DEBUG : (trace ? LogLevel.TRACE : null);
            log.info((Object)("SilencerCurse spring-conf autowireLogbackTweak TweakLogger, coreLevel=" + String.valueOf(core)));
            TweakLogger.initGlobal(loggingSystem, loggerGroups, core);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalWingsEnabled(abs="wings.enabled.silencer.tweak-clock")
    public static class ClockWired {
        @Autowired
        public void auto(SilencerTweakProp prop) throws ThreadLocalAttention {
            long ms = prop.getClockOffset();
            log.info((Object)("SilencerCurse spring-auto initThreadClockTweak with TransmittableThreadLocal, offset=" + ms));
            Duration dr = Duration.ofMillis(ms);
            if (!dr.isZero()) {
                Clock clock = (Clock)ThreadNow.TweakClock.current(true);
                ThreadNow.TweakClock.initDefault((Object)Clock.offset(clock, dr));
            }
        }
    }
}

