/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.spring.bean;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.filter.Filter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.info.GitProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pro.fessional.wings.silencer.enhance.ThisLazyPostProcessor;
import pro.fessional.wings.silencer.modulate.RuntimeMode;
import pro.fessional.wings.silencer.runner.ApplicationInspectRunner;
import pro.fessional.wings.silencer.runner.ApplicationReadyEventRunner;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.silencer.spring.help.ApplicationContextHelper;
import pro.fessional.wings.silencer.spring.prop.SilencerAutoLogProp;
import pro.fessional.wings.silencer.spring.prop.SilencerRuntimeProp;
import pro.fessional.wings.silencer.support.InspectHelper;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class SilencerCurseConfiguration {
    private static final Log log = LogFactory.getLog(SilencerCurseConfiguration.class);
    public static final int OrderMuteConsoleRunner = -2000000;

    @Bean
    @ConditionalWingsEnabled(abs="wings.enabled.silencer.audit-prop", value=false)
    public ApplicationInspectRunner auditPropRunner() {
        log.info((Object)"SilencerCurse spring-bean auditPropRunner");
        return new ApplicationInspectRunner(-30000000, ignored -> {
            Map map = ApplicationContextHelper.listPropertySource();
            LinkedHashMap<String, List> key = new LinkedHashMap<String, List>();
            for (Map.Entry en : map.entrySet()) {
                for (String k : (List)en.getValue()) {
                    key.computeIfAbsent(k, ignoreK -> new ArrayList()).add((String)en.getKey());
                }
            }
            for (Map.Entry en : key.entrySet()) {
                String k;
                List vs = (List)en.getValue();
                k = (String)en.getKey();
                log.info((Object)(k + "=" + ApplicationContextHelper.getProperties((String)k)));
                int c = 0;
                for (String v : vs) {
                    if (c++ == 0) {
                        log.info((Object)("+ " + v));
                        continue;
                    }
                    log.info((Object)("- " + v));
                }
            }
        });
    }

    @Bean
    @ConditionalWingsEnabled
    public ApplicationInspectRunner infoGitJvmRunner(ApplicationContext context) {
        log.info((Object)"Silencer spring-runs infoGitJvmRunner");
        return new ApplicationInspectRunner(-90000000, args -> {
            GitProperties git = (GitProperties)context.getBean(GitProperties.class);
            log.info((Object)("git-branch=" + InspectHelper.branch((GitProperties)git)));
            log.info((Object)("git-id=" + InspectHelper.commitId((GitProperties)git)));
            log.info((Object)("git-time=" + InspectHelper.commitDateTime((GitProperties)git)));
            log.info((Object)("git-build=" + InspectHelper.buildDateTime((GitProperties)git)));
            log.info((Object)("git-version=" + InspectHelper.buildVersion((GitProperties)git)));
            log.info((Object)("git-message=" + InspectHelper.commitMessage((GitProperties)git)));
            log.info((Object)("jvm-name=" + InspectHelper.jvmName()));
            log.info((Object)("jvm-version=" + InspectHelper.jvmVersion()));
            log.info((Object)("jvm-vendor=" + InspectHelper.jvmVendor()));
            log.info((Object)("app-ApiMode=" + String.valueOf((Object)RuntimeMode.getApiMode())));
            log.info((Object)("app-RunMode=" + String.valueOf((Object)RuntimeMode.getRunMode())));
        });
    }

    @Bean
    @ConditionalWingsEnabled(abs="wings.enabled.silencer.mute-console")
    @ConditionalOnClass(value={ConsoleAppender.class})
    public ApplicationReadyEventRunner muteConsoleRunner(SilencerAutoLogProp autoLog) {
        log.info((Object)"SilencerCurse spring-runs muteConsoleRunner");
        return new ApplicationReadyEventRunner(-2000000, ignored -> {
            Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
            Set<String> targets = autoLog.getTarget();
            Set<String> exists = autoLog.getExists();
            boolean skip = true;
            HashSet<Appender> appenders = new HashSet<Appender>();
            Iterator iter = root.iteratorForAppenders();
            while (iter.hasNext()) {
                Appender next = (Appender)iter.next();
                String name = next.getName();
                if (targets.contains(name)) {
                    appenders.add(next);
                    log.info((Object)("find target appender name=" + name));
                    continue;
                }
                if (exists.contains(name)) {
                    log.info((Object)("find condition appender name=" + name));
                    skip = false;
                    continue;
                }
                log.info((Object)("find others appender name=" + name));
            }
            if (skip || appenders.isEmpty()) {
                log.info((Object)"skip auto-log appender");
                return;
            }
            String level = autoLog.getLevel();
            log.info((Object)"================= Silencer =================");
            log.info((Object)("Auto Switch the following Appender Level to " + level));
            for (Appender appender : appenders) {
                log.info((Object)("- " + appender.getName() + " : " + appender.getClass().getName()));
            }
            ThresholdFilter tft = new ThresholdFilter();
            tft.setLevel(level);
            for (Appender appender : appenders) {
                appender.addFilter((Filter)tft);
            }
            log.info((Object)"================= Silencer =================");
            tft.start();
        });
    }

    @Bean
    @ConditionalWingsEnabled
    public static BeanPostProcessor thisLazyAwarePostProcessor() {
        log.info((Object)"Silencer spring-auto thisLazyAwarePostProcessor");
        return new ThisLazyPostProcessor();
    }

    @Bean
    @ConditionalWingsEnabled
    public RuntimeMode runtimeMode(SilencerRuntimeProp prop) {
        log.info((Object)("Silencer spring-auto RuntimeMode, runMode=" + String.valueOf((Object)prop.getRunMode()) + ", apiMode=" + String.valueOf((Object)prop.getApiMode())));
        return new RuntimeMode(this, prop.getRunMode(), prop.getApiMode()){};
    }
}

