/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.tweak;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggerConfiguration;
import org.springframework.boot.logging.LoggerGroup;
import org.springframework.boot.logging.LoggerGroups;
import org.springframework.boot.logging.LoggingSystem;

public class TweakLogger {
    private static LoggingSystem loggingSystem = null;
    private static LoggerGroups loggerGroups = null;
    private static LogLevel CoreLevel = null;
    private static Set<String> LazyCoreLevel = null;
    private static final ConcurrentHashMap<String, LogLevel> GlobalLevel = new ConcurrentHashMap();
    public static final String LevelKey = "WINGS_DEBUG_LEVEL";
    public static final String LoggerKey = "WINGS_DEBUG_LOGGER";
    public static final TurboFilter MdcThresholdFilter = new TurboFilter(){

        public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
            Level lvl = Level.toLevel((String)MDC.get((String)TweakLogger.LevelKey), null);
            if (lvl != null) {
                FilterReply rpl = level.isGreaterOrEqual(lvl) ? FilterReply.ACCEPT : FilterReply.DENY;
                String lgn = MDC.get((String)TweakLogger.LoggerKey);
                if (lgn == null || lgn.isEmpty() || "ROOT".equalsIgnoreCase(lgn)) {
                    return rpl;
                }
                String nm = logger.getName();
                if (nm.contains(lgn) || lgn.contains(nm)) {
                    return rpl;
                }
            }
            return FilterReply.NEUTRAL;
        }
    };

    public static void initGlobal(LoggingSystem system, LoggerGroups groups, LogLevel core) {
        loggingSystem = system;
        loggerGroups = groups;
        if (core != null) {
            CoreLevel = core;
            if (LazyCoreLevel != null) {
                for (String name : LazyCoreLevel) {
                    TweakLogger.tweakGlobal(name, core, false);
                }
            }
        }
        if (LazyCoreLevel != null) {
            LazyCoreLevel.clear();
            LazyCoreLevel = null;
        }
    }

    public static LogLevel getCoreLevel() {
        return CoreLevel;
    }

    public static void asCoreLevel(@NotNull String name) {
        if (loggingSystem != null) {
            if (CoreLevel != null) {
                TweakLogger.tweakGlobal(name, CoreLevel, false);
            }
        } else {
            if (LazyCoreLevel == null) {
                LazyCoreLevel = new HashSet<String>();
            }
            LazyCoreLevel.add(name);
        }
    }

    public static void tweakGlobal(@Nullable LogLevel level) {
        TweakLogger.tweakGlobal("ROOT", level);
    }

    public static void tweakGlobal(@NotNull String name, @Nullable LogLevel level) {
        TweakLogger.tweakGlobal(name, level, true);
    }

    public static void tweakGlobal(@NotNull String name, @Nullable LogLevel level, boolean cache) {
        LoggerGroup group;
        if (loggingSystem == null) {
            throw new IllegalStateException("must initLogging first");
        }
        if (level == null) {
            level = GlobalLevel.get(name);
        }
        if (loggerGroups != null && (group = loggerGroups.get(name)) != null) {
            GlobalLevel.put(name, group.getConfiguredLevel());
            group.configureLogLevel(level, (arg_0, arg_1) -> ((LoggingSystem)loggingSystem).setLogLevel(arg_0, arg_1));
            return;
        }
        if (cache) {
            LoggerConfiguration configuration = loggingSystem.getLoggerConfiguration(name);
            GlobalLevel.put(name, configuration.getEffectiveLevel());
        }
        loggingSystem.setLogLevel(name, level);
    }

    public static void resetGlobal(@NotNull String name) {
        TweakLogger.tweakGlobal(name, null);
    }

    public static void resetGlobal() {
        HashSet<String> keys = new HashSet<String>();
        Enumeration<String> it = GlobalLevel.keys();
        while (it.hasMoreElements()) {
            keys.add(it.nextElement());
        }
        for (String key : keys) {
            TweakLogger.tweakGlobal(key, null);
        }
    }

    @NotNull
    public static LogLevel globalLevel(@NotNull String name) {
        if (loggingSystem == null) {
            throw new IllegalStateException("must initLogging first");
        }
        return GlobalLevel.computeIfAbsent(name, k -> {
            LoggerGroup group;
            if (loggerGroups != null && (group = loggerGroups.get(name)) != null) {
                return group.getConfiguredLevel();
            }
            LoggerConfiguration configuration = loggingSystem.getLoggerConfiguration(name);
            return configuration.getEffectiveLevel();
        });
    }

    public static void tweakThread(@Nullable LogLevel level) {
        TweakLogger.tweakThread("ROOT", level);
    }

    public static void tweakThread(@NotNull String name, @Nullable LogLevel level) {
        if (level == null || level == LogLevel.OFF) {
            TweakLogger.resetThread();
            return;
        }
        String lvl = level == LogLevel.FATAL ? "ERROR" : level.name();
        MDC.put((String)LevelKey, (String)lvl);
        if (!name.isEmpty()) {
            MDC.put((String)LoggerKey, (String)name);
        }
    }

    public static void resetThread() {
        MDC.remove((String)LevelKey);
        MDC.remove((String)LoggerKey);
    }

    @Nullable
    public static LogLevel threadLevel() {
        String lvl = MDC.get((String)LevelKey);
        if (lvl == null || lvl.isEmpty()) {
            return null;
        }
        for (LogLevel v : LogLevel.values()) {
            if (!v.name().equalsIgnoreCase(lvl)) continue;
            return v;
        }
        return null;
    }

    @NotNull
    public static LogLevel currentLevel(@NotNull String name) {
        LogLevel tvl = TweakLogger.threadLevel();
        if (tvl != null) {
            return tvl;
        }
        LogLevel gvl = TweakLogger.globalLevel(name);
        if (CoreLevel != null && gvl.ordinal() > CoreLevel.ordinal()) {
            return CoreLevel;
        }
        return gvl;
    }
}

