/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.watch;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.fessional.mirana.best.DummyBlock;
import pro.fessional.mirana.time.StopWatch;

public class Watches {
    public static final Logger log = LoggerFactory.getLogger(Watches.class);
    private static final ThreadLocal<StopWatch> StopWatches = new TransmittableThreadLocal();
    private static volatile BiConsumer<String, StopWatch> WatchHandler = (token, watch) -> log.warn("Watching {} {}", token, watch);

    @NotNull
    public static StopWatch acquire() {
        StopWatch watch = StopWatches.get();
        if (watch == null) {
            watch = new StopWatch();
            StopWatches.set(watch);
        }
        return watch;
    }

    @NotNull
    public static StopWatch.Watch acquire(String name) {
        return Watches.acquire().start(name);
    }

    @Nullable
    public static StopWatch current() {
        return StopWatches.get();
    }

    @Nullable
    public static StopWatch.Watch current(String name) {
        StopWatch watch = StopWatches.get();
        return watch == null ? null : watch.start(name);
    }

    public static boolean release(boolean clean) {
        return Watches.release(clean, null, WatchHandler);
    }

    public static boolean release(boolean clean, @Nullable String token) {
        return Watches.release(clean, token, WatchHandler);
    }

    public static boolean release(boolean clean, @Nullable String token, @NotNull BiConsumer<String, StopWatch> handle) {
        StopWatch watch = StopWatches.get();
        if (watch == null || watch.isRunning()) {
            return false;
        }
        StopWatches.remove();
        if (token != null) {
            try {
                handle.accept(token, watch);
            }
            catch (Exception e) {
                DummyBlock.ignore((Throwable)e);
            }
        }
        if (clean) {
            watch.clear();
        }
        return true;
    }

    public static void setWatchHandler(BiConsumer<String, StopWatch> handler) {
        WatchHandler = handler;
    }
}

