/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.modulate;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.fessional.mirana.cond.StaticFlag;
import pro.fessional.wings.silencer.modulate.ApiMode;
import pro.fessional.wings.silencer.modulate.RunMode;

public class RuntimeMode {
    @NotNull
    private static volatile RunMode runMode = RunMode.Nothing;
    @NotNull
    private static volatile ApiMode apiMode = ApiMode.Nothing;
    private static final ConcurrentHashMap<String, Boolean> runVote = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Boolean> apiVote = new ConcurrentHashMap();
    private static final AtomicReference<Boolean> unitTest = new AtomicReference<Object>(null);

    protected RuntimeMode(@Nullable RunMode run, @Nullable ApiMode api) {
        if (run != null) {
            runMode = run;
            runVote.clear();
        }
        if (api != null) {
            apiMode = api;
            apiVote.clear();
        }
    }

    @NotNull
    public static RunMode getRunMode() {
        return runMode;
    }

    public static boolean isRunMode(RunMode mode) {
        return runMode == mode;
    }

    public static boolean hasRunMode(RunMode ... modes) {
        RunMode thisMode = runMode;
        for (RunMode mode : modes) {
            if (thisMode != mode) continue;
            return true;
        }
        return false;
    }

    public static boolean isRunMode(CharSequence mode) {
        if (mode == null) {
            return false;
        }
        return StaticFlag.vote((String)runMode.name(), (String)mode.toString()) > 0;
    }

    public static boolean hasRunMode(CharSequence ... modes) {
        for (CharSequence mode : modes) {
            if (!RuntimeMode.isRunMode(mode)) continue;
            return true;
        }
        return false;
    }

    public static boolean voteRunMode(String votes) {
        return runVote.computeIfAbsent(votes, k -> StaticFlag.hasVote((String)runMode.name(), (String)k));
    }

    @NotNull
    public static ApiMode getApiMode() {
        return apiMode;
    }

    public static boolean isApiMode(ApiMode mode) {
        return apiMode == mode;
    }

    public static boolean hasApiMode(ApiMode ... modes) {
        ApiMode thisMode = apiMode;
        for (ApiMode mode : modes) {
            if (thisMode != mode) continue;
            return true;
        }
        return false;
    }

    public static boolean isApiMode(CharSequence mode) {
        if (mode == null) {
            return false;
        }
        return StaticFlag.vote((String)apiMode.name(), (String)mode.toString()) > 0;
    }

    public static boolean hasApiMode(CharSequence ... modes) {
        for (CharSequence mode : modes) {
            if (!RuntimeMode.isApiMode(mode)) continue;
            return true;
        }
        return false;
    }

    public static boolean voteApiMode(String votes) {
        return apiVote.computeIfAbsent(votes, k -> StaticFlag.hasVote((String)apiMode.name(), (String)k));
    }

    public static boolean isUnitTest() {
        Boolean b = unitTest.get();
        if (b == null) {
            b = false;
            for (StackTraceElement el : new RuntimeException().getStackTrace()) {
                if (!el.getClassName().startsWith("org.junit.")) continue;
                b = true;
                break;
            }
            unitTest.set(b);
        }
        return b;
    }
}

