/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.testing;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.slf4j.LoggerFactory;

public class AssertionLogger
extends AppenderBase<ILoggingEvent> {
    private final Map<String, Predicate<ILoggingEvent>> rules = new LinkedHashMap<String, Predicate<ILoggingEvent>>();
    private final Map<String, Integer> count = new LinkedHashMap<String, Integer>();

    public static AssertionLogger install() {
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        AssertionLogger memoryAppender = new AssertionLogger();
        memoryAppender.setContext((Context)((LoggerContext)LoggerFactory.getILoggerFactory()));
        root.addAppender((Appender)memoryAppender);
        return memoryAppender;
    }

    @Contract(value="_,_->this")
    public AssertionLogger rule(String name, Predicate<ILoggingEvent> rule) {
        this.rules.put(name, rule);
        this.count.put(name, 0);
        return this;
    }

    protected void append(ILoggingEvent event) {
        if (!this.isStarted()) {
            return;
        }
        for (Map.Entry<String, Predicate<ILoggingEvent>> en : this.rules.entrySet()) {
            if (!en.getValue().test(event)) continue;
            this.count.compute(en.getKey(), (s, c) -> c == null ? 1 : c + 1);
        }
    }

    public Map<String, Integer> getAssertCount() {
        return this.count;
    }

    public int getAssertCount(String name) {
        Integer c = this.count.get(name);
        return c == null ? 0 : c;
    }

    public boolean assertCount(int min) {
        for (Integer c : this.count.values()) {
            if (c != null && c >= min) continue;
            return false;
        }
        return true;
    }

    public String messageCount() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> en : this.count.entrySet()) {
            sb.append(",").append(en.getKey()).append(":").append(en.getValue());
        }
        return sb.isEmpty() ? "" : sb.substring(1);
    }

    public void resetAll() {
        this.rules.clear();
        this.count.clear();
    }

    public void resetCount() {
        this.count.clear();
    }

    public void uninstall() {
        this.resetAll();
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        Iterator iter = root.iteratorForAppenders();
        while (iter.hasNext()) {
            Appender apd = (Appender)iter.next();
            if (apd != this) continue;
            root.detachAppender(apd);
        }
    }
}

