/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.spring.bean;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pro.fessional.wings.silencer.message.MessageSourceHelper;
import pro.fessional.wings.silencer.runner.ApplicationInspectRunner;
import pro.fessional.wings.silencer.runner.ApplicationRunnerOrdered;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class SilencerConfiguration {
    private static final Log log = LogFactory.getLog(SilencerConfiguration.class);

    @Bean
    @ConditionalWingsEnabled
    public MessageSourceHelper messageSourceHelper(MessageSource messageSource) {
        MessageSourceHelper bean = new MessageSourceHelper(this, messageSource){};
        if (MessageSourceHelper.hasCombine) {
            log.info((Object)"Silencer spring-auto MessageSourceHelper parent to CombinableMessageSource");
        } else {
            log.info((Object)"Silencer spring-auto MessageSourceHelper skip CombinableMessageSource");
        }
        return bean;
    }

    @Bean
    @ConditionalWingsEnabled
    public ApplicationRunnerOrdered applicationInspectRunner(ApplicationContext context) {
        log.info((Object)"Silencer spring-runs applicationInspectRunner");
        return new ApplicationRunnerOrdered(Integer.MAX_VALUE, args -> {
            Map beans = context.getBeansOfType(ApplicationInspectRunner.class);
            if (beans.isEmpty()) {
                log.info((Object)"===>>> Silencer applicationInspectRunner empty");
                return;
            }
            log.info((Object)("===>>> Silencer applicationInspectRunner size=" + beans.size()));
            for (Map.Entry en : beans.entrySet()) {
                String name = (String)en.getKey();
                log.info((Object)(">>> inspect=" + name));
                try {
                    ((ApplicationInspectRunner)en.getValue()).run(args);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            log.info((Object)"===<<< Silencer applicationInspectRunner");
        });
    }
}

