/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.spring.bean;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import pro.fessional.wings.silencer.runner.ApplicationReadyEventRunner;
import pro.fessional.wings.silencer.runner.ApplicationStartedEventRunner;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;

@Configuration(proxyBeanMethods=false)
@ConditionalWingsEnabled
public class SilencerRunnerConfiguration {
    private static final Log log = LogFactory.getLog(SilencerRunnerConfiguration.class);

    @Configuration(proxyBeanMethods=false)
    @ConditionalWingsEnabled
    public static class StartedEvent {
        @EventListener
        public void on(ApplicationStartedEvent startedEvent) {
            ConfigurableApplicationContext context = startedEvent.getApplicationContext();
            Map beans = context.getBeansOfType(ApplicationStartedEventRunner.class);
            if (beans.isEmpty()) {
                log.info((Object)"===>>> Silencer applicationStartedEventRunner empty");
                return;
            }
            log.info((Object)("===>>> Silencer applicationStartedEventRunner size=" + beans.size()));
            ApplicationArguments args = (ApplicationArguments)context.getBean(ApplicationArguments.class);
            for (Map.Entry en : beans.entrySet()) {
                log.info((Object)(">>> started=" + (String)en.getKey()));
                try {
                    ((ApplicationStartedEventRunner)en.getValue()).run(args);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            log.info((Object)"===<<< Silencer applicationStartedEventRunner");
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalWingsEnabled
    public static class ReadyEvent {
        @EventListener
        public void on(ApplicationReadyEvent event) {
            ConfigurableApplicationContext context = event.getApplicationContext();
            Map beans = context.getBeansOfType(ApplicationReadyEventRunner.class);
            if (beans.isEmpty()) {
                log.info((Object)"===>>> Silencer applicationReadyEventRunner empty");
                return;
            }
            log.info((Object)("===>>> Silencer applicationReadyEventRunner size=" + beans.size()));
            ApplicationArguments args = (ApplicationArguments)context.getBean(ApplicationArguments.class);
            for (Map.Entry en : beans.entrySet()) {
                log.info((Object)(">>> ready=" + (String)en.getKey()));
                try {
                    ((ApplicationReadyEventRunner)en.getValue()).run(args);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            log.info((Object)"===<<< Silencer applicationReadyEventRunner");
        }
    }
}

