/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.spring.boot;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.silencer.spring.prop.SilencerConditionalProp;

@Order(value=-2147483578)
public class WingsEnabledCondition
extends SpringBootCondition {
    public static final String Prefix = "wings.enabled";
    private static final AntPathMatcher DotMatcher = new AntPathMatcher();
    private static final Map<String, Boolean> ErrorMap = new LinkedHashMap<String, Boolean>();
    private static final Map<String, String> PrefixMap = new LinkedHashMap<String, String>();
    private static final Map<String, Boolean> EnableMap = new LinkedHashMap<String, Boolean>();
    private static boolean Uninit = true;

    public static void reset() {
        Uninit = true;
        ErrorMap.clear();
        ErrorMap.clear();
        EnableMap.clear();
    }

    public static void mappingOnce(Environment env) {
        if (Uninit) {
            Uninit = false;
            SilencerConditionalProp prop = (SilencerConditionalProp)Binder.get((Environment)env).bind("wings.silencer.conditional", SilencerConditionalProp.class).orElseGet(SilencerConditionalProp::new);
            for (Map.Entry<String, Boolean> entry : prop.getError().entrySet()) {
                if (!StringUtils.hasText((String)entry.getKey()) || entry.getValue() == null) continue;
                ErrorMap.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : prop.getPrefix().entrySet()) {
                if (!StringUtils.hasText((String)entry.getKey()) || !StringUtils.hasText((String)((String)entry.getValue()))) continue;
                PrefixMap.put(entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry<String, Object> entry : prop.getEnable().entrySet()) {
                if (!StringUtils.hasText((String)entry.getKey()) || entry.getValue() == null) continue;
                EnableMap.put(entry.getKey(), (Boolean)entry.getValue());
            }
        }
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        WingsEnabledCondition.mappingOnce(context.getEnvironment());
        return this.conditionOutcome(context, metadata);
    }

    private ConditionOutcome conditionOutcome(@NotNull ConditionContext context, @NotNull AnnotatedTypeMetadata metadata) {
        Map attrs = metadata.getAnnotationAttributes(ConditionalWingsEnabled.class.getName());
        if (attrs == null) {
            return this.thisConditionOutcome(context, metadata, null);
        }
        ConditionOutcome outcome = this.thisConditionOutcome(context, metadata, attrs);
        if (outcome.isMatch()) {
            Object v;
            Object object = attrs.get("and");
            if (object instanceof Class[]) {
                Class[] ands;
                for (Class clazz : ands = (Class[])object) {
                    ConditionOutcome and = this.conditionOutcome(context, clazz);
                    if (and.isMatch()) continue;
                    return and;
                }
            }
            if ((v = attrs.get("not")) instanceof Class[]) {
                Class[] nots;
                for (Class clazz : nots = (Class[])v) {
                    ConditionOutcome not = this.conditionOutcome(context, clazz);
                    if (!not.isMatch()) continue;
                    return ConditionOutcome.noMatch((ConditionMessage)not.getConditionMessage());
                }
            }
        }
        return outcome;
    }

    private ConditionOutcome conditionOutcome(@NotNull ConditionContext context, Class<?> meta) {
        ConditionalWingsEnabled anno = meta.getAnnotation(ConditionalWingsEnabled.class);
        if (anno == null) {
            return this.thisConditionOutcome(context, meta, null);
        }
        ConditionOutcome thisCondition = this.thisConditionOutcome(context, meta, anno);
        if (thisCondition.isMatch()) {
            for (Class<?> clz : anno.and()) {
                ConditionOutcome and = this.conditionOutcome(context, clz);
                if (and.isMatch()) continue;
                return and;
            }
            for (Class<?> clz : anno.not()) {
                ConditionOutcome not = this.conditionOutcome(context, clz);
                if (!not.isMatch()) continue;
                return ConditionOutcome.noMatch((ConditionMessage)not.getConditionMessage());
            }
        }
        return thisCondition;
    }

    @NotNull
    private ConditionOutcome thisConditionOutcome(@NotNull ConditionContext context, @NotNull AnnotatedTypeMetadata metadata, @Nullable Map<String, Object> attrs) {
        Object id;
        if (metadata instanceof ClassMetadata) {
            ClassMetadata conf = (ClassMetadata)metadata;
            id = conf.getClassName();
        } else if (metadata instanceof MethodMetadata) {
            MethodMetadata bean = (MethodMetadata)metadata;
            id = bean.getDeclaringClassName() + "." + bean.getMethodName();
        } else {
            throw new IllegalArgumentException("should use on @Bean or @Configuration, metadata=" + String.valueOf(metadata));
        }
        try {
            Boolean value;
            Object object;
            ConditionOutcome result;
            String pre = this.buildPrefix((String)id);
            String[] keys = new String[3];
            keys[0] = pre + "." + (String)id;
            if (attrs != null) {
                String abs;
                Object object2 = attrs.get("abs");
                if (object2 instanceof String && !(abs = (String)object2).isBlank()) {
                    keys[1] = abs;
                } else {
                    String key;
                    object2 = attrs.get("key");
                    if (object2 instanceof String && !(key = (String)object2).isBlank()) {
                        keys[2] = pre + "." + key;
                    }
                }
            }
            if ((result = this.conditionOutcome(context, (String)id, keys)) != null) {
                return result;
            }
            boolean falsy = attrs != null && (object = attrs.get("value")) instanceof Boolean && (value = (Boolean)object) == false;
            return this.conditionOutcome(falsy);
        }
        catch (Throwable t) {
            return this.handleException((String)id, t);
        }
    }

    @NotNull
    private ConditionOutcome thisConditionOutcome(@NotNull ConditionContext context, @NotNull Class<?> meta, @Nullable ConditionalWingsEnabled anno) {
        String id = meta.getName();
        try {
            ConditionOutcome result;
            String pre = this.buildPrefix(id);
            String[] keys = new String[3];
            keys[0] = pre + "." + id;
            if (anno != null) {
                if (StringUtils.hasText((String)anno.abs())) {
                    keys[1] = anno.abs();
                } else if (StringUtils.hasText((String)anno.key())) {
                    keys[2] = pre + "." + anno.key();
                }
            }
            if ((result = this.conditionOutcome(context, id, keys)) != null) {
                return result;
            }
            boolean falsy = anno != null && !anno.value();
            return this.conditionOutcome(falsy);
        }
        catch (Throwable t) {
            return this.handleException(id, t);
        }
    }

    @NotNull
    private String buildPrefix(String key) {
        for (Map.Entry<String, String> en : PrefixMap.entrySet()) {
            if (!DotMatcher.match(en.getKey(), key)) continue;
            return en.getValue();
        }
        return Prefix;
    }

    @NotNull
    private ConditionOutcome handleException(String id, Throwable t) {
        for (Map.Entry<String, Boolean> en : ErrorMap.entrySet()) {
            if (!DotMatcher.match(en.getKey(), id)) continue;
            return en.getValue() == Boolean.TRUE ? ConditionOutcome.match((String)t.getMessage()) : ConditionOutcome.noMatch((String)t.getMessage());
        }
        throw new IllegalStateException("set wings.silencer.conditional.error[" + id + "]=true/false to skip error by match/no-match", t);
    }

    @Nullable
    private ConditionOutcome conditionOutcome(@NotNull ConditionContext context, String id, String @NotNull [] keys) {
        for (Map.Entry<String, Boolean> en : EnableMap.entrySet()) {
            String ek = en.getKey();
            if (!DotMatcher.match(ek, id)) continue;
            return en.getValue() == Boolean.TRUE ? ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalWingsEnabled.class, (Object[])new Object[0]).found(ek).items(new Object[]{true})) : ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalWingsEnabled.class, (Object[])new Object[0]).found(ek).items(new Object[]{false}));
        }
        Environment environment = context.getEnvironment();
        for (String key : keys) {
            Boolean enabled;
            if (key == null || (enabled = this.asBool(environment.getProperty(key))) == null) continue;
            return enabled != false ? ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalWingsEnabled.class, (Object[])new Object[0]).found(key).items(new Object[]{true})) : ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalWingsEnabled.class, (Object[])new Object[0]).found(key).items(new Object[]{false}));
        }
        return null;
    }

    @NotNull
    private ConditionOutcome conditionOutcome(boolean falsy) {
        return falsy ? ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalWingsEnabled.class, (Object[])new Object[0]).found("value").items(new Object[]{"false"})) : ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalWingsEnabled.class, (Object[])new Object[0]).because("default true"));
    }

    private Boolean asBool(String value) {
        if ("false".equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        if ("true".equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        return null;
    }
}

