/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.spring.boot;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import pro.fessional.mirana.cast.StringCastUtil;
import pro.fessional.mirana.data.Null;
import pro.fessional.mirana.text.WhiteUtil;
import pro.fessional.wings.silencer.spring.help.ApplicationContextHelper;

public class WingsSpringBeanScanner
implements ApplicationListener<ApplicationPreparedEvent> {
    private static final Log log = LogFactory.getLog(WingsSpringBeanScanner.class);

    public void onApplicationEvent(ApplicationPreparedEvent event) {
        ConfigurableApplicationContext context = event.getApplicationContext();
        new ApplicationContextHelper(this, context){};
        log.info((Object)"Wings bean init ApplicationContextHelper");
        if (!(context instanceof BeanDefinitionRegistry)) {
            return;
        }
        ConfigurableEnvironment env = context.getEnvironment();
        String enable = env.getProperty("wings.enabled.silencer.scanner");
        if (!StringCastUtil.asTrue((String)enable)) {
            log.info((Object)"Wings bean scanner is disabled, skip it.");
            return;
        }
        String pts = env.getProperty("wings.silencer.scanner.bean");
        String[] bns = pts == null ? Null.StrArr : pts.split("[, \t]+");
        LinkedHashSet<String> pks = new LinkedHashSet<String>();
        for (String s : bns) {
            if ((s = WhiteUtil.trim((CharSequence)s, (char[])new char[]{'/'})).isBlank()) continue;
            if (s.contains("*")) {
                throw new IllegalArgumentException("Wings bean MUST be plain path, NOT contain `*`, path=" + s);
            }
            pks.add(s);
        }
        if (pks.isEmpty()) {
            log.info((Object)"Wings bean scanner is empty, skip it.");
            return;
        }
        LinkedHashMap<String, String> pathPackage = new LinkedHashMap<String, String>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        ClassLoader loader = resolver.getClassLoader();
        long start = System.currentTimeMillis();
        String curPkg = null;
        try {
            long stt = start;
            Iterator iterator = pks.iterator();
            while (iterator.hasNext()) {
                Resource[] resources;
                String pk;
                curPkg = pk = (String)iterator.next();
                for (Resource res : resources = resolver.getResources("classpath*:/**/" + pk + "/**/*.class")) {
                    try {
                        String path = res.getURL().getPath();
                        this.guessClassPackage(pathPackage, path, loader, pk);
                    }
                    catch (IOException e) {
                        log.warn((Object)("failed to parse package name of res=" + res.getDescription()));
                    }
                }
                long end = System.currentTimeMillis();
                log.info((Object)("Wings scanned " + resources.length + " resources of /**/" + pk + "/**/, cost " + (end - stt) + " ms"));
                stt = end;
            }
        }
        catch (IOException e) {
            log.warn((Object)("failed to scan " + curPkg), (Throwable)e);
        }
        if (pathPackage.isEmpty()) {
            return;
        }
        CharSequence[] basePackages = (String[])pathPackage.values().toArray(String[]::new);
        log.info((Object)("Wings scan component base-package = " + String.join((CharSequence)",", basePackages)));
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner((BeanDefinitionRegistry)context);
        scanner.scan((String[])basePackages);
        log.info((Object)("Wings scanned component, total cost " + (System.currentTimeMillis() - start) + " ms"));
    }

    private void guessClassPackage(Map<String, String> map, String path, ClassLoader loader, String pkg) {
        int ps = path.lastIndexOf(pkg);
        for (String s : map.keySet()) {
            if (!path.startsWith(s)) continue;
            return;
        }
        int px = path.length() - 6;
        int p1 = path.lastIndexOf("!/");
        if (p1 >= 0 && p1 > px && this.packageName(map, loader, path, p1 + 2, ps, px)) {
            return;
        }
        int p2 = path.lastIndexOf("/classes/");
        if (p2 >= 0 && p2 > px && this.packageName(map, loader, path, p2 + 9, ps, px)) {
            return;
        }
        int off = ps - 1;
        while (off > 0) {
            int p3 = path.lastIndexOf(47, off);
            if (p3 > 0 && this.packageName(map, loader, path, p3 + 1, ps, px)) {
                return;
            }
            off = p3 - 1;
        }
    }

    private boolean packageName(Map<String, String> map, ClassLoader loader, String path, int p0, int ps, int px) {
        try {
            String name = path.substring(p0, px).replace('/', '.');
            Class<?> c = loader.loadClass(name);
            String pkg = c.getPackage().getName();
            map.put(path.substring(0, ps), pkg);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

