/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.spring.help;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import pro.fessional.mirana.bits.Bytes;

public class Utf8ResourceDecorator {
    private Utf8ResourceDecorator() {
    }

    public static Resource toUtf8(Resource res) throws IOException {
        String line;
        InputStream is = res.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        ByteArrayOutputStream bos = new ByteArrayOutputStream(is.available() * 2);
        byte[] buf = new byte[6];
        while ((line = br.readLine()) != null) {
            char m;
            String tl = line.trim();
            if (tl.isEmpty() || (m = tl.charAt(0)) == '#' || m == '!') continue;
            for (int i = 0; i < tl.length(); ++i) {
                char c = tl.charAt(i);
                int n = Bytes.unicode((char)c, (byte[])buf);
                bos.write(buf, 0, n);
            }
            bos.write(10);
        }
        return new ByteArrayResource(bos.toByteArray(), res.getFilename()){

            public String getFilename() {
                return this.getDescription();
            }
        };
    }
}

