/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.message;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.util.Assert;

public class CombinableMessageSource
extends AbstractMessageSource {
    private final ArrayList<OrderedMessageSource> orderedBrotherSources = new ArrayList(16);
    private final ConcurrentHashMap<String, ConcurrentHashMap<Locale, String>> codeLocaleString = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashMap<Locale, MessageFormat>> codeLocaleFormat = new ConcurrentHashMap();

    @Nullable
    protected String resolveCodeWithoutArguments(@NotNull String code, @NotNull Locale locale) {
        ConcurrentHashMap<Locale, String> cache = this.codeLocaleString.get(code);
        return cache == null ? null : cache.get(locale);
    }

    @Nullable
    protected MessageFormat resolveCode(@NotNull String code, @NotNull Locale locale) {
        ConcurrentHashMap<Locale, MessageFormat> cache = this.codeLocaleFormat.get(code);
        return cache == null ? null : cache.get(locale);
    }

    public void removeMessage(String code) {
        this.removeMessage(code, null);
    }

    public void removeMessage(String code, Locale locale) {
        if (code == null) {
            return;
        }
        if (locale == null) {
            this.codeLocaleString.remove(code);
            this.codeLocaleFormat.remove(code);
        } else {
            this.remove(this.codeLocaleString, code, locale);
            this.remove(this.codeLocaleFormat, code, locale);
        }
    }

    public void addMessage(String code, Locale locale, String msg) {
        Assert.notNull((Object)code, (String)"Code must not be null");
        Assert.notNull((Object)locale, (String)"Locale must not be null");
        Assert.notNull((Object)msg, (String)"Message must not be null");
        this.codeLocaleString.computeIfAbsent(code, key -> new ConcurrentHashMap()).putIfAbsent(locale, msg);
        this.codeLocaleFormat.computeIfAbsent(code, key -> new ConcurrentHashMap()).computeIfAbsent(locale, key -> this.createMessageFormat(msg, (Locale)key));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Added message [" + msg + "] for code [" + code + "] and Locale [" + String.valueOf(locale) + "]"));
        }
    }

    public void addMessage(Map<?, ?> messages, Locale locale) {
        Assert.notNull(messages, (String)"Messages Map must not be null");
        for (Map.Entry<?, ?> en : messages.entrySet()) {
            Object key = en.getKey();
            Object value = en.getValue();
            if (key == null || value == null) continue;
            this.addMessage(key.toString(), locale, value.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentMessageSource(@Nullable MessageSource parent) {
        ArrayList<OrderedMessageSource> arrayList = this.orderedBrotherSources;
        synchronized (arrayList) {
            int size = this.orderedBrotherSources.size();
            if (size == 0) {
                super.setParentMessageSource(parent);
            } else {
                this.orderedBrotherSources.get((int)(size - 1)).source.setParentMessageSource(parent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(HierarchicalMessageSource messageSource, int order) {
        Assert.notNull((Object)messageSource, (String)"messageSource must not be null");
        ArrayList<OrderedMessageSource> arrayList = this.orderedBrotherSources;
        synchronized (arrayList) {
            int size = this.orderedBrotherSources.size();
            MessageSource thatParent = size == 0 ? this.getParentMessageSource() : this.orderedBrotherSources.get((int)(size - 1)).source.getParentMessageSource();
            this.orderedBrotherSources.removeIf(o -> o.source == messageSource);
            if (order != Integer.MIN_VALUE) {
                this.orderedBrotherSources.add(new OrderedMessageSource(messageSource, order));
                this.orderedBrotherSources.sort(Comparator.comparingInt(o -> o.order));
            }
            for (int i = this.orderedBrotherSources.size() - 1; i >= 0; --i) {
                HierarchicalMessageSource source = this.orderedBrotherSources.get((int)i).source;
                source.setParentMessageSource(thatParent);
                thatParent = source;
            }
            super.setParentMessageSource(thatParent);
        }
    }

    public void removeMessage(HierarchicalMessageSource messageSource) {
        this.addMessage(messageSource, Integer.MIN_VALUE);
    }

    private <T extends Map<Locale, ?>> void remove(Map<String, T> map, String code, Locale locale) {
        Map mapStr = (Map)map.get(code);
        if (mapStr != null) {
            mapStr.remove(locale);
            if (mapStr.isEmpty()) {
                map.remove(code);
            }
        }
    }

    private record OrderedMessageSource(HierarchicalMessageSource source, int order) {
    }
}

