/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.spring.boot;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.PropertiesPropertySourceLoader;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;
import pro.fessional.mirana.cast.StringCastUtil;
import pro.fessional.mirana.i18n.LocaleResolver;
import pro.fessional.mirana.i18n.ZoneIdResolver;
import pro.fessional.mirana.pain.IORuntimeException;
import pro.fessional.mirana.time.ThreadNow;
import pro.fessional.wings.silencer.spring.boot.DeferredLogFactory;
import pro.fessional.wings.silencer.spring.boot.WingsEnabledCondition;
import pro.fessional.wings.silencer.spring.help.Utf8ResourceDecorator;
import pro.fessional.wings.silencer.spring.prop.SilencerEnabledProp;

public class WingsAutoConfigProcessor
implements EnvironmentPostProcessor {
    private static final DeferredLog log = DeferredLogFactory.getLog(WingsAutoConfigProcessor.class);
    public static final String WINGS_AUTO = "wings-auto-config*.cnf";
    public static final int NAKED_SEQ = 70;
    public static final String WINGS_I18N = "wings-i18n/**/*.properties";
    public static final String WINGS_ONCE_KEY = "wings.boot.once";
    public static final String WINGS_MORE_KEY = "wings.boot.more";
    public static final String BLOCK_LIST_KEY = "wings.boot.block";
    public static final String PROMO_PROP_KEY = "wings.boot.promo";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication ignored) {
        WingsEnabledCondition.reset();
        String en = environment.getProperty("wings.enabled.silencer.autoconf");
        if ("false".equalsIgnoreCase(en)) {
            log.info((Object)"\ud83e\udd81 Wings AutoConfig is disabled by property, skip it.");
            return;
        }
        if (!"true".equalsIgnoreCase(en) && !new SilencerEnabledProp().isAutoconf()) {
            log.info((Object)"\ud83e\udd81 Wings AutoConfig is disabled by default, skip it.");
            return;
        }
        this.processWingsConf(environment);
        this.processWingsI18n(environment);
    }

    public void processWingsI18n(ConfigurableEnvironment environment) {
        String zid;
        String lcl = environment.getProperty("wings.silencer.i18n.locale");
        if (lcl != null && !lcl.isEmpty()) {
            String cc;
            String ln = System.getProperty("user.language");
            String cn = System.getProperty("user.country");
            log.info((Object)("\ud83e\udd81 set wings-locale=" + lcl + ", current user.language=" + ln + ",user.country=" + cn));
            Locale loc = LocaleResolver.locale((String)lcl);
            String lc = loc.getLanguage();
            if (lc != null && !lc.isEmpty()) {
                System.setProperty("user.language", lc);
            }
            if ((cc = loc.getCountry()) != null && !cc.isEmpty()) {
                System.setProperty("user.country", cc);
            }
            Locale.setDefault(loc);
        }
        if ((zid = environment.getProperty("wings.silencer.i18n.zoneid")) != null && !zid.isEmpty()) {
            String tz = System.getProperty("user.timezone");
            log.info((Object)("\ud83e\udd81 set wings-zoneid=" + zid + ", current user.timezone=" + tz));
            System.setProperty("user.timezone", zid);
            TimeZone timeZone = ZoneIdResolver.timeZone((String)zid);
            TimeZone.setDefault(timeZone);
            ThreadNow.TweakZone.tweakGlobal((Object)timeZone);
        }
        LinkedHashSet<String> baseNames = new LinkedHashSet<String>();
        try {
            String bundle = environment.getProperty("wings.silencer.i18n.bundle");
            String[] paths = bundle == null || bundle.isEmpty() ? new String[]{"classpath*:/wings-i18n/**/*.properties"} : bundle.split(",");
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            for (String path : paths) {
                Resource[] resources;
                for (Resource res : resources = resolver.getResources(path.trim())) {
                    String fn = res.getURI().toString();
                    String baseName = this.parseBaseMessage(fn);
                    log.info((Object)("\ud83e\udd81 find wings-i18n base=" + baseName + ", path=" + fn));
                    baseNames.add(baseName);
                }
            }
        }
        catch (IOException e) {
            throw new IORuntimeException("failed to resolve wings i18n path", (Throwable)e);
        }
        if (baseNames.isEmpty()) {
            return;
        }
        String key = "spring.messages.basename";
        String mess = environment.getProperty(key);
        if (mess == null || mess.isEmpty()) {
            log.info((Object)"\ud83e\udd81 spring.messages.basename=");
        } else {
            Set old = StringUtils.commaDelimitedListToSet((String)StringUtils.trimAllWhitespace((String)mess));
            baseNames.addAll(old);
            log.info((Object)("\ud83e\udd81 spring.messages.basename=" + mess));
        }
        StringBuilder sb = new StringBuilder();
        for (String bn : baseNames) {
            sb.append(",");
            sb.append(bn);
            log.info((Object)("\ud83e\udd81 add messages.basename=" + bn + " to message source"));
        }
        System.setProperty(key, sb.substring(1, sb.length()));
    }

    private String parseBaseMessage(String path) {
        String lower = path.toLowerCase();
        int p1 = lower.indexOf("wings-i18n/");
        int p2 = lower.lastIndexOf(".properties");
        for (int i = 0; i < 2; ++i) {
            int x1 = p2 - 3;
            if (x1 <= p1) continue;
            char c1 = lower.charAt(x1);
            char c2 = lower.charAt(x1 + 1);
            char c3 = lower.charAt(x1 + 2);
            if (c1 != '_' || c2 < 'a' || c2 > 'z' || c3 < 'a' || c3 > 'z') continue;
            p2 = x1;
        }
        return path.substring(p1, p2);
    }

    public void processWingsConf(ConfigurableEnvironment environment) {
        MutablePropertySources propertySources = environment.getPropertySources();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        AutoConf autoConf = this.processWingsAuto(resolver);
        LinkedHashSet<ConfResource> confResources = this.scanWingsResource(propertySources, resolver, autoConf);
        HashMap<String, String> blockList = this.parseBlockList(confResources, autoConf.block);
        List<ConfResource> sortedResources = this.profileBlockSort(confResources, blockList, environment.getActiveProfiles());
        YamlPropertySourceLoader yamlLoader = new YamlPropertySourceLoader();
        PropertiesPropertySourceLoader propertyLoader = new PropertiesPropertySourceLoader();
        log.info((Object)"\ud83e\udd81 Wings append resorted resource, first is higher than last");
        TreeSet wingsKeys = new TreeSet();
        for (ConfResource confResource : sortedResources) {
            String key = confResource.location;
            Resource res = confResource.resource;
            try {
                List sourceList;
                if (this.isYml(key)) {
                    sourceList = yamlLoader.load(key, res);
                } else if (this.isProperty(key)) {
                    sourceList = propertyLoader.load(key, Utf8ResourceDecorator.toUtf8(res));
                } else {
                    log.info((Object)("\ud83e\udd81 skip unsupported resource=" + key));
                    continue;
                }
                log.info((Object)("\ud83e\udd81 Wings append source " + String.valueOf(confResource)));
                for (PropertySource source : sourceList) {
                    Object src = source.getSource();
                    if (src instanceof Map) {
                        wingsKeys.addAll(((Map)src).keySet());
                    }
                    propertySources.addLast(source);
                }
            }
            catch (IOException e2) {
                log.warn((Object)("\ud83e\udd81 Wings failed to load config=" + key), (Throwable)e2);
            }
        }
        Set<String> props = this.parsePromoProp(confResources, autoConf.promo);
        log.info((Object)("\ud83e\udd81 Wings promote property, keys count=" + props.size()));
        for (String prop : props) {
            String sys;
            String value = environment.getProperty(prop);
            if (!StringUtils.hasText((String)value) || StringUtils.hasText((String)(sys = System.getProperty(value)))) continue;
            log.info((Object)("\ud83e\udd81 Wings promote property to System. " + prop + "=" + value));
            System.setProperty(prop, value);
        }
        if (StringCastUtil.asTrue((String)environment.getProperty("wings.enabled.silencer.verbose")) && !wingsKeys.isEmpty()) {
            String string = wingsKeys.stream().map(e -> {
                String v = environment.getProperty(e.toString());
                return String.valueOf(e) + "=" + (v == null ? "" : v.replace("\n", "\\n"));
            }).collect(Collectors.joining("\n\t"));
            log.info((Object)("\ud83e\udd81\ud83e\udd81\ud83e\udd81 Wings conditional manager \ud83e\udd81\ud83e\udd81\ud83e\udd81\n\t" + string + "\n\ud83e\udd81\ud83e\udd81\ud83e\udd81"));
        }
    }

    @NotNull
    private HashMap<String, String> parseBlockList(Collection<ConfResource> sortedResources, String block) {
        HashMap<String, String> blockList = new HashMap<String, String>();
        Iterator<ConfResource> it = sortedResources.iterator();
        while (it.hasNext()) {
            ConfResource conf = it.next();
            if (!this.endsWithIgnoreCase(conf.location, block)) continue;
            try (InputStream is = conf.resource.getInputStream();){
                String line;
                BufferedReader buf = new BufferedReader(new InputStreamReader(is));
                int count = 0;
                while ((line = buf.readLine()) != null) {
                    String s = line.trim();
                    if (s.startsWith("#")) continue;
                    ++count;
                    blockList.put(s, conf.location);
                }
                log.info((Object)("\ud83e\udd81 find " + count + " blocks in block-list in " + String.valueOf(conf)));
            }
            catch (IOException e) {
                log.warn((Object)("\ud83e\udd81 failed to read block-list " + String.valueOf(conf)), (Throwable)e);
            }
            it.remove();
        }
        return blockList;
    }

    private Set<String> parsePromoProp(Collection<ConfResource> res, String promo) {
        HashSet<String> prop = new HashSet<String>();
        Iterator<ConfResource> it = res.iterator();
        while (it.hasNext()) {
            ConfResource conf = it.next();
            if (!this.endsWithIgnoreCase(conf.location, promo)) continue;
            try (InputStream is = conf.resource.getInputStream();){
                String line;
                BufferedReader buf = new BufferedReader(new InputStreamReader(is));
                int count = 0;
                while ((line = buf.readLine()) != null) {
                    String s = line.trim();
                    if (s.startsWith("#")) continue;
                    ++count;
                    prop.add(s);
                }
                log.info((Object)("\ud83e\udd81 find " + count + " props in promote-cnf in " + String.valueOf(conf)));
            }
            catch (IOException e) {
                log.warn((Object)("\ud83e\udd81 failed to read promote-cnf " + String.valueOf(conf)), (Throwable)e);
            }
            it.remove();
        }
        return prop;
    }

    private List<ConfResource> profileBlockSort(LinkedHashSet<ConfResource> confResources, HashMap<String, String> blockList, String[] activeProfs) {
        log.info((Object)("\ud83e\udd81 current active profile=[" + String.join((CharSequence)",", activeProfs) + "]"));
        Set profiledConf = confResources.stream().filter(it -> !it.profile.isEmpty()).collect(Collectors.toSet());
        if (!profiledConf.isEmpty()) {
            if (activeProfs.length == 0) {
                for (ConfResource cr : profiledConf) {
                    log.info((Object)("\ud83e\udd81 profile inactive [" + cr.profile + "] " + String.valueOf(cr)));
                    confResources.remove(cr);
                }
            } else {
                HashSet<String> prof = new HashSet<String>(Arrays.asList(activeProfs));
                HashSet<ConfResource> actProf = new HashSet<ConfResource>();
                for (ConfResource cr : profiledConf) {
                    if (cr.profile.isEmpty() || prof.contains(cr.profile)) {
                        actProf.add(cr);
                        continue;
                    }
                    log.info((Object)("\ud83e\udd81 profile inactive [" + cr.profile + "] " + String.valueOf(cr)));
                    confResources.remove(cr);
                }
                for (ConfResource cr : actProf) {
                    log.info((Object)("\ud83e\udd81 profile   active [" + cr.profile + "] " + String.valueOf(cr)));
                }
            }
        }
        LinkedHashMap<String, List> groups = new LinkedHashMap<String, List>(confResources.size());
        Function<String, List> newList = ignored -> new ArrayList();
        for (ConfResource cr : confResources) {
            String blocked = this.isBlockedBy(blockList, cr.location);
            if (blocked != null) {
                log.info((Object)("\ud83e\udd81 skip a blocked " + String.valueOf(cr) + " in " + blocked));
                continue;
            }
            groups.computeIfAbsent(cr.baseName, newList).add(cr);
        }
        ArrayList<ConfResource> sortedConf = new ArrayList<ConfResource>(confResources.size());
        Comparator sorter = (r1, r2) -> {
            if (r1.profile.isEmpty() && !r2.profile.isEmpty()) {
                return 1;
            }
            if (!r1.profile.isEmpty() && r2.profile.isEmpty()) {
                return -1;
            }
            int p0 = r2.profile.compareTo(r1.profile);
            if (p0 != 0) {
                return p0;
            }
            int n0 = Integer.compare(r1.nameSeq, r2.nameSeq);
            if (n0 != 0) {
                return n0;
            }
            return Integer.compare(r1.order, r2.order);
        };
        for (Map.Entry e : groups.entrySet()) {
            List crs = (List)e.getValue();
            int size = crs.size();
            if (size > 1) {
                log.info((Object)("\ud83e\udd81 resorted " + size + " basename by profile,seq " + (String)e.getKey()));
                crs.sort(sorter);
            }
            sortedConf.addAll(crs);
        }
        return sortedConf;
    }

    /*
     * WARNING - void declaration
     */
    private LinkedHashSet<ConfResource> scanWingsResource(MutablePropertySources sources, PathMatchingResourcePatternResolver resolver, AutoConf autoConf) {
        void var7_13;
        LinkedHashSet<String> sortedPath = new LinkedHashSet<String>();
        for (PropertySource next : sources) {
            String[] parts;
            void var7_9;
            Object object = next.getProperty("spring.config.location");
            if (object == null) {
                Object object2 = next.getProperty("SPRING_CONFIG_LOCATION");
            }
            if (var7_9 == null) continue;
            String[] stringArray = parts = var7_9.toString().split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String s = stringArray[i];
                this.putPathIfValid(sortedPath, s.trim());
            }
        }
        String[] stringArray = "classpath:/,classpath:/config/,file:./,file:./config/".split(",");
        int n = stringArray.length;
        boolean bl = false;
        while (var7_13 < n) {
            String s = stringArray[var7_13];
            this.putPathIfValid(sortedPath, s.trim());
            ++var7_13;
        }
        LinkedHashSet<ConfResource> confResources = new LinkedHashSet<ConfResource>();
        for (String string : sortedPath) {
            void var7_19;
            void var7_16;
            if (string.startsWith("optional:")) {
                String string2 = string.substring(9);
            }
            if (var7_16.startsWith("classpath:")) {
                String string3 = var7_16.replace("classpath:", "classpath*:");
            } else if (!var7_16.contains(":")) {
                String string4 = "file:" + (String)var7_16;
            }
            log.info((Object)("\ud83e\udd81 Wings scan path=" + (String)var7_19));
            if (var7_19.endsWith("/") || var7_19.endsWith("\\")) {
                for (String auto : autoConf.onces) {
                    this.putConfIfValid(false, confResources, resolver, (String)var7_19 + auto, autoConf);
                }
                for (String more : autoConf.mores) {
                    this.putConfIfValid(true, confResources, resolver, (String)var7_19 + more, autoConf);
                }
                continue;
            }
            this.putConfIfValid(true, confResources, resolver, (String)var7_19, autoConf);
        }
        return confResources;
    }

    private AutoConf processWingsAuto(PathMatchingResourcePatternResolver resolver) {
        Resource resource = null;
        try {
            Resource[] rss = resolver.getResources("classpath*:/wings-auto-config*.cnf");
            int len = rss.length;
            if (len == 1) {
                resource = rss[0];
            } else if (len > 1) {
                Arrays.sort(rss, (o1, o2) -> {
                    if (!o1.isReadable()) {
                        return -1;
                    }
                    if (!o2.isReadable()) {
                        return 1;
                    }
                    String f1 = o1.getFilename();
                    if (f1 == null) {
                        return -1;
                    }
                    String f2 = o2.getFilename();
                    if (f2 == null) {
                        return 1;
                    }
                    return f1.compareTo(f2);
                });
                resource = rss[len - 1];
            }
        }
        catch (IOException e) {
            log.warn((Object)"failed to get wings-auto-config*.cnf from classpath*:/", (Throwable)e);
        }
        if (resource == null) {
            resource = resolver.getResource(WINGS_AUTO);
        }
        AutoConf autoConf = new AutoConf();
        if (resource.isReadable()) {
            try {
                String pk;
                String bk;
                String mk;
                Properties prop = new Properties();
                prop.load(resource.getInputStream());
                String ck = prop.getProperty(WINGS_ONCE_KEY);
                if (StringUtils.hasText((String)ck)) {
                    log.info((Object)("\ud83e\udd81 use wings.boot.once=" + ck));
                    autoConf.onces = ck.trim().split("[, \t\r\n]+");
                }
                if (StringUtils.hasText((String)(mk = prop.getProperty(WINGS_MORE_KEY)))) {
                    log.info((Object)("\ud83e\udd81 use wings.boot.more=" + mk));
                    autoConf.mores = mk.trim().split("[, \t\r\n]+");
                }
                if (StringUtils.hasText((String)(bk = prop.getProperty(BLOCK_LIST_KEY)))) {
                    log.info((Object)("\ud83e\udd81 use wings.boot.block=" + bk));
                    autoConf.block = bk.trim();
                }
                if (StringUtils.hasText((String)(pk = prop.getProperty(PROMO_PROP_KEY)))) {
                    log.info((Object)("\ud83e\udd81 use wings.boot.promo=" + pk));
                    autoConf.promo = pk.trim();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("failed to load wings-auto-config*.cnf", e);
            }
        }
        return autoConf;
    }

    private void putPathIfValid(LinkedHashSet<String> path, String conf) {
        if (((String)conf).isEmpty() || this.isYml((String)conf) || this.isProperty((String)conf)) {
            return;
        }
        if (!((String)conf).endsWith("/")) {
            conf = (String)conf + "/";
        }
        path.add((String)conf);
    }

    private void putConfIfValid(boolean more, LinkedHashSet<ConfResource> confResources, PathMatchingResourcePatternResolver resolver, String path, AutoConf autoConf) {
        try {
            for (Resource res : resolver.getResources(path)) {
                String url;
                if (!res.isReadable() || !this.isYml(url = res.getURL().getPath()) && !this.isProperty(url) && !this.endsWithIgnoreCase(url, autoConf.block, autoConf.promo)) continue;
                ConfResource conf = new ConfResource(res, url, more);
                if (more) {
                    log.info((Object)("\ud83e\udd81 Wings find " + String.valueOf(conf)));
                    confResources.add(conf);
                    continue;
                }
                if (confResources.contains(conf)) {
                    log.info((Object)("\ud83e\udd81 Wings skip " + String.valueOf(conf)));
                    continue;
                }
                log.info((Object)("\ud83e\udd81 Wings find " + String.valueOf(conf)));
                confResources.add(conf);
            }
        }
        catch (IOException e) {
            log.info((Object)("\ud83e\udd81 Wings failed to find config from path=" + path));
        }
    }

    private String isBlockedBy(HashMap<String, String> blockList, String file) {
        for (Map.Entry<String, String> entry : blockList.entrySet()) {
            if (!file.endsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private boolean isYml(String file) {
        return this.endsWithIgnoreCase(file, ".yml", ".yaml");
    }

    private boolean isProperty(String file) {
        return this.endsWithIgnoreCase(file, ".properties", ".xml");
    }

    private boolean endsWithIgnoreCase(String str, String ... ends) {
        for (String end : ends) {
            int e1 = end.length();
            int e2 = str.length() - e1;
            if (e2 < 0) continue;
            boolean allMatch = true;
            for (int i = 0; i < e1; ++i) {
                char c2;
                char c1 = end.charAt(i);
                if (c1 == (c2 = str.charAt(i + e2)) || Character.toUpperCase(c1) == Character.toUpperCase(c2)) continue;
                allMatch = false;
                break;
            }
            if (!allMatch) continue;
            return true;
        }
        return false;
    }

    private static class AutoConf {
        private String[] onces = new String[]{"git.properties", "META-INF/build-info.properties"};
        private String[] mores = new String[]{"application*.*", "wings-conf/**/*.*"};
        private String block = "wings-conf-block-list.cnf";
        private String promo = "wings-prop-promotion.cnf";

        private AutoConf() {
        }
    }

    private static class ConfResource {
        private static final Pattern springProfile = Pattern.compile("^application(-.+)?$");
        private static final Pattern wingsProfile = Pattern.compile("(-\\d{2,})?(@.+)?$");
        private static final AtomicInteger seqs = new AtomicInteger(0);
        private final int order = seqs.incrementAndGet();
        private final String location;
        private final Resource resource;
        private final String fullName;
        private final boolean more;
        private String baseName;
        private int nameSeq = 70;
        private String profile = "";

        public ConfResource(Resource res, String url, boolean more) {
            this.location = url;
            this.resource = res;
            this.more = more;
            int p1 = Math.max(url.lastIndexOf(47), url.lastIndexOf(92));
            this.fullName = p1 >= 0 ? url.substring(p1 + 1) : url;
            int pe = this.fullName.lastIndexOf(46);
            this.baseName = pe > 0 ? this.fullName.substring(0, pe) : this.fullName;
            Matcher mt = springProfile.matcher(this.baseName);
            if (mt.find()) {
                String g1 = mt.group(1);
                if (g1 != null) {
                    this.profile = g1.substring(1);
                    this.baseName = this.baseName.substring(0, mt.start(1));
                }
            } else {
                mt = wingsProfile.matcher(this.baseName);
                if (mt.find()) {
                    String g2;
                    String g1 = mt.group(1);
                    if (g1 != null) {
                        this.nameSeq = Integer.parseInt(g1.substring(1));
                    }
                    if ((g2 = mt.group(2)) != null) {
                        this.profile = g2.substring(1);
                    }
                    if (g1 != null || g2 != null) {
                        this.baseName = this.baseName.substring(0, mt.start());
                    }
                }
            }
        }

        public int hashCode() {
            return this.more ? this.location.hashCode() : this.fullName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConfResource) {
                ConfResource ot = (ConfResource)obj;
                return this.more ? this.location.equals(ot.location) : this.fullName.equals(ot.fullName);
            }
            return false;
        }

        public String toString() {
            return String.format("[%03d] %s\ud83e\udd81%s", this.order, this.fullName, this.location);
        }
    }
}

