/*
 * Decompiled with CFR 0.152.
 */
package pro.fessional.wings.silencer.spring.boot;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.StringUtils;
import pro.fessional.wings.silencer.spring.boot.ConditionalWingsEnabled;
import pro.fessional.wings.silencer.spring.boot.WingsEnabledContext;
import pro.fessional.wings.silencer.spring.prop.SilencerFeatureProp;

@Order(value=-2147483578)
public class WingsEnabledCondition
extends SpringBootCondition {
    private static boolean Uninit = true;

    public static void reset() {
        Uninit = true;
        WingsEnabledContext.reset();
    }

    public static void mappingOnce(Environment env) {
        if (Uninit) {
            Uninit = false;
            WingsEnabledContext.setEnabledProvider(arg_0 -> ((Environment)env).getProperty(arg_0));
            SilencerFeatureProp prop = (SilencerFeatureProp)Binder.get((Environment)env).bind("wings.feature", SilencerFeatureProp.class).orElseGet(SilencerFeatureProp::new);
            for (Map.Entry<String, Boolean> entry : prop.getError().entrySet()) {
                if (!StringUtils.hasText((String)entry.getKey()) || entry.getValue() == null) continue;
                WingsEnabledContext.putFeatureError(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : prop.getPrefix().entrySet()) {
                if (!StringUtils.hasText((String)entry.getKey()) || !StringUtils.hasText((String)((String)entry.getValue()))) continue;
                WingsEnabledContext.putFeaturePrefix(entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry<String, Object> entry : prop.getEnable().entrySet()) {
                if (!StringUtils.hasText((String)entry.getKey()) || entry.getValue() == null) continue;
                WingsEnabledContext.putFeatureEnable(entry.getKey(), (Boolean)entry.getValue());
            }
        }
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        WingsEnabledCondition.mappingOnce(context.getEnvironment());
        return this.conditionOutcome(metadata);
    }

    private ConditionOutcome conditionOutcome(@NotNull AnnotatedTypeMetadata metadata) {
        Map attrs = metadata.getAnnotationAttributes(ConditionalWingsEnabled.class.getName());
        if (attrs == null) {
            return this.thisConditionOutcome(metadata, null);
        }
        ConditionOutcome outcome = this.thisConditionOutcome(metadata, attrs);
        if (outcome.isMatch()) {
            Object v;
            Object object = attrs.get("and");
            if (object instanceof Class[]) {
                Class[] ands;
                for (Class clazz : ands = (Class[])object) {
                    ConditionOutcome and = this.conditionOutcome(clazz);
                    if (and.isMatch()) continue;
                    return and;
                }
            }
            if ((v = attrs.get("not")) instanceof Class[]) {
                Class[] nots;
                for (Class clazz : nots = (Class[])v) {
                    ConditionOutcome not = this.conditionOutcome(clazz);
                    if (!not.isMatch()) continue;
                    return ConditionOutcome.noMatch((ConditionMessage)not.getConditionMessage());
                }
            }
        }
        return outcome;
    }

    private ConditionOutcome conditionOutcome(Class<?> meta) {
        ConditionalWingsEnabled anno = meta.getAnnotation(ConditionalWingsEnabled.class);
        if (anno == null) {
            return this.thisConditionOutcome(meta, null);
        }
        ConditionOutcome thisCondition = this.thisConditionOutcome(meta, anno);
        if (thisCondition.isMatch()) {
            for (Class<?> clz : anno.and()) {
                ConditionOutcome and = this.conditionOutcome(clz);
                if (and.isMatch()) continue;
                return and;
            }
            for (Class<?> clz : anno.not()) {
                ConditionOutcome not = this.conditionOutcome(clz);
                if (!not.isMatch()) continue;
                return ConditionOutcome.noMatch((ConditionMessage)not.getConditionMessage());
            }
        }
        return thisCondition;
    }

    @NotNull
    private ConditionOutcome thisConditionOutcome(@NotNull AnnotatedTypeMetadata metadata, @Nullable Map<String, Object> attrs) {
        Object id;
        if (metadata instanceof ClassMetadata) {
            ClassMetadata conf = (ClassMetadata)metadata;
            id = conf.getClassName();
        } else if (metadata instanceof MethodMetadata) {
            MethodMetadata bean = (MethodMetadata)metadata;
            id = bean.getDeclaringClassName() + "." + bean.getMethodName();
        } else {
            throw new IllegalArgumentException("should use on @Bean or @Configuration, metadata=" + String.valueOf(metadata));
        }
        try {
            Boolean value;
            Object object;
            ConditionOutcome result;
            String pre = WingsEnabledContext.handlePrefix((String)id);
            String[] keys = new String[3];
            keys[0] = pre + "." + (String)id;
            if (attrs != null) {
                String abs;
                Object object2 = attrs.get("abs");
                if (object2 instanceof String && !(abs = (String)object2).isBlank()) {
                    keys[1] = abs;
                } else {
                    String key;
                    object2 = attrs.get("key");
                    if (object2 instanceof String && !(key = (String)object2).isBlank()) {
                        keys[2] = pre + "." + key;
                    }
                }
            }
            if ((result = this.conditionOutcome((String)id, keys)) != null) {
                return result;
            }
            boolean falsy = attrs != null && (object = attrs.get("value")) instanceof Boolean && (value = (Boolean)object) == false;
            return this.conditionOutcome(falsy);
        }
        catch (Throwable t) {
            return this.handleException((String)id, t);
        }
    }

    @NotNull
    private ConditionOutcome thisConditionOutcome(@NotNull Class<?> meta, @Nullable ConditionalWingsEnabled anno) {
        String id = meta.getName();
        try {
            ConditionOutcome result;
            String pre = WingsEnabledContext.handlePrefix(id);
            String[] keys = new String[3];
            keys[0] = pre + "." + id;
            if (anno != null) {
                if (StringUtils.hasText((String)anno.abs())) {
                    keys[1] = anno.abs();
                } else if (StringUtils.hasText((String)anno.key())) {
                    keys[2] = pre + "." + anno.key();
                }
            }
            if ((result = this.conditionOutcome(id, keys)) != null) {
                return result;
            }
            boolean falsy = anno != null && !anno.value();
            return this.conditionOutcome(falsy);
        }
        catch (Throwable t) {
            return this.handleException(id, t);
        }
    }

    @NotNull
    private ConditionOutcome handleException(String id, Throwable t) {
        Boolean b = WingsEnabledContext.handleError(id);
        if (b == null) {
            throw new IllegalStateException("set wings.feature.error[" + id + "]=true/false to skip error by match/no-match", t);
        }
        return b != false ? ConditionOutcome.match((String)t.getMessage()) : ConditionOutcome.noMatch((String)t.getMessage());
    }

    @Nullable
    private ConditionOutcome conditionOutcome(String id, String @NotNull [] keys) {
        for (String key : keys) {
            Boolean bb;
            if (key == null || (bb = WingsEnabledContext.handleEnabled(key)) == null) continue;
            return bb != false ? ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalWingsEnabled.class, (Object[])new Object[0]).found(key).items(new Object[]{true})) : ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalWingsEnabled.class, (Object[])new Object[0]).found(key).items(new Object[]{false}));
        }
        Boolean bf = WingsEnabledContext.handleFeature(id);
        if (bf != null) {
            return bf != false ? ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalWingsEnabled.class, (Object[])new Object[0]).found(id).items(new Object[]{true})) : ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalWingsEnabled.class, (Object[])new Object[0]).found(id).items(new Object[]{false}));
        }
        return null;
    }

    @NotNull
    private ConditionOutcome conditionOutcome(boolean falsy) {
        return falsy ? ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalWingsEnabled.class, (Object[])new Object[0]).found("value").items(new Object[]{"false"})) : ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalWingsEnabled.class, (Object[])new Object[0]).because("default true"));
    }
}

